/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.client.updater;

import com.craftingdead.core.client.updater.JarManager;
import com.craftingdead.core.client.updater.RemoteVersionFetcher;
import com.craftingdead.core.client.updater.UpdateNotificationScreen;
import com.craftingdead.core.client.updater.UpdatePromptScreen;
import com.craftingdead.core.client.updater.VersionComparator;
import com.mojang.logging.LogUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import org.slf4j.Logger;

public class ModAutoUpdater {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final List<String> MONITORED_MODS = Arrays.asList("crafting-dead-core", "crafting-dead-decoration", "crafting-dead-immerse", "crafting-dead-survival", "rocket-connector");
    private static final Pattern LOCAL_VERSION_PATTERN = Pattern.compile("([a-z\\-]+)-(\\d+\\.\\d+\\.\\d+)-(\\d+\\.\\d+\\.\\d+(?:\\.\\d+)?(?:\\.\\d+)?)(?:-all)?\\.jar");
    private static boolean updatesDownloaded = false;
    private static final List<String> updatedMods = new ArrayList<String>();
    private static final Map<String, UpdateInfo> availableUpdates = new HashMap<String, UpdateInfo>();

    public static void checkForUpdates() {
        LOGGER.info("Starting auto-updater for Crafting Dead mods...");
        CompletableFuture.runAsync(() -> {
            try {
                ModAutoUpdater.performUpdateCheck();
            }
            catch (Exception e) {
                LOGGER.error("Error during update check", (Throwable)e);
            }
        });
    }

    public static void downloadAllUpdates() {
        if (availableUpdates.isEmpty()) {
            LOGGER.info("No updates to download.");
            return;
        }
        CompletableFuture.runAsync(() -> {
            try {
                File modsFolder = ModAutoUpdater.getModsFolder();
                if (modsFolder == null) {
                    LOGGER.error("Mods folder not found!");
                    return;
                }
                LOGGER.info("Downloading {} updates...", (Object)availableUpdates.size());
                for (Map.Entry<String, UpdateInfo> entry : availableUpdates.entrySet()) {
                    String modId = entry.getKey();
                    UpdateInfo info = entry.getValue();
                    try {
                        ModAutoUpdater.performDownload(modId, info, modsFolder);
                    }
                    catch (Exception e) {
                        LOGGER.error("Failed to download update for {}", (Object)modId, (Object)e);
                    }
                }
                if (updatesDownloaded) {
                    LOGGER.info("All updates downloaded successfully.");
                    LOGGER.info("Updated mods: {}", (Object)String.join((CharSequence)", ", updatedMods));
                    Minecraft.m_91087_().execute(() -> {
                        Screen currentScreen = Minecraft.m_91087_().f_91080_;
                        Minecraft.m_91087_().m_91152_((Screen)new UpdateNotificationScreen(currentScreen, updatedMods));
                    });
                }
            }
            catch (Exception e) {
                LOGGER.error("Error during update download", (Throwable)e);
            }
        });
    }

    private static void performUpdateCheck() {
        File modsFolder = ModAutoUpdater.getModsFolder();
        if (modsFolder == null || !modsFolder.exists()) {
            LOGGER.error("Mods folder not found!");
            return;
        }
        LOGGER.info("Checking for updates in: {}", (Object)modsFolder.getAbsolutePath());
        availableUpdates.clear();
        for (String modId : MONITORED_MODS) {
            try {
                ModAutoUpdater.checkForModUpdate(modId, modsFolder);
            }
            catch (Exception e) {
                LOGGER.error("Failed to check mod: {}", (Object)modId, (Object)e);
            }
        }
        if (!availableUpdates.isEmpty()) {
            LOGGER.info("{} mod update(s) available. Prompting user...", (Object)availableUpdates.size());
            Minecraft.m_91087_().execute(() -> {
                Screen currentScreen = Minecraft.m_91087_().f_91080_;
                Minecraft.m_91087_().m_91152_((Screen)new UpdatePromptScreen(currentScreen, availableUpdates));
            });
        } else {
            LOGGER.info("All mods are up to date.");
        }
    }

    private static void checkForModUpdate(String modId, File modsFolder) {
        LOGGER.info("Checking updates for {}...", (Object)modId);
        ModVersion localVersion = ModAutoUpdater.getLocalVersion(modId, modsFolder);
        if (localVersion == null) {
            LOGGER.info("Mod {} not found locally, skipping update check.", (Object)modId);
            return;
        }
        LOGGER.info("Local version: {}", (Object)localVersion.version);
        String remoteVersion = RemoteVersionFetcher.getLatestVersion(modId);
        if (remoteVersion == null) {
            LOGGER.warn("Could not fetch remote version for {}", (Object)modId);
            return;
        }
        LOGGER.info("Remote version: {}", (Object)remoteVersion);
        if (VersionComparator.isNewer(remoteVersion, localVersion.version)) {
            LOGGER.info("Update available! {} -> {}", (Object)localVersion.version, (Object)remoteVersion);
            availableUpdates.put(modId, new UpdateInfo(localVersion, remoteVersion));
        } else {
            LOGGER.info("Mod {} is up to date.", (Object)modId);
        }
    }

    private static void performDownload(String modId, UpdateInfo info, File modsFolder) {
        String newVersion = info.remoteVersion;
        ModVersion oldVersion = info.localVersion;
        try {
            String downloadUrl = RemoteVersionFetcher.getDownloadUrl(modId, newVersion);
            String newFileName = modId + "-1.18.2-" + newVersion + ".jar";
            File newFile = new File(modsFolder, newFileName);
            LOGGER.info("Downloading update from: {}", (Object)downloadUrl);
            URL url = new URL(downloadUrl);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setConnectTimeout(15000);
            connection.setReadTimeout(30000);
            connection.setRequestProperty("User-Agent", "CraftingDead-ModUpdater/1.0");
            int responseCode = connection.getResponseCode();
            if (responseCode != 200) {
                LOGGER.error("Failed to download update. HTTP {}", (Object)responseCode);
                return;
            }
            try (InputStream in = connection.getInputStream();
                 FileOutputStream out = new FileOutputStream(newFile);){
                int bytesRead;
                byte[] buffer = new byte[8192];
                long totalBytes = 0L;
                while ((bytesRead = in.read(buffer)) != -1) {
                    out.write(buffer, 0, bytesRead);
                    totalBytes += (long)bytesRead;
                }
                LOGGER.info("Downloaded {} bytes to {}", (Object)totalBytes, (Object)newFileName);
            }
            int deletedCount = JarManager.deleteOldVersions(modId, modsFolder.toPath());
            LOGGER.info("Deleted {} old version(s) of {}", (Object)deletedCount, (Object)modId);
            updatesDownloaded = true;
            updatedMods.add(modId + " (" + oldVersion.version + " \u2192 " + newVersion + ")");
            LOGGER.info("Update completed for {}!", (Object)modId);
        }
        catch (Exception e) {
            LOGGER.error("Failed to download update for {}", (Object)modId, (Object)e);
        }
    }

    private static ModVersion getLocalVersion(String modId, File modsFolder) {
        File[] files = modsFolder.listFiles();
        if (files == null) {
            return null;
        }
        for (File file : files) {
            Matcher matcher;
            if (!file.getName().endsWith(".jar") || !(matcher = LOCAL_VERSION_PATTERN.matcher(file.getName())).find()) continue;
            String fileModId = matcher.group(1);
            String mcVersion = matcher.group(2);
            String modVersion = matcher.group(3);
            if (!fileModId.equals(modId) || !mcVersion.equals("1.18.2")) continue;
            return new ModVersion(modVersion, file);
        }
        return null;
    }

    private static File getModsFolder() {
        try {
            File gameDirMods;
            Path currentPath = Paths.get(".", new String[0]).toAbsolutePath().normalize();
            File modsFolder = new File(currentPath.toFile(), "mods");
            if (modsFolder.exists() && modsFolder.isDirectory()) {
                return modsFolder;
            }
            File parentMods = new File(currentPath.getParent().toFile(), "mods");
            if (parentMods.exists() && parentMods.isDirectory()) {
                return parentMods;
            }
            String gameDir = System.getProperty("minecraft.gameDir");
            if (gameDir != null && (gameDirMods = new File(gameDir, "mods")).exists() && gameDirMods.isDirectory()) {
                return gameDirMods;
            }
        }
        catch (Exception e) {
            LOGGER.error("Error locating mods folder", (Throwable)e);
        }
        return null;
    }

    public static boolean hasUpdates() {
        return updatesDownloaded;
    }

    public static List<String> getUpdatedMods() {
        return new ArrayList<String>(updatedMods);
    }

    public static class ModVersion {
        public final String version;

        ModVersion(String version, File file) {
            this.version = version;
        }
    }

    public static class UpdateInfo {
        public final ModVersion localVersion;
        public final String remoteVersion;

        public UpdateInfo(ModVersion localVersion, String remoteVersion) {
            this.localVersion = localVersion;
            this.remoteVersion = remoteVersion;
        }
    }
}

