/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.client.updater;

import com.craftingdead.core.client.updater.VersionComparator;
import com.mojang.logging.LogUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;

public class JarManager {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Pattern JAR_PATTERN = Pattern.compile("([a-z\\-]+)-(\\d+\\.\\d+\\.\\d+)-(\\d+\\.\\d+\\.\\d+\\.\\d+)(?:-[a-z]+)?\\.jar");

    public static int deleteOldVersions(String modId, Path modsDir) {
        if (!Files.exists(modsDir, new LinkOption[0]) || !Files.isDirectory(modsDir, new LinkOption[0])) {
            LOGGER.warn("Mods directory does not exist: {}", (Object)modsDir);
            return 0;
        }
        List<JarInfo> jars = JarManager.findModJars(modId, modsDir);
        if (jars.isEmpty()) {
            LOGGER.debug("No JARs found for mod: {}", (Object)modId);
            return 0;
        }
        jars.sort(Comparator.comparing(JarInfo::version, VersionComparator::compare).reversed());
        JarInfo newest = jars.get(0);
        LOGGER.info("Keeping newest version: {}", (Object)newest.file.getName());
        int deletedCount = 0;
        for (int i = 1; i < jars.size(); ++i) {
            JarInfo old = jars.get(i);
            try {
                Files.delete(old.file.toPath());
                LOGGER.info("Deleted old version: {}", (Object)old.file.getName());
                ++deletedCount;
                continue;
            }
            catch (IOException e) {
                LOGGER.error("Failed to delete old JAR: {}", (Object)old.file.getName(), (Object)e);
            }
        }
        return deletedCount;
    }

    private static List<JarInfo> findModJars(String modId, Path modsDir) {
        ArrayList<JarInfo> jars = new ArrayList<JarInfo>();
        File[] files = modsDir.toFile().listFiles();
        if (files == null) {
            return jars;
        }
        for (File file : files) {
            Matcher matcher;
            if (!file.isFile() || !file.getName().endsWith(".jar") || !(matcher = JAR_PATTERN.matcher(file.getName())).matches()) continue;
            String fileModId = matcher.group(1);
            String modVersion = matcher.group(3);
            if (!fileModId.equals(modId)) continue;
            jars.add(new JarInfo(file, modVersion));
        }
        return jars;
    }

    public static boolean isFileLocked(File file) {
        boolean locked;
        if (!file.exists()) {
            return false;
        }
        File temp = new File(file.getAbsolutePath() + ".lock-test");
        boolean bl = locked = !file.renameTo(temp);
        if (!locked && temp.exists()) {
            temp.renameTo(file);
        }
        return locked;
    }

    public static boolean deleteWithRetry(File file, int maxRetries) {
        for (int i = 0; i < maxRetries; ++i) {
            try {
                Files.delete(file.toPath());
                LOGGER.info("Deleted JAR: {}", (Object)file.getName());
                return true;
            }
            catch (IOException e) {
                LOGGER.warn("Failed to delete {} (attempt {}/{})", new Object[]{file.getName(), i + 1, maxRetries});
                if (i >= maxRetries - 1) continue;
                try {
                    Thread.sleep(500L);
                    continue;
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    return false;
                }
            }
        }
        return false;
    }

    private static class JarInfo {
        final File file;
        final String version;

        JarInfo(File file, String version) {
            this.file = file;
            this.version = version;
        }

        String version() {
            return this.version;
        }
    }
}

