/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.world.item.equipment;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;

@FunctionalInterface
public interface Equipment {
    public static final Capability<Equipment> CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<Equipment>(){});

    default public Multimap<Attribute, AttributeModifier> attributeModifiers() {
        return ImmutableMultimap.of();
    }

    public boolean isValidForSlot(Slot var1);

    public static Equipment forSlot(Slot slot) {
        return slot::equals;
    }

    public static enum Slot {
        MELEE(0),
        GUN(1),
        HAT(2),
        CLOTHING(3),
        VEST(4),
        BACKPACK(5);

        private final int index;

        private Slot(int index) {
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }
    }
}

