/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.world.action;

import com.craftingdead.core.ServerConfig;
import com.craftingdead.core.client.animation.Animation;
import com.craftingdead.core.world.action.Action;
import com.craftingdead.core.world.action.ActionType;
import com.craftingdead.core.world.action.ActionTypes;
import com.craftingdead.core.world.action.TimedAction;
import com.craftingdead.core.world.entity.extension.LivingExtension;
import com.craftingdead.core.world.item.gun.Gun;
import com.craftingdead.core.world.item.gun.GunAnimationEvent;
import com.craftingdead.core.world.item.gun.ammoprovider.AmmoProvider;
import com.craftingdead.core.world.item.gun.ammoprovider.MagazineAmmoProvider;
import com.craftingdead.core.world.item.gun.magazine.Magazine;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class RemoveMagazineAction
extends TimedAction {
    private final LivingExtension<?, ?> performer;
    private final Gun gun;
    private final ItemStack oldMagazineStack;
    private final MagazineAmmoProvider ammoProvider;
    @Nullable
    private Animation animation;

    public RemoveMagazineAction(LivingExtension<?, ?> performer) {
        this.performer = performer;
        this.gun = (Gun)performer.mainHandGun().orElseThrow(() -> new IllegalStateException("Performer not holding gun"));
        AmmoProvider ammoProvider = this.gun.getAmmoProvider();
        if (!(ammoProvider instanceof MagazineAmmoProvider)) {
            throw new IllegalStateException("No MagazineAmmoProvider present");
        }
        this.ammoProvider = (MagazineAmmoProvider)ammoProvider;
        this.oldMagazineStack = this.ammoProvider.getMagazineStack();
    }

    @Override
    public ActionType<?> type() {
        return (ActionType)ActionTypes.REMOVE_MAGAZINE.get();
    }

    @Override
    protected int getTotalDurationTicks() {
        return this.gun.getReloadDurationTicks();
    }

    @Override
    public boolean start(boolean simulate) {
        if (this.performer().entity().m_20142_() || this.oldMagazineStack.m_41619_()) {
            return false;
        }
        if (simulate) {
            return true;
        }
        if (this.gun.isPerformingSecondaryAction()) {
            this.gun.setPerformingSecondaryAction(this.performer(), false, false);
        }
        if (this.performer().level().m_5776_()) {
            this.animation = this.gun.getClient().getAnimation(GunAnimationEvent.RELOAD);
            this.gun.getClient().getAnimationController().addAnimation(this.animation);
        }
        return true;
    }

    @Override
    public boolean tick() {
        if (!this.performer().level().m_5776_() && (this.performer.mainHandItem().m_41619_() || !this.performer.mainHandItem().m_150930_(this.gun.getItemStack().m_41720_()) || this.performer().entity().m_20142_())) {
            this.performer().cancelAction(true);
            return false;
        }
        return super.tick();
    }

    @Override
    public void stop(Action.StopReason reason) {
        super.stop(reason);
        if (reason.isCompleted()) {
            if (!this.performer().level().m_5776_()) {
                this.ammoProvider.setMagazineStack(ItemStack.f_41583_);
                if (!(this.oldMagazineStack.m_41619_() || !(this.performer().entity() instanceof Player) || this.oldMagazineStack.getCapability(Magazine.CAPABILITY).map(Magazine::isEmpty).orElse(true).booleanValue() && ((Boolean)ServerConfig.instance.reloadDestroyMagWhenEmpty.get()).booleanValue())) {
                    ((Player)this.performer().entity()).m_36356_(this.oldMagazineStack);
                }
            }
            return;
        }
        if (this.animation != null) {
            this.animation.remove();
        }
        this.ammoProvider.setMagazineStack(this.oldMagazineStack);
    }

    @Override
    public LivingExtension<?, ?> performer() {
        return this.performer;
    }
}

