/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.telemetry;

import com.craftingdead.core.telemetry.TelemetryManager;
import com.mojang.authlib.GameProfile;
import io.sentry.Sentry;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.client.Minecraft;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.server.ServerLifecycleHooks;

public final class TelemetryRuntimeSampler {
    private static final AtomicBoolean STARTED = new AtomicBoolean();

    private TelemetryRuntimeSampler() {
    }

    public static void ensureStarted() {
        if (STARTED.compareAndSet(false, true)) {
            MinecraftForge.EVENT_BUS.register((Object)new ServerSampler());
            DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> ClientSampler::register);
        }
    }

    private static Map<String, Object> mapOf(Object ... entries) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        int i = 0;
        while (i + 1 < entries.length) {
            map.put(String.valueOf(entries[i]), entries[i + 1]);
            i += 2;
        }
        return map;
    }

    private static final class ServerSampler {
        private int tickCounter;

        private ServerSampler() {
        }

        @SubscribeEvent
        public void handleServerTick(TickEvent.ServerTickEvent event) {
            if (event.phase != TickEvent.Phase.END) {
                return;
            }
            if (++this.tickCounter % 20 != 0) {
                return;
            }
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            if (server == null) {
                return;
            }
            this.captureServerSnapshot(server);
        }

        private void captureServerSnapshot(MinecraftServer server) {
            PlayerList playerList = server.m_6846_();
            ArrayList players = new ArrayList();
            for (ServerPlayer player : playerList.m_11314_()) {
                LinkedHashMap<String, Object> info = new LinkedHashMap<String, Object>();
                GameProfile profile = player.m_36316_();
                info.put("name", profile.getName());
                info.put("uuid", profile.getId().toString());
                info.put("dimension", player.f_19853_.m_46472_().m_135782_().toString());
                info.put("x", player.m_20185_());
                info.put("y", player.m_20186_());
                info.put("z", player.m_20189_());
                info.put("health", Float.valueOf(player.m_21223_()));
                info.put("food", player.m_36324_().m_38702_());
                info.put("experienceLevel", player.f_36078_);
                players.add(info);
            }
            ArrayList worlds = new ArrayList();
            for (ServerLevel level : server.m_129785_()) {
                LinkedHashMap<String, Object> worldInfo = new LinkedHashMap<String, Object>();
                DimensionType dimensionType = level.m_6042_();
                worldInfo.put("dimension", level.m_46472_().m_135782_().toString());
                worldInfo.put("difficulty", level.m_46791_().m_19036_());
                worldInfo.put("isDay", level.m_46461_());
                worldInfo.put("isRaining", level.m_46471_());
                worldInfo.put("isThundering", level.m_46470_());
                worldInfo.put("dayTime", level.m_46468_());
                worldInfo.put("players", level.m_6907_().size());
                worldInfo.put("logicalHeight", dimensionType.m_63964_());
                worlds.add(worldInfo);
            }
            Sentry.configureScope(scope -> {
                scope.setExtra("server.motd", server.m_129916_());
                scope.setExtra("server.playerCount", Integer.toString(playerList.m_11309_()));
                scope.setExtra("server.maxPlayers", Integer.toString(playerList.m_11310_()));
                scope.setExtra("server.viewDistance", Integer.toString(playerList.m_11312_()));
                scope.setExtra("server.simulationDistance", Integer.toString(playerList.m_184213_()));
                scope.setExtra("server.players", TelemetryManager.encodeToJson(players));
                scope.setExtra("server.worlds", TelemetryManager.encodeToJson(worlds));
                scope.setTag("server.dedicated", String.valueOf(server.m_6982_()));
            });
        }
    }

    private static final class ClientSampler {
        private int tickCounter;

        private ClientSampler() {
        }

        private static void register() {
            MinecraftForge.EVENT_BUS.register((Object)new ClientSampler());
        }

        @SubscribeEvent
        public void handleClientTick(TickEvent.ClientTickEvent event) {
            if (event.phase != TickEvent.Phase.END || event.side != LogicalSide.CLIENT) {
                return;
            }
            if (++this.tickCounter % 20 != 0) {
                return;
            }
            if (!FMLEnvironment.dist.isClient()) {
                return;
            }
            Minecraft minecraft = Minecraft.m_91087_();
            if (minecraft == null) {
                return;
            }
            int width = minecraft.m_91268_().m_85441_();
            int height = minecraft.m_91268_().m_85442_();
            String language = minecraft.m_91102_().m_118983_().toString();
            boolean isDemo = minecraft.m_91402_();
            Sentry.configureScope(scope -> {
                scope.setExtra("client.user", minecraft.m_91094_().m_92546_());
                scope.setExtra("client.type", minecraft.m_91094_().m_168638_().m_193808_());
                scope.setExtra("client.window", TelemetryManager.encodeToJson(TelemetryRuntimeSampler.mapOf("width", width, "height", height)));
                scope.setExtra("client.language", language);
                scope.setExtra("client.demo", Boolean.toString(isDemo));
            });
        }
    }
}

