/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.network.message.play;

import com.craftingdead.core.CraftingDead;
import com.craftingdead.core.trauma.TraumaSeverity;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public record TraumaPacket(TraumaSeverity severity, int aimSwayTicks, float aimSwayStrength) {
    public void encode(FriendlyByteBuf out) {
        out.m_130130_(this.severity.ordinal());
        out.m_130130_(this.aimSwayTicks);
        out.writeFloat(this.aimSwayStrength);
    }

    public static TraumaPacket decode(FriendlyByteBuf in) {
        TraumaSeverity severity = TraumaSeverity.fromOrdinal(in.m_130242_());
        int aimSwayTicks = in.m_130242_();
        float aimSwayStrength = in.readFloat();
        return new TraumaPacket(severity, aimSwayTicks, aimSwayStrength);
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> CraftingDead.getInstance().getClientDist().handleTrauma(this));
        return true;
    }
}

