/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.network.message.play;

import com.craftingdead.core.world.effect.ModMobEffects;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.network.NetworkEvent;

public record ParachuteSyncMessage(int entityId, boolean hasParachute) {
    public static void encode(ParachuteSyncMessage packet, FriendlyByteBuf buf) {
        buf.writeInt(packet.entityId());
        buf.writeBoolean(packet.hasParachute());
    }

    public static ParachuteSyncMessage decode(FriendlyByteBuf buf) {
        return new ParachuteSyncMessage(buf.readInt(), buf.readBoolean());
    }

    public static void handle(ParachuteSyncMessage packet, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            assert (Minecraft.m_91087_().f_91073_ != null);
            Entity entity = Minecraft.m_91087_().f_91073_.m_6815_(packet.entityId());
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                if (packet.hasParachute()) {
                    livingEntity.m_7292_(new MobEffectInstance((MobEffect)ModMobEffects.PARACHUTE.get()));
                } else {
                    livingEntity.m_21195_((MobEffect)ModMobEffects.PARACHUTE.get());
                }
            }
        });
        context.get().setPacketHandled(true);
    }
}

