/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.world.item.gun.ammoprovider;

import com.craftingdead.core.network.Synched;
import com.craftingdead.core.world.action.Action;
import com.craftingdead.core.world.action.ActionType;
import com.craftingdead.core.world.action.ActionTypes;
import com.craftingdead.core.world.entity.extension.LivingExtension;
import com.craftingdead.core.world.item.gun.ammoprovider.AmmoProvider;
import com.craftingdead.core.world.item.gun.ammoprovider.AmmoProviderType;
import com.craftingdead.core.world.item.gun.ammoprovider.AmmoProviderTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;

public class MagazineAmmoProvider
implements AmmoProvider {
    private ItemStack magazineStack;
    private boolean stackChanged;

    public MagazineAmmoProvider() {
        this(ItemStack.f_41583_);
    }

    public MagazineAmmoProvider(ItemStack magazineStack) {
        this.magazineStack = magazineStack;
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128365_("magazineStack", (Tag)this.magazineStack.serializeNBT());
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        if (nbt.m_128425_("magazineStack", 10)) {
            this.magazineStack = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("magazineStack"));
            this.stackChanged = true;
        }
    }

    @Override
    public void encode(FriendlyByteBuf out, boolean writeAll) {
        if (this.stackChanged || writeAll) {
            out.writeBoolean(true);
            out.m_130055_(this.magazineStack);
            this.stackChanged = false;
        } else {
            out.writeBoolean(false);
        }
        this.getMagazine().ifPresent(magazine -> magazine.encode(out, writeAll));
    }

    @Override
    public void decode(FriendlyByteBuf in) {
        if (in.readBoolean()) {
            this.magazineStack = in.m_130267_();
        }
        this.getMagazine().ifPresent(magazine -> magazine.decode(in));
    }

    @Override
    public boolean requiresSync() {
        return this.getMagazine().map(Synched::requiresSync).orElse(false) != false || this.stackChanged;
    }

    @Override
    public void reload(LivingExtension<?, ?> living) {
        living.performAction((Action)((ActionType)ActionTypes.MAGAZINE_RELOAD.get()).decode(living, null), true);
    }

    @Override
    public void unload(LivingExtension<?, ?> living) {
        living.performAction((Action)((ActionType)ActionTypes.REMOVE_MAGAZINE.get()).decode(living, null), true);
    }

    @Override
    public int getReserveSize() {
        return 0;
    }

    @Override
    public ItemStack getMagazineStack() {
        return this.magazineStack;
    }

    public void setMagazineStack(ItemStack magazineStack) {
        this.magazineStack = magazineStack;
        this.stackChanged = true;
    }

    @Override
    public AmmoProviderType getType() {
        return (AmmoProviderType)((Object)AmmoProviderTypes.MAGAZINE.get());
    }
}

