/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.world.inventory;

import com.craftingdead.core.world.inventory.GunCraftSlotType;
import com.craftingdead.core.world.item.GunItem;
import com.craftingdead.core.world.item.gun.Gun;
import com.craftingdead.core.world.item.gun.attachment.Attachment;
import com.craftingdead.core.world.item.gun.attachment.AttachmentLike;
import com.craftingdead.core.world.item.gun.skin.Paint;
import java.util.Collections;
import java.util.HashMap;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class GunCraftSlot
extends Slot {
    private final SimpleContainer craftingInventory;

    public GunCraftSlot(ResultContainer inventory, int slotIndex, int x, int y, SimpleContainer craftingInventory) {
        super((Container)inventory, slotIndex, x, y);
        this.craftingInventory = craftingInventory;
    }

    public boolean m_5857_(ItemStack itemStack) {
        return itemStack.m_41720_() instanceof GunItem;
    }

    public void m_5852_(ItemStack itemStack) {
        itemStack.getCapability(Gun.CAPABILITY).ifPresent(gun -> {
            gun.getAttachments().forEach((type, attachment) -> this.craftingInventory.m_6836_(type.getIndex(), new ItemStack((ItemLike)attachment)));
            gun.setAttachments(Collections.emptyMap());
            this.craftingInventory.m_6836_(GunCraftSlotType.PAINT.getIndex(), gun.getPaintStack());
            gun.setPaintStack(ItemStack.f_41583_);
        });
        super.m_5852_(itemStack);
    }

    public void m_142406_(Player playerEntity, ItemStack gunStack) {
        gunStack.getCapability(Gun.CAPABILITY).ifPresent(gun -> {
            gun.setPaintStack(ItemStack.f_41583_);
            HashMap<GunCraftSlotType, Attachment> attachments = new HashMap<GunCraftSlotType, Attachment>();
            for (int i = 0; i < this.craftingInventory.m_6643_(); ++i) {
                ItemStack itemStack = this.craftingInventory.m_8020_(i);
                if (gun.isAcceptedAttachment(itemStack) && itemStack.m_41720_() instanceof AttachmentLike) {
                    Attachment attachment = ((AttachmentLike)itemStack.m_41720_()).asAttachment();
                    attachments.put(attachment.getInventorySlot(), attachment);
                    this.craftingInventory.m_6836_(i, ItemStack.f_41583_);
                    continue;
                }
                if (!Paint.isValid(gunStack, itemStack)) continue;
                gun.setPaintStack(itemStack);
                this.craftingInventory.m_6836_(i, ItemStack.f_41583_);
            }
            gun.setAttachments(attachments);
        });
    }
}

