/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.world.entity.grenade;

import com.craftingdead.core.ServerConfig;
import com.craftingdead.core.world.entity.ModEntityTypes;
import com.craftingdead.core.world.entity.grenade.Grenade;
import com.craftingdead.core.world.item.GrenadeItem;
import com.craftingdead.core.world.item.ModItems;
import com.craftingdead.core.world.item.gun.GunConfiguration;
import com.craftingdead.core.world.item.gun.GunConfigurations;
import java.util.OptionalInt;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;

public class DecoyGrenadeEntity
extends Grenade {
    private long lastShotMs;
    private final Holder<GunConfiguration> gunProperties = this.getRandomProperties();

    public DecoyGrenadeEntity(EntityType<? extends Grenade> type, Level level) {
        super(type, level);
    }

    public DecoyGrenadeEntity(Level level) {
        super((EntityType<? extends Grenade>)((EntityType)ModEntityTypes.DECOY_GRENADE.get()), level);
    }

    public DecoyGrenadeEntity(LivingEntity thrower, Level level) {
        super((EntityType<? extends Grenade>)((EntityType)ModEntityTypes.DECOY_GRENADE.get()), thrower, level);
    }

    private Holder<GunConfiguration> getRandomProperties() {
        return (Holder)this.f_19853_.m_5962_().m_175515_(GunConfigurations.REGISTRY_KEY).m_203454_(this.f_19796_).get();
    }

    @Override
    public void onMotionStop(int stopsCount) {
        if (stopsCount == 1) {
            this.setActivated(true);
        }
    }

    @Override
    public void activatedChanged(boolean activated) {
        if (!activated) {
            if (!this.f_19853_.m_5776_()) {
                this.m_6074_();
                this.f_19853_.m_7703_((Entity)this, this.createDamageSource(), null, this.m_20185_(), this.m_20186_() + (double)this.m_20206_(), this.m_20189_(), 1.3f, false, Explosion.BlockInteraction.NONE);
            }
        } else {
            this.playFakeShoot();
        }
    }

    @Override
    public OptionalInt getMinimumTicksUntilAutoDeactivation() {
        return OptionalInt.of((Integer)ServerConfig.instance.explosivesDecoyGrenadeTicksBeforeDeactivation.get());
    }

    @Override
    public void onGrenadeTick() {
        if (!this.isActivated()) {
            return;
        }
        if (!this.f_19853_.m_5776_()) {
            if (this.f_19796_.nextInt(20) == 0 && this.canShoot()) {
                this.playFakeShoot();
            }
        } else {
            this.f_19853_.m_6493_((ParticleOptions)ParticleTypes.f_123762_, true, this.m_20185_(), this.m_20186_() + 0.4, this.m_20189_(), 0.0, 0.0, 0.0);
        }
    }

    public boolean canShoot() {
        int fireDelayMs = ((GunConfiguration)((Object)this.gunProperties.m_203334_())).getFireDelayMs();
        return Util.m_137550_() - this.lastShotMs >= (long)fireDelayMs;
    }

    public void playFakeShoot() {
        this.m_5496_(((GunConfiguration)((Object)this.gunProperties.m_203334_())).getShootSound(), 1.5f, 1.0f);
        this.lastShotMs = Util.m_137550_();
    }

    @Override
    public boolean isAttracting() {
        return this.isActivated();
    }

    @Override
    public GrenadeItem asItem() {
        return (GrenadeItem)((Object)ModItems.DECOY_GRENADE.get());
    }
}

