/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.world.action.reload;

import com.craftingdead.core.ServerConfig;
import com.craftingdead.core.client.animation.Animation;
import com.craftingdead.core.world.action.Action;
import com.craftingdead.core.world.action.TimedAction;
import com.craftingdead.core.world.entity.extension.LivingExtension;
import com.craftingdead.core.world.item.gun.Gun;
import com.craftingdead.core.world.item.gun.GunAnimationEvent;
import net.minecraft.client.Minecraft;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractReloadAction
extends TimedAction {
    protected final LivingExtension<?, ?> performer;
    protected final Gun gun;
    protected final ItemStack oldMagazineStack;
    @Nullable
    private Animation animation;

    public AbstractReloadAction(LivingExtension<?, ?> performer) {
        this.performer = performer;
        this.gun = (Gun)performer.mainHandItem().getCapability(Gun.CAPABILITY).orElseThrow(() -> new IllegalStateException("Performer not holding gun"));
        this.oldMagazineStack = this.gun.getAmmoProvider().getMagazineStack();
    }

    @Override
    public LivingExtension<?, ?> performer() {
        return this.performer;
    }

    @Override
    protected int getTotalDurationTicks() {
        return this.gun.getReloadDurationTicks() + (Integer)ServerConfig.instance.reloadDuration.get();
    }

    @Override
    public boolean start(boolean simulate) {
        if (this.performer().entity().m_20142_()) {
            return false;
        }
        if (simulate) {
            return true;
        }
        if (this.gun.isPerformingSecondaryAction()) {
            this.gun.setPerformingSecondaryAction(this.performer(), false, false);
        }
        this.gun.getReloadSound().ifPresent(sound -> this.performer().level().m_6269_(null, this.performer().entity(), sound, SoundSource.PLAYERS, 1.0f, 1.0f));
        if (this.performer().level().m_5776_()) {
            this.animation = this.gun.getClient().getAnimation(GunAnimationEvent.RELOAD);
            this.gun.getClient().getAnimationController().addAnimation(this.animation);
        }
        return true;
    }

    protected abstract void loadNewMagazineStack(boolean var1);

    @Override
    public boolean tick() {
        if (!this.performer().level().m_5776_() && (!this.performer.mainHandItem().m_150930_(this.gun.getItemStack().m_41720_()) || this.performer().mainHandItem().m_41619_() || this.performer().entity().m_20142_())) {
            this.performer.cancelAction(true);
            return false;
        }
        return super.tick();
    }

    @Override
    public void stop(Action.StopReason reason) {
        super.stop(reason);
        if (reason.isCompleted()) {
            if (this.performer().level().m_5776_()) {
                return;
            }
            this.loadNewMagazineStack(false);
            return;
        }
        if (this.performer().level().m_5776_()) {
            if (this.gun.getReloadSound().isPresent()) {
                Minecraft.m_91087_().m_91106_().m_120386_(this.gun.getReloadSound().get().getRegistryName(), SoundSource.PLAYERS);
            }
            if (this.animation != null) {
                this.animation.remove();
            }
        }
        this.revert();
    }

    protected abstract void revert();
}

