/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.network;

import com.google.common.collect.Lists;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.EncoderException;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import org.apache.commons.lang3.ObjectUtils;
import org.jetbrains.annotations.Nullable;

public class SynchedData {
    private final Map<Integer, DataEntry<?>> entries = new Int2ObjectOpenHashMap();
    @Nullable
    private final Runnable dirtyListener;
    private boolean empty = true;
    private boolean dirty;

    public SynchedData() {
        this(null);
    }

    public SynchedData(@Nullable Runnable dirtyListener) {
        this.dirtyListener = dirtyListener;
    }

    public <T> void register(EntityDataAccessor<T> parameter, T value) {
        int id = parameter.m_135015_();
        if (id > 254) {
            throw new IllegalArgumentException("Data parameter id is too big with " + id + "! (Max is 254)");
        }
        if (this.entries.containsKey(id)) {
            throw new IllegalArgumentException("Duplicate id value for " + id + "!");
        }
        if (EntityDataSerializers.m_135052_((EntityDataSerializer)parameter.m_135016_()) < 0) {
            throw new IllegalArgumentException("Unregistered serializer " + parameter.m_135016_() + " for " + id + "!");
        }
        this.createEntry(parameter, value);
    }

    private <T> void createEntry(EntityDataAccessor<T> parameter, T value) {
        DataEntry<T> entry = new DataEntry<T>(parameter, value);
        this.entries.put(parameter.m_135015_(), entry);
        this.empty = false;
    }

    private <T> DataEntry<T> getEntry(EntityDataAccessor<T> parameter) {
        DataEntry<?> entry;
        try {
            entry = this.entries.get(parameter.m_135015_());
        }
        catch (Throwable throwable) {
            CrashReport crashReport = CrashReport.m_127521_((Throwable)throwable, (String)"Getting data entry");
            CrashReportCategory category = crashReport.m_127514_("Getting data entry");
            category.m_128159_("Data parameter ID", parameter);
            throw new ReportedException(crashReport);
        }
        return entry;
    }

    public <T> T get(EntityDataAccessor<T> parameter) {
        return this.getEntry(parameter).getValue();
    }

    public <T> void set(EntityDataAccessor<T> parameter, T value) {
        DataEntry<T> entry = this.getEntry(parameter);
        if (ObjectUtils.notEqual(value, entry.getValue())) {
            entry.setValue(value);
            entry.setDirty(true);
            this.markDirty();
        }
    }

    public <T> T compute(EntityDataAccessor<T> parameter, Function<T, T> remappingFunction) {
        DataEntry<T> entry = this.getEntry(parameter);
        T newValue = remappingFunction.apply(entry.getValue());
        if (ObjectUtils.notEqual(newValue, entry.getValue())) {
            entry.setValue(newValue);
            entry.setDirty(true);
            this.markDirty();
        }
        return newValue;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    private void markDirty() {
        if (!this.dirty && this.dirtyListener != null) {
            this.dirtyListener.run();
        }
        this.dirty = true;
    }

    public static void pack(List<DataEntry<?>> entries, FriendlyByteBuf buf) {
        if (entries != null) {
            for (DataEntry<?> entry : entries) {
                SynchedData.writeEntry(buf, entry);
            }
        }
        buf.writeByte(255);
    }

    private static <T> void writeEntry(FriendlyByteBuf out, DataEntry<T> entry) {
        EntityDataAccessor<T> parameter = entry.getKey();
        int i = EntityDataSerializers.m_135052_((EntityDataSerializer)parameter.m_135016_());
        if (i < 0) {
            throw new EncoderException("Unknown serializer type " + parameter.m_135016_());
        }
        out.writeByte(parameter.m_135015_());
        out.m_130130_(i);
        parameter.m_135016_().m_6856_(out, entry.getValue());
    }

    @Nullable
    public List<DataEntry<?>> packDirty() {
        ArrayList list = null;
        if (this.dirty) {
            for (DataEntry<?> entry : this.entries.values()) {
                if (!entry.isDirty()) continue;
                entry.setDirty(false);
                if (list == null) {
                    list = Lists.newArrayList();
                }
                list.add(entry.copy());
            }
        }
        this.dirty = false;
        return list;
    }

    @Nullable
    public List<DataEntry<?>> getAll() {
        ArrayList list = null;
        for (DataEntry<?> entry : this.entries.values()) {
            if (list == null) {
                list = new ArrayList();
            }
            list.add(entry.copy());
        }
        return list;
    }

    @Nullable
    public static List<DataEntry<?>> unpack(FriendlyByteBuf buf) {
        short id;
        ArrayList entries = null;
        while ((id = buf.readUnsignedByte()) != 255) {
            int j;
            EntityDataSerializer serializer;
            if (entries == null) {
                entries = Lists.newArrayList();
            }
            if ((serializer = EntityDataSerializers.m_135048_((int)(j = buf.m_130242_()))) == null) {
                throw new DecoderException("Unknown serializer type " + j);
            }
            entries.add(SynchedData.readEntry(buf, id, serializer));
        }
        return entries;
    }

    private static <T> DataEntry<T> readEntry(FriendlyByteBuf buf, int id, EntityDataSerializer<T> serializer) {
        return new DataEntry<Object>(serializer.m_135021_(id), serializer.m_6709_(buf));
    }

    public void assignValues(@Nullable List<DataEntry<?>> entries) {
        if (entries == null) {
            return;
        }
        for (DataEntry<?> entry : entries) {
            DataEntry<?> currentEntry = this.entries.get(entry.getKey().m_135015_());
            if (currentEntry == null) continue;
            this.assignValue(currentEntry, entry);
        }
    }

    private <T> void assignValue(DataEntry<T> destination, DataEntry<?> source) {
        if (!Objects.equals(source.parameter.m_135016_(), destination.parameter.m_135016_())) {
            throw new IllegalStateException(String.format("Data entry mismatch for %d: old=%s(%s), new=%s(%s)", destination.parameter.m_135015_(), destination.value, destination.value.getClass(), source.value, source.value.getClass()));
        }
        destination.setValue(source.getValue());
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public void cleanDirty() {
        this.dirty = false;
        for (DataEntry<?> entry : this.entries.values()) {
            entry.setDirty(false);
        }
    }

    public static class DataEntry<T> {
        private final EntityDataAccessor<T> parameter;
        private T value;
        private boolean dirty;

        private DataEntry(EntityDataAccessor<T> parameter, T value) {
            this.parameter = parameter;
            this.value = value;
            this.dirty = true;
        }

        public EntityDataAccessor<T> getKey() {
            return this.parameter;
        }

        public void setValue(T valueIn) {
            this.value = valueIn;
        }

        public T getValue() {
            return this.value;
        }

        public boolean isDirty() {
            return this.dirty;
        }

        public void setDirty(boolean dirty) {
            this.dirty = dirty;
        }

        public DataEntry<T> copy() {
            return new DataEntry<Object>(this.parameter, this.parameter.m_135016_().m_7020_(this.value));
        }
    }
}

