/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.network;

import com.craftingdead.core.network.message.play.CancelActionMessage;
import com.craftingdead.core.network.message.play.CrouchMessage;
import com.craftingdead.core.network.message.play.DamageHandcuffsMessage;
import com.craftingdead.core.network.message.play.EnableCombatModeMessage;
import com.craftingdead.core.network.message.play.HitMessage;
import com.craftingdead.core.network.message.play.NPCTriggerPressedMessage;
import com.craftingdead.core.network.message.play.OpenCraftingMenuMessage;
import com.craftingdead.core.network.message.play.OpenEquipmentMenuMessage;
import com.craftingdead.core.network.message.play.OpenStorageMessage;
import com.craftingdead.core.network.message.play.ParachuteSyncMessage;
import com.craftingdead.core.network.message.play.PerformActionMessage;
import com.craftingdead.core.network.message.play.SecondaryActionMessage;
import com.craftingdead.core.network.message.play.SetFireModeMessage;
import com.craftingdead.core.network.message.play.SyncGunContainerSlotMessage;
import com.craftingdead.core.network.message.play.SyncGunEquipmentSlotMessage;
import com.craftingdead.core.network.message.play.SyncLivingMessage;
import com.craftingdead.core.network.message.play.SyncProtectionConfigMessage;
import com.craftingdead.core.network.message.play.TraumaPacket;
import com.craftingdead.core.network.message.play.TriggerPressedMessage;
import com.craftingdead.core.network.message.play.ValidatePendingHitMessage;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum NetworkChannel {
    PLAY(new ResourceLocation("craftingdead", "play")){

        @Override
        public void registerMessages(SimpleChannel simpleChannel) {
            simpleChannel.messageBuilder(SyncLivingMessage.class, 0, NetworkDirection.PLAY_TO_CLIENT).encoder(SyncLivingMessage::encode).decoder(SyncLivingMessage::decode).consumer(SyncLivingMessage::handle).add();
            simpleChannel.messageBuilder(OpenEquipmentMenuMessage.class, 1, NetworkDirection.PLAY_TO_SERVER).encoder(OpenEquipmentMenuMessage::encode).decoder(OpenEquipmentMenuMessage::decode).consumer(OpenEquipmentMenuMessage::handle).add();
            simpleChannel.messageBuilder(SecondaryActionMessage.class, 2).encoder(SecondaryActionMessage::encode).decoder(SecondaryActionMessage::decode).consumer(SecondaryActionMessage::handle).add();
            simpleChannel.messageBuilder(SetFireModeMessage.class, 3).encoder(SetFireModeMessage::encode).decoder(SetFireModeMessage::decode).consumer(SetFireModeMessage::handle).add();
            simpleChannel.messageBuilder(TriggerPressedMessage.class, 4).encoder(TriggerPressedMessage::encode).decoder(TriggerPressedMessage::decode).consumer(TriggerPressedMessage::handle).add();
            simpleChannel.messageBuilder(NPCTriggerPressedMessage.class, 5).encoder(NPCTriggerPressedMessage::encode).decoder(NPCTriggerPressedMessage::decode).consumer(NPCTriggerPressedMessage::handle).add();
            simpleChannel.messageBuilder(SyncGunContainerSlotMessage.class, 6, NetworkDirection.PLAY_TO_CLIENT).encoder(SyncGunContainerSlotMessage::encode).decoder(SyncGunContainerSlotMessage::decode).consumer(SyncGunContainerSlotMessage::handle).add();
            simpleChannel.messageBuilder(OpenStorageMessage.class, 7, NetworkDirection.PLAY_TO_SERVER).encoder(OpenStorageMessage::encode).decoder(OpenStorageMessage::decode).consumer(OpenStorageMessage::handle).add();
            simpleChannel.messageBuilder(PerformActionMessage.class, 8).encoder(PerformActionMessage::encode).decoder(PerformActionMessage::decode).consumer(PerformActionMessage::handle).add();
            simpleChannel.messageBuilder(CancelActionMessage.class, 9).encoder(CancelActionMessage::encode).decoder(CancelActionMessage::decode).consumer(CancelActionMessage::handle).add();
            simpleChannel.messageBuilder(ValidatePendingHitMessage.class, 10, NetworkDirection.PLAY_TO_SERVER).encoder(ValidatePendingHitMessage::encode).decoder(ValidatePendingHitMessage::decode).consumer(ValidatePendingHitMessage::handle).add();
            simpleChannel.messageBuilder(CrouchMessage.class, 11).encoder(CrouchMessage::encode).decoder(CrouchMessage::decode).consumer(CrouchMessage::handle).add();
            simpleChannel.messageBuilder(HitMessage.class, 12, NetworkDirection.PLAY_TO_CLIENT).encoder(HitMessage::encode).decoder(HitMessage::decode).consumer(HitMessage::handle).add();
            simpleChannel.messageBuilder(SyncGunEquipmentSlotMessage.class, 13, NetworkDirection.PLAY_TO_CLIENT).encoder(SyncGunEquipmentSlotMessage::encode).decoder(SyncGunEquipmentSlotMessage::decode).consumer(SyncGunEquipmentSlotMessage::handle).add();
            simpleChannel.messageBuilder(EnableCombatModeMessage.class, 14, NetworkDirection.PLAY_TO_SERVER).encoder(EnableCombatModeMessage::encode).decoder(EnableCombatModeMessage::decode).consumer(EnableCombatModeMessage::handle).add();
            simpleChannel.messageBuilder(DamageHandcuffsMessage.class, 15, NetworkDirection.PLAY_TO_SERVER).encoder(DamageHandcuffsMessage::encode).decoder(DamageHandcuffsMessage::decode).consumer(DamageHandcuffsMessage::handle).add();
            simpleChannel.messageBuilder(ParachuteSyncMessage.class, 17, NetworkDirection.PLAY_TO_CLIENT).encoder(ParachuteSyncMessage::encode).decoder(ParachuteSyncMessage::decode).consumer(ParachuteSyncMessage::handle).add();
            simpleChannel.messageBuilder(OpenCraftingMenuMessage.class, 18, NetworkDirection.PLAY_TO_SERVER).encoder(OpenCraftingMenuMessage::encode).decoder(OpenCraftingMenuMessage::decode).consumer(OpenCraftingMenuMessage::handle).add();
            simpleChannel.messageBuilder(TraumaPacket.class, 19, NetworkDirection.PLAY_TO_CLIENT).encoder(TraumaPacket::encode).decoder(TraumaPacket::decode).consumer(TraumaPacket::handle).add();
            simpleChannel.messageBuilder(SyncProtectionConfigMessage.class, 20, NetworkDirection.PLAY_TO_CLIENT).encoder(SyncProtectionConfigMessage::encode).decoder(SyncProtectionConfigMessage::decode).consumer(SyncProtectionConfigMessage::handle).add();
        }
    };

    private static final String NETWORK_VERSION = "0.0.1.2";
    private static boolean loaded;
    private final SimpleChannel simpleChannel;

    private NetworkChannel(ResourceLocation channelName) {
        this.simpleChannel = NetworkRegistry.ChannelBuilder.named((ResourceLocation)channelName).clientAcceptedVersions(NETWORK_VERSION::equals).serverAcceptedVersions(NETWORK_VERSION::equals).networkProtocolVersion(() -> NETWORK_VERSION).simpleChannel();
    }

    protected abstract void registerMessages(SimpleChannel var1);

    public SimpleChannel getSimpleChannel() {
        return this.simpleChannel;
    }

    public static void loadChannels() {
        if (!loaded) {
            for (NetworkChannel channel : NetworkChannel.values()) {
                channel.registerMessages(channel.simpleChannel);
            }
            loaded = true;
        }
    }
}

