/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.world.item.gun.attachment;

import com.craftingdead.core.world.inventory.GunCraftSlotType;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistryEntry;
import org.jetbrains.annotations.Nullable;

public class Attachment
extends ForgeRegistryEntry<Attachment>
implements ItemLike {
    private final Map<MultiplierType, Float> multipliers;
    private final GunCraftSlotType inventorySlot;
    private final boolean soundSuppressor;
    private final boolean scope;
    private final Supplier<? extends Item> item;
    @Nullable
    private String descriptionId;

    private Attachment(Builder builder) {
        this.multipliers = builder.multipliers;
        this.inventorySlot = builder.inventorySlot;
        this.soundSuppressor = builder.soundSuppressor;
        this.scope = builder.scope;
        this.item = builder.item;
    }

    public Map<MultiplierType, Float> getMultipliers() {
        return Collections.unmodifiableMap(this.multipliers);
    }

    public float getMultiplier(MultiplierType multiplierType) {
        return this.multipliers.getOrDefault((Object)multiplierType, Float.valueOf(1.0f)).floatValue();
    }

    public GunCraftSlotType getInventorySlot() {
        return this.inventorySlot;
    }

    public boolean isSoundSuppressor() {
        return this.soundSuppressor;
    }

    public boolean isScope() {
        return this.scope;
    }

    protected String getOrCreateDescriptionId() {
        if (this.descriptionId == null) {
            this.descriptionId = Util.m_137492_((String)"attachment", (ResourceLocation)this.getRegistryName());
        }
        return this.descriptionId;
    }

    public String getDescriptionId() {
        return this.getOrCreateDescriptionId();
    }

    public Component getDescription() {
        return new TranslatableComponent(this.getDescriptionId());
    }

    public Item m_5456_() {
        return this.item.get();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final Map<MultiplierType, Float> multipliers = new EnumMap<MultiplierType, Float>(MultiplierType.class);
        private GunCraftSlotType inventorySlot;
        private boolean soundSuppressor;
        private boolean scope;
        private Supplier<? extends Item> item;

        public Builder addMultiplier(MultiplierType modifierType, float multiplier) {
            this.multipliers.put(modifierType, Float.valueOf(multiplier));
            return this;
        }

        public Builder setSoundSuppressor(boolean soundSuppressor) {
            this.soundSuppressor = soundSuppressor;
            return this;
        }

        public Builder setInventorySlot(GunCraftSlotType inventorySlot) {
            this.inventorySlot = inventorySlot;
            return this;
        }

        public Builder setScope(boolean scope) {
            this.scope = scope;
            return this;
        }

        public Builder setItem(Supplier<? extends Item> item) {
            this.item = item;
            return this;
        }

        public Attachment build() {
            return new Attachment(this);
        }
    }

    public static enum MultiplierType {
        DAMAGE("damage"),
        ACCURACY("accuracy"),
        ZOOM("zoom");

        private final String name;

        private MultiplierType(String name) {
            this.name = name;
        }

        public String getTranslationKey() {
            return "attachment_multiplier_type." + this.name;
        }
    }
}

