/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.world.action;

import com.craftingdead.core.ServerConfig;
import com.craftingdead.core.tags.ModItemTags;
import com.craftingdead.core.world.action.ActionType;
import com.craftingdead.core.world.action.RemoveMagazineAction;
import com.craftingdead.core.world.action.SimpleActionType;
import com.craftingdead.core.world.action.TargetSelector;
import com.craftingdead.core.world.action.item.BlockItemActionType;
import com.craftingdead.core.world.action.item.EntityItemActionType;
import com.craftingdead.core.world.action.reload.MagazineReloadAction;
import com.craftingdead.core.world.action.reload.RefillableReloadAction;
import com.craftingdead.core.world.effect.ModMobEffects;
import com.craftingdead.core.world.entity.extension.PlayerExtension;
import com.craftingdead.core.world.item.ModItems;
import java.util.Optional;
import java.util.Random;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryBuilder;
import net.minecraftforge.registries.RegistryObject;

public class ActionTypes {
    public static final ResourceKey<Registry<ActionType<?>>> REGISTRY_KEY = ResourceKey.m_135788_((ResourceLocation)new ResourceLocation("craftingdead", "action_type"));
    public static final DeferredRegister<ActionType<?>> deferredRegister = DeferredRegister.create(REGISTRY_KEY, (String)"craftingdead");
    public static final Supplier<IForgeRegistry<ActionType<?>>> REGISTRY = deferredRegister.makeRegistry(ActionType.class, RegistryBuilder::new);
    public static final RegistryObject<ActionType<?>> MAGAZINE_RELOAD = deferredRegister.register("magazine_reload", () -> new SimpleActionType<MagazineReloadAction>(MagazineReloadAction::new, true));
    public static final RegistryObject<ActionType<?>> REFILLABLE_RELOAD = deferredRegister.register("refillable_reload", () -> new SimpleActionType<RefillableReloadAction>(RefillableReloadAction::new, true));
    public static final RegistryObject<ActionType<?>> REMOVE_MAGAZINE = deferredRegister.register("remove_magazine", () -> new SimpleActionType<RemoveMagazineAction>(RemoveMagazineAction::new, true));
    public static final RegistryObject<EntityItemActionType<?>> SHRED_CLOTHING = deferredRegister.register("shred_clothing", () -> ((EntityItemActionType.Builder)EntityItemActionType.builder(TargetSelector.SELF_ONLY).forItem(itemStack -> itemStack.m_204117_(ModItemTags.CLOTHING))).customAction((performer, target) -> {
        Random random = target.random();
        int randomRagAmount = random.nextInt(3) + 3;
        for (int i = 0; i < randomRagAmount; ++i) {
            if (random.nextBoolean()) {
                target.entity().m_19983_(new ItemStack(() -> ModItems.CLEAN_RAG.get()));
                continue;
            }
            target.entity().m_19983_(new ItemStack(() -> ModItems.DIRTY_RAG.get()));
        }
    }, 1.0f).build());
    public static final RegistryObject<EntityItemActionType<?>> USE_SYRINGE = deferredRegister.register("use_syringe", () -> ((EntityItemActionType.Builder)((EntityItemActionType.Builder)((EntityItemActionType.Builder)EntityItemActionType.builder((performer, target) -> {
        if (target == null || performer == target || target.entity() instanceof Skeleton) {
            return Optional.empty();
        }
        Object targetEntity = target.entity();
        if (targetEntity.m_21223_() > 4.0f) {
            return Optional.of(target);
        }
        Object patt5040$temp = performer.entity();
        if (patt5040$temp instanceof Player) {
            Player player = (Player)patt5040$temp;
            player.m_5661_((Component)new TranslatableComponent("message.low_health", new Object[]{targetEntity.m_5446_()}).m_130940_(ChatFormatting.RED), true);
        }
        return Optional.empty();
    }).forItem((Supplier<Item>)ModItems.SYRINGE)).duration(16)).customAction((performer, target) -> target.entity().m_6469_(DamageSource.m_19370_(target.entity()), 2.0f), 1.0f).resultItem((Supplier<Item>)ModItems.BLOOD_SYRINGE)).build());
    public static final RegistryObject<EntityItemActionType<?>> USE_FIRST_AID_KIT = deferredRegister.register("use_first_aid_kit", () -> ((EntityItemActionType.Builder)((EntityItemActionType.Builder)((EntityItemActionType.Builder)EntityItemActionType.builder(TargetSelector.SELF_OR_OTHERS).forItem((Supplier<Item>)ModItems.FIRST_AID_KIT)).setFreezeMovement(true)).duration((Integer)ServerConfig.instance.firstAidKitDurationTicks.get())).effect(() -> new MobEffectInstance(MobEffects.f_19601_, 1, (int)Math.max(0.0f, ((Double)ServerConfig.instance.firstAidKitHealAmount.get()).floatValue() - 1.0f))).build());
    public static final RegistryObject<EntityItemActionType<?>> USE_ADRENALINE_SYRINGE = deferredRegister.register("use_adrenaline_syringe", () -> ((EntityItemActionType.Builder)((EntityItemActionType.Builder)((EntityItemActionType.Builder)((EntityItemActionType.Builder)EntityItemActionType.builder(TargetSelector.SELF_OR_OTHERS).forItem((Supplier<Item>)ModItems.ADRENALINE_SYRINGE)).duration(16)).resultItem((Supplier<? extends Item>)ModItems.SYRINGE)).useResultItemInCreative(false)).effect(() -> new MobEffectInstance((MobEffect)ModMobEffects.ADRENALINE.get(), ((Integer)ServerConfig.instance.adrenalineDurationTicks.get()).intValue(), 1)).build());
    public static final RegistryObject<EntityItemActionType<?>> USE_BLOOD_SYRINGE = deferredRegister.register("use_blood_syringe", () -> ((EntityItemActionType.Builder)((EntityItemActionType.Builder)((EntityItemActionType.Builder)((EntityItemActionType.Builder)EntityItemActionType.builder(TargetSelector.SELF_OR_OTHERS).forItem((Supplier<Item>)ModItems.BLOOD_SYRINGE)).duration((Integer)ServerConfig.instance.bloodSyringeDurationTicks.get())).resultItem((Supplier<? extends Item>)ModItems.SYRINGE)).useResultItemInCreative(false)).effect(() -> new MobEffectInstance(MobEffects.f_19601_, 1, (int)Math.max(0.0f, ((Double)ServerConfig.instance.bloodSyringeHealAmount.get()).floatValue() - 1.0f))).build());
    public static final RegistryObject<EntityItemActionType<?>> USE_BANDAGE = deferredRegister.register("use_bandage", () -> ((EntityItemActionType.Builder)((EntityItemActionType.Builder)EntityItemActionType.builder(TargetSelector.SELF_OR_OTHERS).forItem((Supplier<Item>)ModItems.BANDAGE)).duration((Integer)ServerConfig.instance.bandageDurationTicks.get())).effect(() -> new MobEffectInstance(MobEffects.f_19601_, 1, (int)Math.max(0.0f, ((Double)ServerConfig.instance.bandageHealAmount.get()).floatValue() - 1.0f))).build());
    public static final RegistryObject<EntityItemActionType<?>> USE_CLEAN_RAG = deferredRegister.register("use_clean_rag", () -> ((EntityItemActionType.Builder)((EntityItemActionType.Builder)((EntityItemActionType.Builder)EntityItemActionType.builder(TargetSelector.SELF_OR_OTHERS.hasEffect((Supplier<MobEffect>)ModMobEffects.BLEEDING)).forItem((Supplier<Item>)ModItems.CLEAN_RAG)).duration((Integer)ServerConfig.instance.cleanRagDurationTicks.get())).resultItem((Supplier<? extends Item>)ModItems.BLOODY_RAG)).build());
    public static final RegistryObject<BlockItemActionType> WASH_RAG = deferredRegister.register("wash_rag", () -> ((BlockItemActionType.Builder)((BlockItemActionType.Builder)((BlockItemActionType.Builder)((BlockItemActionType.Builder)BlockItemActionType.builder().forItem(itemStack -> itemStack.m_150930_((Item)ModItems.DIRTY_RAG.get()) || itemStack.m_150930_((Item)ModItems.BLOODY_RAG.get()))).resultItem((Supplier<? extends Item>)ModItems.CLEAN_RAG)).consumeItemInCreative(true)).finishSound(SoundEvents.f_11781_)).forFluid((TagKey<Fluid>)FluidTags.f_13131_).build());
    public static final RegistryObject<EntityItemActionType<?>> APPLY_HANDCUFFS = deferredRegister.register("apply_handcuffs", () -> ((EntityItemActionType.Builder)EntityItemActionType.builder(TargetSelector.OTHERS_ONLY.players().filter(((Predicate<PlayerExtension>)PlayerExtension::isHandcuffed).negate())).forItem((Supplier<Item>)ModItems.HANDCUFFS)).customAction((performer, target) -> {
        target.setHandcuffs(performer.mainHandItem().m_41777_());
        ((Player)target.entity()).m_5661_((Component)new TranslatableComponent("handcuffs.handcuffed", new Object[]{performer.entity().m_5446_()}).m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD}), true);
    }, 1.0f).build());
}

