/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.network.message.play;

import com.craftingdead.core.network.NetworkUtil;
import com.craftingdead.core.world.action.Action;
import com.craftingdead.core.world.action.ActionType;
import com.craftingdead.core.world.entity.extension.LivingExtension;
import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.network.NetworkEvent;

public record PerformActionMessage(ActionType<?> actionType, int performerEntityId, FriendlyByteBuf buf) {
    public void encode(FriendlyByteBuf out) {
        out.writeRegistryId(this.actionType);
        out.m_130130_(this.performerEntityId);
        out.m_130130_(this.buf.readableBytes());
        out.writeBytes((ByteBuf)this.buf);
        this.buf.release();
    }

    public static PerformActionMessage decode(FriendlyByteBuf in) {
        return new PerformActionMessage((ActionType)in.readRegistryId(), in.m_130242_(), new FriendlyByteBuf(in.readBytes(in.m_130242_())));
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            LivingEntity performerEntity = NetworkUtil.getEntityOrSender((NetworkEvent.Context)ctx.get(), this.performerEntityId, LivingEntity.class);
            LivingExtension<LivingEntity, ?> performer = LivingExtension.getOrThrow(performerEntity);
            boolean serverSide = ((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide().isServer();
            if (!serverSide || this.actionType.isTriggeredByClient()) {
                performer.performAction((Action)this.actionType.decode(performer, this.buf), serverSide);
            }
            this.buf.release();
        });
        return true;
    }
}

