/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core;

import com.craftingdead.core.telemetry.TelemetryEnvironment;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class CommonConfig {
    public static final CommonConfig instance;
    public static final ForgeConfigSpec configSpec;
    public final ForgeConfigSpec.EnumValue<TelemetryEnvironment> telemetryEnvironment;
    public final ForgeConfigSpec.ConfigValue<String> telemetryDsnExperimental;
    public final ForgeConfigSpec.ConfigValue<String> telemetryDsnProduction;
    public final ForgeConfigSpec.ConfigValue<String> telemetryPasswordSalt;
    public final ForgeConfigSpec.ConfigValue<String> telemetryPasswordHash;
    public final ForgeConfigSpec.BooleanValue telemetryClientEnabled;
    public final ForgeConfigSpec.BooleanValue telemetryServerEnabled;
    public final ForgeConfigSpec.ConfigValue<String> telemetryModpackId;
    public final ForgeConfigSpec.DoubleValue telemetryTracesSampleRate;
    public final ForgeConfigSpec.DoubleValue weakVestArmor;
    public final ForgeConfigSpec.DoubleValue weakVestArmorToughness;
    public final ForgeConfigSpec.DoubleValue strongVestArmor;
    public final ForgeConfigSpec.DoubleValue strongVestArmorToughness;

    private CommonConfig(ForgeConfigSpec.Builder builder) {
        builder.push("telemetry");
        this.telemetryEnvironment = builder.comment("Controls which DSN block is used.").defineEnum("environment", (Enum)TelemetryEnvironment.PRODUCTION);
        this.telemetryDsnExperimental = builder.comment("Experimental Sentry DSN.").define("dsnExperimental", (Object)"https://31d8ac34b0c24ddf98223098d42fd526@o1128514.ingest.sentry.io/6174174");
        this.telemetryDsnProduction = builder.comment("Production Sentry DSN.").define("dsnProduction", (Object)"https://31d8ac34b0c24ddf98223098d42fd526@o1128514.ingest.sentry.io/6174174");
        this.telemetryPasswordSalt = builder.comment("Salt used when hashing the reporting password. Configure before enabling telemetry.").define("passwordSalt", (Object)"");
        this.telemetryPasswordHash = builder.comment("Hex encoded SHA-256 hash of the salt concatenated with the reporting password.").define("passwordHash", (Object)"");
        this.telemetryClientEnabled = builder.comment("Allow client installs to emit telemetry when credentials are valid.").define("enableClient", true);
        this.telemetryServerEnabled = builder.comment("Allow dedicated servers to emit telemetry when credentials are valid.").define("enableServer", true);
        this.telemetryModpackId = builder.comment("Optional label applied to telemetry events.").define("modpackId", (Object)"");
        this.telemetryTracesSampleRate = builder.comment("Performance tracing sample rate between 0.0 and 1.0.").defineInRange("tracesSampleRate", 1.0, 0.0, 1.0);
        builder.pop();
        this.weakVestArmor = builder.defineInRange("weakVestArmor", 8.0, 0.0, 3.4028234663852886E38);
        this.weakVestArmorToughness = builder.defineInRange("weakVestArmorToughness", 1.0, 0.0, 3.4028234663852886E38);
        this.strongVestArmor = builder.defineInRange("strongVestArmor", 12.0, 0.0, 3.4028234663852886E38);
        this.strongVestArmorToughness = builder.defineInRange("strongVestArmorToughness", 2.0, 0.0, 3.4028234663852886E38);
    }

    static {
        Pair pair = new ForgeConfigSpec.Builder().configure(CommonConfig::new);
        configSpec = (ForgeConfigSpec)pair.getRight();
        instance = (CommonConfig)pair.getLeft();
    }
}

