/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.world.item.equipment;

import com.craftingdead.core.ServerConfig;
import com.craftingdead.core.world.item.ClothingItem;
import com.craftingdead.core.world.item.equipment.ClothingProtection;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class ClothingProtectionPresets {
    public static void applyByType(@NotNull ItemStack itemStack, @NotNull ClothingItem.ClothingType type) {
        switch (type) {
            case CASUAL: {
                ClothingProtectionPresets.applyCasualClothing(itemStack);
                break;
            }
            case UTILITY: {
                ClothingProtectionPresets.applyUtilityClothing(itemStack);
                break;
            }
            case MILITARY: {
                ClothingProtectionPresets.applyMilitaryClothing(itemStack);
                break;
            }
            case HEAVY: {
                ClothingProtectionPresets.applyHeavyClothing(itemStack);
            }
        }
    }

    public static void applyCasualClothing(@NotNull ItemStack itemStack) {
        ClothingProtection.applyProtectionAttributes(itemStack, ((Double)ServerConfig.instance.casualClothingBiteProtection.get()).floatValue(), ((Double)ServerConfig.instance.casualClothingStabResistance.get()).floatValue(), ((Double)ServerConfig.instance.casualClothingBluntResistance.get()).floatValue(), ((Double)ServerConfig.instance.casualClothingWeightModifier.get()).floatValue(), "casual");
    }

    public static void applyUtilityClothing(@NotNull ItemStack itemStack) {
        ClothingProtection.applyProtectionAttributes(itemStack, ((Double)ServerConfig.instance.utilityClothingBiteProtection.get()).floatValue(), ((Double)ServerConfig.instance.utilityClothingStabResistance.get()).floatValue(), ((Double)ServerConfig.instance.utilityClothingBluntResistance.get()).floatValue(), ((Double)ServerConfig.instance.utilityClothingWeightModifier.get()).floatValue(), "utility");
    }

    public static void applyMilitaryClothing(@NotNull ItemStack itemStack) {
        ClothingProtection.applyProtectionAttributes(itemStack, ((Double)ServerConfig.instance.militaryClothingBiteProtection.get()).floatValue(), ((Double)ServerConfig.instance.militaryClothingStabResistance.get()).floatValue(), ((Double)ServerConfig.instance.militaryClothingBluntResistance.get()).floatValue(), ((Double)ServerConfig.instance.militaryClothingWeightModifier.get()).floatValue(), "military");
    }

    public static void applyHeavyClothing(@NotNull ItemStack itemStack) {
        ClothingProtection.applyProtectionAttributes(itemStack, ((Double)ServerConfig.instance.heavyClothingBiteProtection.get()).floatValue(), ((Double)ServerConfig.instance.heavyClothingStabResistance.get()).floatValue(), ((Double)ServerConfig.instance.heavyClothingBluntResistance.get()).floatValue(), ((Double)ServerConfig.instance.heavyClothingWeightModifier.get()).floatValue(), "heavy");
    }
}

