/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.world.item;

import com.craftingdead.core.ServerConfig;
import com.craftingdead.core.world.action.item.ItemActionType;
import com.craftingdead.core.world.item.ActionItem;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class MedicalItem
extends ActionItem {
    private final MedicalItemType medicalType;

    public MedicalItem(Supplier<? extends ItemActionType<?>> itemActionType, Item.Properties properties, MedicalItemType medicalType) {
        super(itemActionType, properties);
        this.medicalType = medicalType;
    }

    public void m_7373_(@Nonnull ItemStack stack, @Nullable Level level, @Nonnull List<Component> lines, @Nonnull TooltipFlag tooltipFlag) {
        super.m_7373_(stack, level, lines, tooltipFlag);
        switch (this.medicalType) {
            case BANDAGE: {
                this.addDurationTooltip(lines, (Integer)ServerConfig.instance.bandageDurationTicks.get());
                this.addHealingTooltip(lines, ((Double)ServerConfig.instance.bandageHealAmount.get()).floatValue());
                if (!((Boolean)ServerConfig.instance.bandageRemovesBleeding.get()).booleanValue()) break;
                float chance = ((Double)ServerConfig.instance.bandageBleedReductionChance.get()).floatValue() * 100.0f;
                lines.add((Component)new TextComponent("\u271a ").m_130940_(ChatFormatting.DARK_RED).m_7220_((Component)new TranslatableComponent("medical.bleeding_stop_chance").m_130940_(ChatFormatting.GRAY).m_7220_((Component)new TextComponent(String.format(" %.0f%%", Float.valueOf(chance))).m_130940_(ChatFormatting.GREEN))));
                break;
            }
            case FIRST_AID_KIT: {
                int traumaReduction;
                float infectionChance;
                this.addDurationTooltip(lines, (Integer)ServerConfig.instance.firstAidKitDurationTicks.get());
                this.addHealingTooltip(lines, ((Double)ServerConfig.instance.firstAidKitHealAmount.get()).floatValue());
                if (((Boolean)ServerConfig.instance.firstAidKitRemovesBleeding.get()).booleanValue()) {
                    lines.add((Component)new TextComponent("\u271a ").m_130940_(ChatFormatting.DARK_RED).m_7220_((Component)new TranslatableComponent("medical.bleeding_stop").m_130940_(ChatFormatting.GREEN)));
                }
                if ((infectionChance = ((Double)ServerConfig.instance.firstAidKitInfectionReductionChance.get()).floatValue() * 100.0f) > 0.0f) {
                    lines.add((Component)new TextComponent("\u2726 ").m_130940_(ChatFormatting.LIGHT_PURPLE).m_7220_((Component)new TranslatableComponent("medical.infection_reduction_chance").m_130940_(ChatFormatting.GRAY).m_7220_((Component)new TextComponent(String.format(" %.0f%%", Float.valueOf(infectionChance))).m_130940_(ChatFormatting.GREEN))));
                }
                if ((traumaReduction = ((Integer)ServerConfig.instance.firstAidKitTraumaSeverityReduction.get()).intValue()) <= 0) break;
                lines.add((Component)new TextComponent("\u25c8 ").m_130940_(ChatFormatting.GOLD).m_7220_((Component)new TranslatableComponent("medical.trauma_reduction").m_130940_(ChatFormatting.GRAY).m_7220_((Component)new TextComponent(" " + traumaReduction + " levels").m_130940_(ChatFormatting.GREEN))));
                break;
            }
            case ADRENALINE_SYRINGE: {
                float bleedMultiplier;
                float slowReduction;
                this.addDurationTooltip(lines, 16);
                int effectDuration = (Integer)ServerConfig.instance.adrenalineDurationTicks.get() / 20;
                lines.add((Component)new TextComponent("\u231b ").m_130940_(ChatFormatting.YELLOW).m_7220_((Component)new TranslatableComponent("medical.effect_duration").m_130940_(ChatFormatting.GRAY).m_7220_((Component)new TextComponent(" " + effectDuration + "s").m_130940_(ChatFormatting.YELLOW))));
                lines.add((Component)new TextComponent("\u00bb ").m_130940_(ChatFormatting.YELLOW).m_7220_((Component)new TranslatableComponent("medical.adrenaline.speed_boost").m_130940_(ChatFormatting.GREEN)));
                lines.add((Component)new TextComponent("\u25a3 ").m_130940_(ChatFormatting.BLUE).m_7220_((Component)new TranslatableComponent("medical.adrenaline.absorption").m_130940_(ChatFormatting.GREEN)));
                float swayReduction = ((Double)ServerConfig.instance.adrenalineAimSwayReductionFactor.get()).floatValue() * 100.0f;
                if (swayReduction > 0.0f) {
                    lines.add((Component)new TextComponent("\u25c8 ").m_130940_(ChatFormatting.GOLD).m_7220_((Component)new TranslatableComponent("medical.adrenaline.aim_sway_reduction").m_130940_(ChatFormatting.GRAY).m_7220_((Component)new TextComponent(String.format(" %.0f%%", Float.valueOf(swayReduction))).m_130940_(ChatFormatting.GREEN))));
                }
                if ((slowReduction = ((Double)ServerConfig.instance.adrenalineSlowReductionFactor.get()).floatValue() * 100.0f) > 0.0f) {
                    lines.add((Component)new TextComponent("\u00ab ").m_130940_(ChatFormatting.DARK_GRAY).m_7220_((Component)new TranslatableComponent("medical.adrenaline.slow_reduction").m_130940_(ChatFormatting.GRAY).m_7220_((Component)new TextComponent(String.format(" %.0f%%", Float.valueOf(slowReduction))).m_130940_(ChatFormatting.GREEN))));
                }
                if ((bleedMultiplier = ((Double)ServerConfig.instance.adrenalineBleedChanceMultiplier.get()).floatValue()) == 1.0f) break;
                lines.add((Component)new TextComponent("\u271a ").m_130940_(ChatFormatting.DARK_RED).m_7220_((Component)new TranslatableComponent("medical.adrenaline.bleed_multiplier").m_130940_(ChatFormatting.GRAY).m_7220_((Component)new TextComponent(String.format(" %.1fx", Float.valueOf(bleedMultiplier))).m_130940_(bleedMultiplier > 1.0f ? ChatFormatting.GREEN : ChatFormatting.YELLOW))));
                break;
            }
            case BLOOD_SYRINGE: {
                this.addDurationTooltip(lines, (Integer)ServerConfig.instance.bloodSyringeDurationTicks.get());
                this.addHealingTooltip(lines, ((Double)ServerConfig.instance.bloodSyringeHealAmount.get()).floatValue());
                break;
            }
            case CLEAN_RAG: {
                this.addDurationTooltip(lines, (Integer)ServerConfig.instance.cleanRagDurationTicks.get());
                if (!((Boolean)ServerConfig.instance.cleanRagRemovesBleeding.get()).booleanValue()) break;
                lines.add((Component)new TextComponent("\u271a ").m_130940_(ChatFormatting.DARK_RED).m_7220_((Component)new TranslatableComponent("medical.bleeding_stop").m_130940_(ChatFormatting.GREEN)));
                break;
            }
            case SYRINGE: {
                lines.add((Component)new TextComponent("\u2726 ").m_130940_(ChatFormatting.LIGHT_PURPLE).m_7220_((Component)new TranslatableComponent("medical.syringe.empty").m_130940_(ChatFormatting.GRAY)));
            }
        }
    }

    private void addDurationTooltip(List<Component> lines, int durationTicks) {
        float durationSeconds = (float)durationTicks / 20.0f;
        lines.add((Component)new TextComponent("\u231a ").m_130940_(ChatFormatting.AQUA).m_7220_((Component)new TranslatableComponent("medical.use_duration").m_130940_(ChatFormatting.GRAY).m_7220_((Component)new TextComponent(String.format(" %.1fs", Float.valueOf(durationSeconds))).m_130940_(ChatFormatting.YELLOW))));
    }

    private void addHealingTooltip(List<Component> lines, float healAmount) {
        if (healAmount > 0.0f) {
            lines.add((Component)new TextComponent("\u2665 ").m_130940_(ChatFormatting.RED).m_7220_((Component)new TranslatableComponent("medical.healing").m_130940_(ChatFormatting.GRAY).m_7220_((Component)new TextComponent(String.format(" %.1f", Float.valueOf(healAmount))).m_130940_(ChatFormatting.RED))));
        }
    }

    public static enum MedicalItemType {
        BANDAGE,
        FIRST_AID_KIT,
        ADRENALINE_SYRINGE,
        BLOOD_SYRINGE,
        CLEAN_RAG,
        SYRINGE;

    }
}

