/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.world.item;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.IRegistryDelegate;
import org.jetbrains.annotations.Nullable;

public class ArbitraryTooltips {
    private static final Multimap<Supplier<? extends Item>, TooltipFunction> toRegister = ArrayListMultimap.create();
    private static final Multimap<IRegistryDelegate<? extends Item>, TooltipFunction> functions = ArrayListMultimap.create();

    public static void registerTooltip(Supplier<? extends Item> item, Component tooltip) {
        ArbitraryTooltips.registerTooltip(item, (ItemStack stack, Level level, TooltipFlag flag) -> tooltip);
    }

    public static void registerTooltip(Supplier<? extends Item> item, TooltipFunction function) {
        toRegister.put(item, (Object)function);
    }

    public static void registerTooltip(Item item, TooltipFunction function) {
        functions.put((Object)item.delegate, (Object)function);
    }

    public static void registerAll() {
        toRegister.asMap().forEach((supplier, lines) -> functions.putAll((Object)((Item)supplier.get()).delegate, (Iterable)lines));
        toRegister.clear();
    }

    public static Collection<TooltipFunction> getFunctions(Item item) {
        return functions.get((Object)item.delegate);
    }

    @FunctionalInterface
    public static interface TooltipFunction {
        @Nullable
        public Component createTooltip(ItemStack var1, @Nullable Level var2, TooltipFlag var3);
    }
}

