/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.world.inventory;

import com.craftingdead.core.world.entity.extension.PlayerExtension;
import com.craftingdead.core.world.inventory.ModMenuTypes;
import java.util.Optional;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class CraftingMenu
extends AbstractContainerMenu {
    private final PlayerExtension<?> player;
    private final CraftingContainer craftingGrid;
    private final ResultContainer resultSlot;

    public CraftingMenu(int id, Inventory inventory) {
        this(id, PlayerExtension.getOrThrow(inventory.f_35978_));
    }

    public CraftingMenu(int id, PlayerExtension<?> player) {
        super((MenuType)ModMenuTypes.CRAFTING.get(), id);
        this.player = player;
        this.craftingGrid = new CraftingContainer((AbstractContainerMenu)this, 2, 2);
        this.resultSlot = new ResultContainer();
        this.setupCraftingSlots();
        this.setupPlayerInventorySlots(((Player)player.entity()).m_150109_());
    }

    private void setupCraftingSlots() {
        int slotSize = 18;
        for (int y = 0; y < 2; ++y) {
            for (int x = 0; x < 2; ++x) {
                this.m_38897_(new Slot((Container)this.craftingGrid, x + y * 2, 83 + x * 18, 27 + y * 18));
            }
        }
        this.m_38897_(new Slot((Container)this.resultSlot, 0, 141, 36){

            public boolean m_5857_(@NotNull ItemStack stack) {
                return false;
            }

            public void m_142406_(@NotNull Player player, @NotNull ItemStack stack) {
                super.m_142406_(player, stack);
                CraftingMenu.this.handleCraftingResultTaken();
            }
        });
    }

    private void setupPlayerInventorySlots(Inventory inventory) {
        int slotSize = 18;
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.m_38897_(new Slot((Container)inventory, x + (y + 1) * 9, 8 + x * 18, 84 + y * 18));
            }
        }
        for (int x = 0; x < 9; ++x) {
            this.m_38897_(new Slot((Container)inventory, x, 8 + x * 18, 141));
        }
    }

    @NotNull
    public ItemStack m_7648_(@NotNull Player player, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot.m_6657_()) {
            ItemStack stack = slot.m_7993_();
            itemstack = stack.m_41777_();
            if (index == 4) {
                Level level = player.f_19853_;
                Optional recipeOpt = level.m_7465_().m_44015_(RecipeType.f_44107_, (Container)this.craftingGrid, level);
                if (recipeOpt.isPresent()) {
                    CraftingRecipe recipe = (CraftingRecipe)recipeOpt.get();
                    ItemStack result = recipe.m_5874_((Container)this.craftingGrid).m_41777_();
                    while (this.m_38903_(result.m_41777_(), 5, 41, true)) {
                        NonNullList remaining = recipe.m_7457_((Container)this.craftingGrid);
                        for (int i = 0; i < remaining.size(); ++i) {
                            ItemStack input = this.craftingGrid.m_8020_(i);
                            ItemStack remainingItem = (ItemStack)remaining.get(i);
                            if (!input.m_41619_()) {
                                this.craftingGrid.m_7407_(i, 1);
                            }
                            if (remainingItem.m_41619_()) continue;
                            if (this.craftingGrid.m_8020_(i).m_41619_()) {
                                this.craftingGrid.m_6836_(i, remainingItem);
                                continue;
                            }
                            player.m_150109_().m_150079_(remainingItem);
                        }
                        if (!recipe.m_5818_((Container)this.craftingGrid, level)) break;
                        result = recipe.m_5874_((Container)this.craftingGrid).m_41777_();
                    }
                    this.updateResult();
                }
            } else if (index >= 5 && index <= 31 ? !this.m_38903_(stack, 0, 4, false) : (index >= 32 && index <= 40 ? !this.m_38903_(stack, 0, 4, false) && !this.m_38903_(stack, 5, 32, false) : index >= 0 && index <= 3 && !this.m_38903_(stack, 32, 41, false) && !this.m_38903_(stack, 5, 32, false))) {
                return ItemStack.f_41583_;
            }
            if (stack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (stack.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, stack);
        }
        return itemstack;
    }

    public void m_6199_(@NotNull Container container) {
        this.updateResult();
    }

    public void m_6877_(@NotNull Player player) {
        super.m_6877_(player);
        this.returnItemsToPlayerInventory();
    }

    public boolean m_6875_(@NotNull Player player) {
        return true;
    }

    public void updateResult() {
        if (((Player)this.player.entity()).m_183503_().m_5776_()) {
            return;
        }
        Level level = ((Player)this.player.entity()).m_183503_();
        RecipeManager recipeManager = level.m_7465_();
        Optional recipeOpt = recipeManager.m_44015_(RecipeType.f_44107_, (Container)this.craftingGrid, level);
        if (recipeOpt.isPresent()) {
            CraftingRecipe recipe = (CraftingRecipe)recipeOpt.get();
            ItemStack result = recipe.m_5874_((Container)this.craftingGrid);
            this.resultSlot.m_6836_(0, result);
        } else {
            this.resultSlot.m_6836_(0, ItemStack.f_41583_);
        }
        this.resultSlot.m_6596_();
        this.m_38946_();
    }

    private void handleCraftingResultTaken() {
        Level level = ((Player)this.player.entity()).m_183503_();
        RecipeManager recipeManager = level.m_7465_();
        Optional recipeOpt = recipeManager.m_44015_(RecipeType.f_44107_, (Container)this.craftingGrid, level);
        if (recipeOpt.isPresent()) {
            CraftingRecipe recipe = (CraftingRecipe)recipeOpt.get();
            NonNullList remainingItems = recipe.m_7457_((Container)this.craftingGrid);
            for (int i = 0; i < remainingItems.size(); ++i) {
                ItemStack current = this.craftingGrid.m_8020_(i);
                ItemStack remaining = (ItemStack)remainingItems.get(i);
                if (current.m_41619_()) continue;
                if (!remaining.m_41619_()) {
                    this.craftingGrid.m_6836_(i, remaining.m_41777_());
                    continue;
                }
                this.craftingGrid.m_7407_(i, 1);
            }
            this.updateResult();
        }
    }

    private void returnItemsToPlayerInventory() {
        for (int i = 0; i < this.craftingGrid.m_6643_(); ++i) {
            ItemStack itemstack = this.craftingGrid.m_8020_(i);
            if (itemstack.m_41619_()) continue;
            ((Player)this.player.entity()).m_150109_().m_150079_(itemstack);
        }
    }
}

