/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.world.entity.extension;

import com.craftingdead.core.world.entity.extension.LivingExtension;
import com.craftingdead.core.world.entity.extension.LivingHandlerType;
import com.craftingdead.core.world.entity.extension.PlayerHandler;
import com.craftingdead.core.world.item.equipment.ClothingProtection;
import com.craftingdead.core.world.item.equipment.Equipment;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClothingProtectionHandler
implements PlayerHandler {
    public static final LivingHandlerType<ClothingProtectionHandler> TYPE = new LivingHandlerType(new ResourceLocation("craftingdead", "clothing_protection"));
    private static final Logger logger = LoggerFactory.getLogger(ClothingProtectionHandler.class);
    private final LivingExtension<?, ?> extension;
    private static final String ZOMBIE_DAMAGE = "mob";
    private static final String MELEE_DAMAGE = "player";
    private static final String BLUNT_DAMAGE = "blunt";
    private static final String STAB_DAMAGE = "stab";

    public ClothingProtectionHandler(LivingExtension<?, ?> extension) {
        this.extension = extension;
    }

    @Override
    public float handleDamaged(DamageSource source, float amount) {
        ItemStack clothingStack = this.extension.getItemInSlot(Equipment.Slot.CLOTHING);
        if (clothingStack.m_41619_()) {
            return amount;
        }
        if (!ClothingProtection.hasProtectionAttributes(clothingStack)) {
            return amount;
        }
        float finalDamage = amount;
        DamageType damageType = this.detectDamageType(source);
        switch (damageType) {
            case ZOMBIE_BITE: {
                float biteProtection = ClothingProtection.getBiteProtection(clothingStack);
                finalDamage = ClothingProtection.calculateFinalDamage(amount, biteProtection * 0.3f);
                if (!(biteProtection > 0.0f)) break;
                float baseInfectionChance = 0.15f;
                float finalInfectionChance = ClothingProtection.calculateInfectionChance(baseInfectionChance, biteProtection);
                logger.debug("Bite attack: Damage {} -> {}, Infection chance {} -> {}", new Object[]{Float.valueOf(amount), Float.valueOf(finalDamage), Float.valueOf(baseInfectionChance), Float.valueOf(finalInfectionChance)});
                break;
            }
            case MELEE_STAB: {
                float stabResistance = ClothingProtection.getStabResistance(clothingStack);
                finalDamage = ClothingProtection.calculateFinalDamage(amount, stabResistance * 0.2f);
                if (!(stabResistance > 0.0f)) break;
                float baseBleedChance = 0.25f;
                float finalBleedChance = ClothingProtection.calculateBleedChance(baseBleedChance, stabResistance);
                logger.debug("Stab attack: Damage {} -> {}, Bleed chance {} -> {}", new Object[]{Float.valueOf(amount), Float.valueOf(finalDamage), Float.valueOf(baseBleedChance), Float.valueOf(finalBleedChance)});
                break;
            }
            case BLUNT_IMPACT: {
                float bluntResistance = ClothingProtection.getBluntResistance(clothingStack);
                finalDamage = ClothingProtection.calculateFinalDamage(amount, bluntResistance);
                if (!(bluntResistance > 0.0f)) break;
                logger.debug("Blunt attack: Damage {} -> {} ({}% reduction)", new Object[]{Float.valueOf(amount), Float.valueOf(finalDamage), Float.valueOf(bluntResistance * 100.0f)});
                break;
            }
            case PROJECTILE: {
                float minimalProtection = Math.max(ClothingProtection.getBiteProtection(clothingStack), ClothingProtection.getStabResistance(clothingStack)) * 0.1f;
                finalDamage = ClothingProtection.calculateFinalDamage(amount, minimalProtection);
                break;
            }
        }
        if (finalDamage != amount) {
            logger.info("Clothing protection applied: {} damage reduced to {} (Type: {}, Tier: {})", new Object[]{Float.valueOf(amount), Float.valueOf(finalDamage), damageType, ClothingProtection.getClothingTier(clothingStack)});
        }
        return finalDamage;
    }

    private DamageType detectDamageType(DamageSource source) {
        LivingEntity attacker;
        String attackerType;
        String sourceMsg = source.m_19385_().toLowerCase();
        Entity entity = source.m_7639_();
        if (entity instanceof LivingEntity && ((attackerType = (attacker = (LivingEntity)entity).m_6095_().toString().toLowerCase()).contains("zombie") || sourceMsg.contains(ZOMBIE_DAMAGE))) {
            return DamageType.ZOMBIE_BITE;
        }
        if (sourceMsg.contains(MELEE_DAMAGE) || sourceMsg.contains(ZOMBIE_DAMAGE)) {
            if (sourceMsg.contains(STAB_DAMAGE) || sourceMsg.contains("blade") || sourceMsg.contains("knife")) {
                return DamageType.MELEE_STAB;
            }
            return DamageType.BLUNT_IMPACT;
        }
        if (source.m_19360_() || sourceMsg.contains("arrow") || sourceMsg.contains("bullet")) {
            return DamageType.PROJECTILE;
        }
        if (source.m_19384_() || source.m_146707_() || sourceMsg.contains("fall") || sourceMsg.contains("drown") || sourceMsg.contains("lava")) {
            return DamageType.ENVIRONMENTAL;
        }
        return DamageType.UNKNOWN;
    }

    private BodyRegion detectBodyRegion(DamageSource source) {
        return BodyRegion.TORSO;
    }

    @Override
    public void encode(FriendlyByteBuf out, boolean writeAll) {
    }

    @Override
    public void decode(FriendlyByteBuf in) {
    }

    @Override
    public boolean requiresSync() {
        return false;
    }

    private static enum DamageType {
        ZOMBIE_BITE,
        MELEE_STAB,
        BLUNT_IMPACT,
        PROJECTILE,
        ENVIRONMENTAL,
        UNKNOWN;

    }

    private static enum BodyRegion {
        HEAD,
        TORSO,
        LIMBS;

    }
}

