/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.world.entity.extension;

import com.craftingdead.core.ServerConfig;
import com.craftingdead.core.event.LivingExtensionEvent;
import com.craftingdead.core.network.NetworkChannel;
import com.craftingdead.core.network.message.play.CancelActionMessage;
import com.craftingdead.core.network.message.play.CrouchMessage;
import com.craftingdead.core.network.message.play.PerformActionMessage;
import com.craftingdead.core.sounds.ModSoundEvents;
import com.craftingdead.core.world.action.Action;
import com.craftingdead.core.world.action.ActionObserver;
import com.craftingdead.core.world.entity.EntityUtil;
import com.craftingdead.core.world.entity.extension.EntitySnapshot;
import com.craftingdead.core.world.entity.extension.LivingExtension;
import com.craftingdead.core.world.entity.extension.LivingHandler;
import com.craftingdead.core.world.entity.extension.LivingHandlerType;
import com.craftingdead.core.world.entity.extension.PlayerExtension;
import com.craftingdead.core.world.entity.extension.Visibility;
import com.craftingdead.core.world.item.ClothingItem;
import com.craftingdead.core.world.item.MeleeWeaponItem;
import com.craftingdead.core.world.item.equipment.Clothing;
import com.craftingdead.core.world.item.equipment.Equipment;
import com.craftingdead.core.world.item.equipment.Hat;
import com.craftingdead.core.world.item.gun.Gun;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

class BaseLivingExtension<E extends LivingEntity, H extends LivingHandler>
implements LivingExtension<E, H> {
    private final E entity;
    protected final Map<LivingHandlerType<? extends H>, H> handlers = new Object2ObjectArrayMap();
    protected final Map<LivingHandlerType<? extends H>, H> dirtyHandlers = new Object2ObjectArrayMap();
    private final IntSet dirtySlots = new IntOpenHashSet();
    private final EntitySnapshot[] snapshots = new EntitySnapshot[20];
    protected final ItemStackHandler itemHandler = new ItemStackHandler(Equipment.Slot.values().length){

        protected void onLoad() {
            if (this.getSlots() != Equipment.Slot.values().length) {
                this.setSize(Equipment.Slot.values().length);
            }
            Arrays.stream(Equipment.Slot.values()).map(Equipment.Slot::getIndex).map(arg_0 -> (this).getStackInSlot(arg_0)).forEach(BaseLivingExtension.this::applyEquipmentModifiers);
        }

        public void onContentsChanged(int slot) {
            if (!BaseLivingExtension.this.level().m_5776_()) {
                BaseLivingExtension.this.dirtySlots.add(slot);
            }
        }
    };
    protected ItemStack lastHeldStack = null;
    protected float[] equipmentDropChances = new float[Equipment.Slot.values().length];
    @Nullable
    private Action action;
    @Nullable
    private ActionObserver actionObserver;
    private boolean movementBlocked;
    private boolean crouching;
    private Vec3 lastPos;
    private boolean moving;
    private Visibility cachedVisibility = Visibility.VISIBLE;

    BaseLivingExtension(E entity) {
        this.entity = entity;
        Arrays.fill(this.equipmentDropChances, 2.0f);
    }

    @Override
    public void load() {
        MinecraftForge.EVENT_BUS.post((Event)new LivingExtensionEvent.Load(this));
    }

    @Override
    public <T extends H> void registerHandler(LivingHandlerType<T> type, T handler) {
        if (this.handlers.put(type, handler) != null) {
            throw new IllegalArgumentException("Duplicate handler: " + type);
        }
    }

    @Override
    public <T extends H> void removeHandler(LivingHandlerType<T> type) {
        this.handlers.remove(type);
    }

    @Override
    public <T extends LivingHandler> Optional<T> getHandler(LivingHandlerType<T> type) {
        return Optional.ofNullable((LivingHandler)this.handlers.get(type));
    }

    @Override
    public <T extends LivingHandler> T getHandlerOrThrow(LivingHandlerType<T> type) {
        LivingHandler handler = (LivingHandler)this.handlers.get(type);
        if (handler == null) {
            throw new IllegalStateException("Missing handler: " + type);
        }
        return (T)handler;
    }

    @Override
    public Optional<Action> getAction() {
        return Optional.ofNullable(this.action);
    }

    @Override
    public <T extends Action> boolean performAction(T action, boolean force, boolean sendUpdate) {
        if (MinecraftForge.EVENT_BUS.post(new LivingExtensionEvent.PerformAction<T>(this, action))) {
            return false;
        }
        if (this.isObservingAction() || action.target().map(LivingExtension::isObservingAction).orElse(false).booleanValue()) {
            return false;
        }
        if (!action.start(false)) {
            return false;
        }
        this.cancelAction(true);
        this.action = action;
        this.setActionObserver(action.createPerformerObserver());
        action.target().ifPresent(target -> target.setActionObserver(action.createTargetObserver()));
        if (sendUpdate) {
            PacketDistributor.PacketTarget target2 = this.level().m_5776_() ? PacketDistributor.SERVER.noArg() : PacketDistributor.TRACKING_ENTITY_AND_SELF.with(this::entity);
            FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
            action.type().encode(action, buf);
            NetworkChannel.PLAY.getSimpleChannel().send(target2, (Object)new PerformActionMessage(action.type(), this.entity().m_142049_(), buf));
        }
        return true;
    }

    @Override
    public void cancelAction(boolean sendUpdate) {
        if (this.action == null) {
            return;
        }
        this.stopAction(Action.StopReason.CANCELLED);
        if (sendUpdate) {
            PacketDistributor.PacketTarget target = this.level().m_5776_() ? PacketDistributor.SERVER.noArg() : PacketDistributor.TRACKING_ENTITY_AND_SELF.with(this::entity);
            NetworkChannel.PLAY.getSimpleChannel().send(target, (Object)new CancelActionMessage(this.entity().m_142049_()));
        }
    }

    @Override
    public void setActionObserver(ActionObserver actionObserver) {
        this.actionObserver = actionObserver;
    }

    @Override
    public Optional<ActionObserver> getActionObserver() {
        return Optional.ofNullable(this.actionObserver);
    }

    private void stopAction(Action.StopReason reason) {
        if (this.action != null) {
            this.action.stop(reason);
            this.action.target().ifPresent(target -> target.setActionObserver(null));
            this.setActionObserver(null);
            this.action = null;
        }
    }

    @Override
    public void setMovementBlocked(boolean movementBlocked) {
        this.movementBlocked = movementBlocked;
    }

    @Override
    public boolean isMovementBlocked() {
        return this.movementBlocked;
    }

    @Override
    public boolean isMoving() {
        return this.moving;
    }

    @Override
    public void tick() {
        ItemStack heldStack = this.mainHandItem();
        if (heldStack != this.lastHeldStack) {
            if (this.lastHeldStack != null) {
                this.lastHeldStack.getCapability(Gun.CAPABILITY).ifPresent(gun -> gun.reset(this));
            }
            if ((this.lastHeldStack == null || !heldStack.m_150930_(this.lastHeldStack.m_41720_())) && heldStack.getCapability(Gun.CAPABILITY).isPresent()) {
                this.entity.m_5496_((SoundEvent)ModSoundEvents.GUN_EQUIP.get(), 0.25f, 1.0f);
            }
            this.lastHeldStack = heldStack;
        }
        this.movementBlocked = false;
        if (this.action != null && this.action.tick() && this.action != null) {
            this.stopAction(Action.StopReason.COMPLETED);
        }
        heldStack.getCapability(Gun.CAPABILITY).ifPresent(gun -> gun.tick(this));
        this.getEquipmentInSlot(Equipment.Slot.CLOTHING, Clothing.class).ifPresent(this::tickClothing);
        this.getEquipmentInSlot(Equipment.Slot.HAT, Hat.class).ifPresent(this::tickHat);
        if (!this.level().m_5776_()) {
            this.snapshots[this.entity.m_20194_().m_129921_() % 20] = this.makeSnapshot(1.0f);
        }
        this.moving = !this.entity.m_20182_().equals((Object)this.lastPos);
        this.lastPos = this.entity.m_20182_();
        this.handlers.forEach(this::tickHandler);
    }

    protected void tickHandler(LivingHandlerType<? extends H> type, H handler) {
        handler.tick();
        this.cachedVisibility = Visibility.VISIBLE;
        switch (handler.getVisibility()) {
            case INVISIBLE: {
                this.cachedVisibility = Visibility.INVISIBLE;
            }
            case PARTIALLY_VISIBLE: {
                if (this.cachedVisibility != Visibility.VISIBLE) break;
                this.cachedVisibility = Visibility.PARTIALLY_VISIBLE;
                break;
            }
        }
        if (handler.isMovementBlocked()) {
            this.movementBlocked = true;
        }
        if (handler.requiresSync()) {
            this.dirtyHandlers.put(type, handler);
        }
    }

    private void tickHat(Hat hat) {
        if (hat.waterBreathing() && this.entity.m_204029_(FluidTags.f_13131_)) {
            this.entity.m_7292_(new MobEffectInstance(MobEffects.f_19608_, 2, 0, false, false, false));
        }
        if (hat.nightVision()) {
            this.entity.m_7292_(new MobEffectInstance(MobEffects.f_19611_, 2, 0, false, false, false));
        }
    }

    private void tickClothing(Clothing clothing) {
        if (clothing.fireImmunity()) {
            if (this.entity.m_20094_() > 0) {
                this.entity.m_20095_();
            }
            this.entity.m_7292_(new MobEffectInstance(MobEffects.f_19607_, 2, 0, false, false, false));
        }
        if (clothing.enhancesSwimming() && this.entity.m_204029_(FluidTags.f_13131_)) {
            this.entity.m_7292_(new MobEffectInstance(MobEffects.f_19593_, 2, 0, false, false, false));
        }
    }

    @Override
    public float handleDamaged(DamageSource source, float amount) {
        PlayerExtension<Player> playerExtension;
        E usedMeleeWeapon2;
        Player player;
        Float damage = this.handlers.values().stream().reduce(Float.valueOf(amount), (result, extension) -> Float.valueOf(extension.handleDamaged(source, result.floatValue())), (u, t) -> t);
        Entity entity = source.m_7639_();
        if (entity instanceof Player) {
            boolean usedMeleeWeapon2;
            player = (Player)entity;
            if (((Boolean)ServerConfig.instance.backstabEnabled.get()).booleanValue() && (usedMeleeWeapon2 = player.m_21120_(player.m_7655_()).m_41720_() instanceof MeleeWeaponItem) && !EntityUtil.canSee(this.entity(), (Entity)player, 90.0f)) {
                damage = Float.valueOf(damage.floatValue() * ((Double)ServerConfig.instance.backstabBonusDamage.get()).floatValue());
            }
            if (((Boolean)ServerConfig.instance.criticalHitEnable.get()).booleanValue() && (Double)ServerConfig.instance.criticalHitChance.get() > (double)player.m_21187_().nextFloat()) {
                damage = Float.valueOf(damage.floatValue() * ((Double)ServerConfig.instance.criticalHitBonusDamage.get()).floatValue());
            }
        }
        if ((usedMeleeWeapon2 = this.entity()) instanceof Player && !(playerExtension = PlayerExtension.getOrThrow(player = (Player)usedMeleeWeapon2)).getItemInSlot(Equipment.Slot.CLOTHING).m_41619_() && source.m_7639_() != null) {
            damage = Float.valueOf(Objects.requireNonNull(ClothingItem.getClothingItem(player)).calculateDamage(damage.floatValue()));
        }
        return damage.floatValue();
    }

    @Override
    public boolean handleHurt(DamageSource source, float amount) {
        return this.handlers.values().stream().anyMatch(e -> e.handleHurt(source, amount));
    }

    @Override
    public boolean handleKill(Entity target) {
        return this.handlers.values().stream().anyMatch(e -> e.handleKill(target));
    }

    @Override
    public boolean handleDeath(DamageSource cause) {
        if (this.handlers.values().stream().anyMatch(e -> e.handleDeath(cause))) {
            return true;
        }
        this.cancelAction(true);
        return false;
    }

    @Override
    public boolean handleDeathLoot(DamageSource cause, Collection<ItemEntity> drops, int lootingLevel) {
        if (this.handlers.values().stream().anyMatch(e -> e.handleDeathLoot(cause, drops, lootingLevel))) {
            return true;
        }
        if (!this.keepInventory()) {
            for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
                ItemStack itemStack = this.itemHandler.extractItem(i, Integer.MAX_VALUE, false);
                float dropChance = this.equipmentDropChances[i];
                if (itemStack.m_41619_() || !(Math.max(this.random().nextFloat() - (float)lootingLevel * 0.01f, 0.0f) < dropChance)) continue;
                ItemEntity itemEntity = new ItemEntity(this.level(), this.entity().m_20185_(), this.entity().m_20186_(), this.entity().m_20189_(), itemStack);
                itemEntity.m_32060_();
                drops.add(itemEntity);
            }
        }
        return false;
    }

    @Override
    public boolean handleBlockPlace(BlockSnapshot replacedBlock, BlockState placedBlock, BlockState placedAgainst) {
        return this.handlers.values().stream().anyMatch(e -> e.handleBlockPlace(replacedBlock, placedBlock, placedAgainst));
    }

    @Override
    public boolean handleMultiBlockPlace(List<BlockSnapshot> replacedBlocks, BlockState placedBlock, BlockState placedAgainst) {
        return this.handlers.values().stream().anyMatch(e -> e.handleMultiBlockPlace(replacedBlocks, placedBlock, placedAgainst));
    }

    protected boolean keepInventory() {
        return false;
    }

    @Override
    public Visibility getVisibility() {
        return this.cachedVisibility;
    }

    @Override
    public EntitySnapshot getSnapshot(int tick) {
        int currentTick = this.entity.m_20194_().m_129921_();
        if (tick == currentTick) {
            return this.makeSnapshot(1.0f);
        }
        if (tick < currentTick - 20) {
            return this.snapshots[0];
        }
        if (tick > currentTick) {
            throw new IllegalStateException("Tick bigger than current tick");
        }
        int snapshotIndex = tick % 20;
        EntitySnapshot snapshot = this.snapshots[snapshotIndex];
        if (snapshot == null) {
            throw new IndexOutOfBoundsException();
        }
        return snapshot;
    }

    @Override
    public boolean isCrouching() {
        return this.crouching;
    }

    @Override
    public void setCrouching(boolean crouching, boolean sendUpdate) {
        if (!this.entity.m_20096_()) {
            return;
        }
        this.crouching = crouching;
        if (sendUpdate) {
            PacketDistributor.PacketTarget target = this.level().m_5776_() ? PacketDistributor.SERVER.noArg() : PacketDistributor.TRACKING_ENTITY_AND_SELF.with(this::entity);
            NetworkChannel.PLAY.getSimpleChannel().send(target, (Object)new CrouchMessage(this.entity().m_142049_(), crouching));
        }
    }

    @Override
    public E entity() {
        return this.entity;
    }

    @Override
    public float getEquipmentDropChance(Equipment.Slot slot) {
        return this.equipmentDropChances[slot.getIndex()];
    }

    @Override
    public void setEquipmentDropChance(Equipment.Slot slot, float chance) {
        this.equipmentDropChances[slot.getIndex()] = chance;
    }

    @Override
    public ItemStack getItemInSlot(Equipment.Slot slot) {
        return this.itemHandler.getStackInSlot(slot.getIndex());
    }

    @Override
    public ItemStack setItemInSlot(Equipment.Slot slot, ItemStack itemStack) {
        AttributeMap attributes = this.entity.m_21204_();
        ItemStack oldStack = this.getItemInSlot(slot);
        oldStack.getCapability(Equipment.CAPABILITY).map(Equipment::attributeModifiers).ifPresent(arg_0 -> ((AttributeMap)attributes).m_22161_(arg_0));
        this.applyEquipmentModifiers(itemStack);
        this.itemHandler.setStackInSlot(slot.getIndex(), itemStack);
        return oldStack;
    }

    private void applyEquipmentModifiers(ItemStack itemStack) {
        AttributeMap attributes = this.entity.m_21204_();
        itemStack.getCapability(Equipment.CAPABILITY).map(Equipment::attributeModifiers).ifPresent(arg_0 -> ((AttributeMap)attributes).m_22178_(arg_0));
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        for (Map.Entry<LivingHandlerType<H>, H> entry : this.handlers.entrySet()) {
            CompoundTag extensionTag = ((LivingHandler)entry.getValue()).serializeNBT();
            if (extensionTag.m_128456_()) continue;
            tag.m_128365_(entry.getKey().toString(), (Tag)extensionTag);
        }
        ListTag dropChances = new ListTag();
        for (float dropChance : this.equipmentDropChances) {
            dropChances.add((Object)FloatTag.m_128566_((float)dropChance));
        }
        tag.m_128365_("dropChances", (Tag)dropChances);
        return tag;
    }

    @Override
    public void deserializeNBT(CompoundTag tag) {
        this.itemHandler.deserializeNBT(tag.m_128469_("inventory"));
        for (Map.Entry<LivingHandlerType<H>, H> entry : this.handlers.entrySet()) {
            CompoundTag extensionTag = tag.m_128469_(entry.getKey().toString());
            if (extensionTag.m_128456_()) continue;
            ((LivingHandler)entry.getValue()).deserializeNBT(extensionTag);
        }
        if (tag.m_128425_("dropChances", 9)) {
            ListTag dropChances = tag.m_128437_("dropChances", 5);
            for (int i = 0; i < dropChances.size(); ++i) {
                this.equipmentDropChances[i] = dropChances.m_128775_(i);
            }
        }
    }

    public int hashCode() {
        return this.entity.hashCode();
    }

    public boolean equals(Object obj) {
        LivingExtension extension;
        return super.equals(obj) || obj instanceof LivingExtension && (extension = (LivingExtension)obj).entity().equals(this.entity);
    }

    @Override
    public void encode(FriendlyByteBuf out, boolean writeAll) {
        if (writeAll) {
            for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
                out.writeShort(i);
                out.m_130055_(this.itemHandler.getStackInSlot(i));
            }
        } else {
            this.dirtySlots.forEach(slot -> {
                out.writeShort(slot);
                out.m_130055_(this.itemHandler.getStackInSlot(slot));
            });
            this.dirtySlots.clear();
        }
        out.writeShort(255);
        Set<Map.Entry<LivingHandlerType<H>, H>> handlersToSend = writeAll ? this.handlers.entrySet() : this.dirtyHandlers.entrySet();
        out.m_130130_(handlersToSend.size());
        for (Map.Entry<LivingHandlerType<H>, H> entry : handlersToSend) {
            out.m_130085_(entry.getKey().id());
            FriendlyByteBuf handlerData = new FriendlyByteBuf(Unpooled.buffer());
            ((LivingHandler)entry.getValue()).encode(handlerData, writeAll);
            out.m_130130_(handlerData.readableBytes());
            out.writeBytes((ByteBuf)handlerData);
        }
        this.dirtyHandlers.clear();
    }

    @Override
    public void decode(FriendlyByteBuf in) {
        short slot;
        while ((slot = in.readShort()) != 255) {
            this.itemHandler.setStackInSlot((int)slot, in.m_130267_());
        }
        int handlersSize = in.m_130242_();
        for (int x = 0; x < handlersSize; ++x) {
            ResourceLocation id = in.m_130281_();
            int dataSize = in.m_130242_();
            LivingHandler handler = (LivingHandler)this.handlers.get(new LivingHandlerType(id));
            if (handler == null) {
                in.readerIndex(in.readerIndex() + dataSize);
                continue;
            }
            handler.decode(in);
        }
    }

    @Override
    public boolean requiresSync() {
        return !this.dirtySlots.isEmpty() || !this.dirtyHandlers.isEmpty();
    }
}

