/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.network.message.play;

import com.craftingdead.core.world.entity.extension.EntitySnapshot;
import com.craftingdead.core.world.entity.extension.LivingExtension;
import com.craftingdead.core.world.entity.extension.PlayerExtension;
import com.craftingdead.core.world.item.gun.PendingHit;
import it.unimi.dsi.fastutil.ints.Int2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;

public record ValidatePendingHitMessage(Map<Integer, Collection<PendingHit>> hits) {
    public void encode(FriendlyByteBuf out) {
        out.m_130130_(this.hits.size());
        for (Map.Entry<Integer, Collection<PendingHit>> hit : this.hits.entrySet()) {
            out.m_130130_(hit.getKey().intValue());
            out.m_130130_(hit.getValue().size());
            for (PendingHit value : hit.getValue()) {
                out.writeByte((int)value.tickOffset());
                value.playerSnapshot().encode(out);
                value.hitSnapshot().encode(out);
                out.m_130103_(value.randomSeed());
                out.m_130130_(value.shotCount());
            }
        }
    }

    public static ValidatePendingHitMessage decode(FriendlyByteBuf in) {
        int hitsSize = in.m_130242_();
        Int2ObjectLinkedOpenHashMap hits = new Int2ObjectLinkedOpenHashMap();
        for (int i = 0; i < hitsSize; ++i) {
            int key = in.m_130242_();
            int valueSize = in.m_130242_();
            ObjectArrayList value = new ObjectArrayList();
            for (int j = 0; j < valueSize; ++j) {
                value.add((Object)new PendingHit(in.readByte(), EntitySnapshot.decode(in), EntitySnapshot.decode(in), in.m_130258_(), in.m_130242_()));
            }
            hits.put(key, (Object)value);
        }
        return new ValidatePendingHitMessage((Map<Integer, Collection<PendingHit>>)hits);
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            PlayerExtension<ServerPlayer> player = PlayerExtension.getOrThrow(((NetworkEvent.Context)ctx.get()).getSender());
            player.mainHandGun().ifPresent(gun -> {
                for (Map.Entry<Integer, Collection<PendingHit>> hit : this.hits.entrySet()) {
                    Optional.ofNullable(player.level().m_6815_(hit.getKey().intValue())).flatMap(entity -> entity.getCapability(LivingExtension.CAPABILITY).resolve()).ifPresent(hitLiving -> {
                        for (PendingHit value : (Collection)hit.getValue()) {
                            gun.validatePendingHit(player, (LivingExtension<?, ?>)hitLiving, value);
                        }
                    });
                }
            });
        });
        return true;
    }
}

