/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.client.updater;

import com.craftingdead.core.client.updater.VersionComparator;
import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;

public class RemoteVersionFetcher {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String BASE_URL = "https://dl.brad.ac/releases/";
    private static final int TIMEOUT_MS = 10000;
    private static final Pattern JAR_LINK_PATTERN = Pattern.compile("href=\"([^\"]+\\.jar)\"", 2);
    private static final Pattern VERSION_PATTERN = Pattern.compile("([a-z\\-]+)-(\\d+\\.\\d+\\.\\d+)-(\\d+\\.\\d+\\.\\d+\\.\\d+)(?:-[a-z]+)?\\.jar");
    private static final Map<String, String> latestFilenames = new HashMap<String, String>();

    public static String getLatestVersion(String modId) {
        try {
            String url = BASE_URL + modId + "/";
            LOGGER.info("Fetching versions from: {}", (Object)url);
            Map<String, String> versionToFilename = RemoteVersionFetcher.fetchVersionsFromDirectory(url, modId);
            if (versionToFilename.isEmpty()) {
                LOGGER.warn("No versions found for mod: {}", (Object)modId);
                return null;
            }
            String latestVersion = versionToFilename.keySet().iterator().next();
            for (String version : versionToFilename.keySet()) {
                if (!VersionComparator.isNewer(version, latestVersion)) continue;
                latestVersion = version;
            }
            latestFilenames.put(modId, versionToFilename.get(latestVersion));
            LOGGER.info("Latest version for {}: {}", (Object)modId, (Object)latestVersion);
            return latestVersion;
        }
        catch (Exception e) {
            LOGGER.error("Failed to fetch latest version for mod: {}", (Object)modId, (Object)e);
            return null;
        }
    }

    private static Map<String, String> fetchVersionsFromDirectory(String directoryUrl, String modId) {
        HashMap<String, String> versionToFilename = new HashMap<String, String>();
        try {
            String line;
            URL url = new URL(directoryUrl);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setConnectTimeout(10000);
            connection.setReadTimeout(10000);
            connection.setRequestProperty("User-Agent", "CraftingDead-ModUpdater/1.0");
            int responseCode = connection.getResponseCode();
            if (responseCode != 200) {
                LOGGER.error("HTTP error {} when fetching: {}", (Object)responseCode, (Object)directoryUrl);
                return versionToFilename;
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            StringBuilder html = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                html.append(line).append("\n");
            }
            reader.close();
            String htmlContent = html.toString();
            Matcher linkMatcher = JAR_LINK_PATTERN.matcher(htmlContent);
            while (linkMatcher.find()) {
                String jarName = linkMatcher.group(1);
                Matcher versionMatcher = VERSION_PATTERN.matcher(jarName);
                if (!versionMatcher.find()) continue;
                String fileModId = versionMatcher.group(1);
                String mcVersion = versionMatcher.group(2);
                String modVersion = versionMatcher.group(3);
                if (!fileModId.equals(modId) || !mcVersion.equals("1.18.2")) continue;
                versionToFilename.put(modVersion, jarName);
                LOGGER.debug("Found version: {} ({})", (Object)modVersion, (Object)jarName);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error fetching directory listing: {}", (Object)directoryUrl, (Object)e);
        }
        return versionToFilename;
    }

    public static String getDownloadUrl(String modId, String version) {
        String filename = latestFilenames.get(modId);
        if (filename != null) {
            return BASE_URL + modId + "/" + filename;
        }
        return BASE_URL + modId + "/" + modId + "-1.18.2-" + version + ".jar";
    }
}

