/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.client.renderer;

import com.craftingdead.core.client.renderer.FloatSmoother;
import com.craftingdead.core.util.MutableVector2f;
import com.mojang.blaze3d.Blaze3D;
import com.mojang.math.Vector3f;
import java.util.Random;
import net.minecraft.Util;
import net.minecraft.util.Mth;

public class CameraManager {
    private static final Random random = new Random();
    private FloatSmoother lookPitchSmoother = new FloatSmoother(1.0f);
    private FloatSmoother lookYawSmoother = new FloatSmoother(1.0f);
    private float lastLookTime = Float.MIN_VALUE;
    private float largeAmpSlowFade;
    private float smallAmpQuickFade;

    public void randomRecoil(float pitchOffset, boolean modifyLookPosition) {
        this.joltCamera(pitchOffset, pitchOffset * (random.nextBoolean() ? 1.0f : -1.0f) / 2.0f, modifyLookPosition);
    }

    public void joltCamera(float pitchOffset, float yawOffset, boolean moveLookPosition) {
        if (moveLookPosition) {
            this.lookPitchSmoother.add(-pitchOffset);
            this.lookYawSmoother.add(yawOffset);
        }
        this.largeAmpSlowFade += pitchOffset;
        this.smallAmpQuickFade += pitchOffset / 2.0f;
    }

    public void tick() {
        if (this.largeAmpSlowFade > 0.0f) {
            this.largeAmpSlowFade *= 0.7f;
        }
        if (this.smallAmpQuickFade > 0.0f) {
            this.smallAmpQuickFade = (float)((double)this.smallAmpQuickFade * 0.25);
        }
    }

    public void getLookRotationDelta(MutableVector2f result) {
        float currentTime = (float)Blaze3D.m_83640_();
        float timeDelta = currentTime - this.lastLookTime;
        result.set(this.lookPitchSmoother.getAndDecelerate(timeDelta * 2.0f), this.lookYawSmoother.getAndDecelerate(timeDelta * 2.0f));
    }

    public void getCameraRotations(float partialTicks, Vector3f result) {
        float time = (float)Util.m_137550_() / 20.0f;
        float bounce = Mth.m_14031_((float)(time * 0.35f));
        float roll = bounce / 2.0f * this.largeAmpSlowFade;
        result.m_122245_(-this.smallAmpQuickFade, 0.0f, roll);
    }

    public float getFov(float partialTicks) {
        float time = (float)Util.m_137550_() / 20.0f;
        float bounce = Mth.m_14031_((float)(time * 0.5f));
        return bounce / 125.0f * -this.largeAmpSlowFade;
    }
}

