/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.world.item.gun;

import com.craftingdead.core.ServerConfig;
import com.craftingdead.core.event.GunEvent;
import com.craftingdead.core.network.NetworkChannel;
import com.craftingdead.core.network.SynchedData;
import com.craftingdead.core.network.message.play.HitMessage;
import com.craftingdead.core.network.message.play.NPCTriggerPressedMessage;
import com.craftingdead.core.network.message.play.SecondaryActionMessage;
import com.craftingdead.core.network.message.play.SetFireModeMessage;
import com.craftingdead.core.network.message.play.TriggerPressedMessage;
import com.craftingdead.core.sounds.ModSoundEvents;
import com.craftingdead.core.util.RayTraceUtil;
import com.craftingdead.core.world.damagesource.ModDamageSource;
import com.craftingdead.core.world.entity.extension.EntitySnapshot;
import com.craftingdead.core.world.entity.extension.LivingExtension;
import com.craftingdead.core.world.entity.extension.PlayerExtension;
import com.craftingdead.core.world.inventory.GunCraftSlotType;
import com.craftingdead.core.world.item.enchantment.ModEnchantments;
import com.craftingdead.core.world.item.equipment.Equipment;
import com.craftingdead.core.world.item.equipment.Hat;
import com.craftingdead.core.world.item.gun.AbstractGunClient;
import com.craftingdead.core.world.item.gun.FireMode;
import com.craftingdead.core.world.item.gun.Gun;
import com.craftingdead.core.world.item.gun.PendingHit;
import com.craftingdead.core.world.item.gun.ammoprovider.AmmoProvider;
import com.craftingdead.core.world.item.gun.ammoprovider.AmmoProviderType;
import com.craftingdead.core.world.item.gun.ammoprovider.AmmoProviderTypes;
import com.craftingdead.core.world.item.gun.attachment.Attachment;
import com.craftingdead.core.world.item.gun.attachment.Attachments;
import com.craftingdead.core.world.item.gun.magazine.Magazine;
import com.craftingdead.core.world.item.gun.skin.Paint;
import com.craftingdead.core.world.item.gun.skin.Skin;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import java.util.AbstractList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.thread.BlockableEventLoop;
import net.minecraft.world.damagesource.CombatRules;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Vindicator;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.WanderingTrader;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.DigDurabilityEnchantment;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.BellBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.TntBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.common.util.LogicalSidedProvider;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public abstract class AbstractGun
implements Gun,
INBTSerializable<CompoundTag> {
    private static final Logger logger = LogUtils.getLogger();
    public static final byte HIT_VALIDATION_DELAY_TICKS = 3;
    private static final ScheduledExecutorService executorService = Executors.newScheduledThreadPool(3, new ThreadFactoryBuilder().setNameFormat("gun-pool-%s").setDaemon(true).setPriority(10).build());
    private static final EntityDataAccessor<ItemStack> PAINT_STACK = new EntityDataAccessor(1, EntityDataSerializers.f_135033_);
    private final SynchedData dataManager = new SynchedData();
    protected final ItemStack itemStack;
    private boolean wasTriggerPressed;
    private volatile int triggerPressedTicks;
    private volatile FireMode fireMode;
    private final AtomicInteger shotCount = new AtomicInteger();
    private Map<GunCraftSlotType, Attachment> attachments;
    private boolean attachmentsDirty;
    private Iterator<FireMode> fireModeInfiniteIterator;
    private volatile boolean performingSecondaryAction;
    private Lazy<AbstractGunClient<?>> client;
    private volatile long lastTickMs;
    private volatile AmmoProvider ammoProvider;
    private boolean ammoProviderChanged;
    @Nullable
    private volatile Future<?> gunFuture;
    protected volatile long lastShotMs;
    private boolean initialized;
    @Nullable
    private Holder<Skin> skin;
    private boolean skinDirty;

    public AbstractGun(ItemStack itemStack) {
        this.itemStack = itemStack;
        this.dataManager.register(PAINT_STACK, ItemStack.f_41583_);
    }

    protected abstract AbstractGunClient<?> createClient();

    public void checkInitialized() {
        Preconditions.checkState((boolean)this.initialized, (Object)"Gun not initialized.");
    }

    protected void initialize() {
        if (this.initialized) {
            throw new IllegalStateException("Already initialized");
        }
        this.initialized = true;
        GunEvent.Initialize event = new GunEvent.Initialize(this, this.itemStack, this.attachments == null ? Map.of() : this.attachments, this.ammoProvider == null ? this.createAmmoProvider() : this.ammoProvider);
        MinecraftForge.EVENT_BUS.post((Event)event);
        this.setAmmoProvider(event.getAmmoProvider());
        this.attachments = Map.copyOf(event.getAttachments());
        this.fireModeInfiniteIterator = Iterables.cycle((Iterable)Iterables.filter(this.getFireModes(), mode -> mode != FireMode.BURST || (Boolean)ServerConfig.instance.burstfireEnabled.get() != false)).iterator();
        this.fireMode = this.fireModeInfiniteIterator.next();
        this.client = FMLEnvironment.dist.isClient() ? Lazy.concurrentOf(() -> this.createClient()) : Lazy.of(() -> {
            throw new IllegalStateException("Cannot access gun client on server.");
        });
    }

    protected abstract Set<FireMode> getFireModes();

    protected abstract AmmoProvider createAmmoProvider();

    @Override
    public void tick(LivingExtension<?, ?> living) {
        this.lastTickMs = Util.m_137550_();
        if (!living.level().m_5776_() && !this.isTriggerPressed() && this.wasTriggerPressed) {
            this.triggerPressedTicks = living.entity().m_20194_().m_129921_();
        }
        this.wasTriggerPressed = this.isTriggerPressed();
        if (this.isPerformingSecondaryAction() && living.entity().m_20142_()) {
            this.setPerformingSecondaryAction(living, false, true);
        }
        if (living.level().m_5776_()) {
            ((AbstractGunClient)this.getClient()).handleTick(living);
        }
    }

    @Override
    public void reset(LivingExtension<?, ?> living) {
        this.setTriggerPressed(living, false, false);
        if (this.isPerformingSecondaryAction()) {
            this.setPerformingSecondaryAction(living, false, false);
        }
    }

    @Override
    public void setTriggerPressed(LivingExtension<?, ?> living, boolean triggerPressed, boolean sendUpdate) {
        if (triggerPressed == this.isTriggerPressed() || triggerPressed && (!this.canShoot(living) || MinecraftForge.EVENT_BUS.post((Event)new GunEvent.TriggerPressed(this, this.itemStack, living)))) {
            return;
        }
        if (triggerPressed) {
            this.gunFuture = executorService.scheduleAtFixedRate(() -> this.shoot(living), 0L, this.getFireDelayMs(), TimeUnit.MILLISECONDS);
        } else {
            this.stopShooting();
        }
        if (sendUpdate) {
            PacketDistributor.PacketTarget target = living.level().m_5776_() ? PacketDistributor.SERVER.noArg() : PacketDistributor.TRACKING_ENTITY.with(living::entity);
            NetworkChannel.PLAY.getSimpleChannel().send(target, (Object)new TriggerPressedMessage(living.entity().m_142049_(), triggerPressed));
        }
    }

    @Override
    public void setNPCTriggerPressed(LivingExtension<?, ?> living, boolean triggerPressed, boolean sendUpdate, float accuracy) {
        if (triggerPressed == this.isTriggerPressed() || triggerPressed && (!this.canShoot(living) || MinecraftForge.EVENT_BUS.post((Event)new GunEvent.NPCTriggerPressed(this, this.itemStack, living)))) {
            return;
        }
        if (triggerPressed) {
            this.gunFuture = executorService.scheduleAtFixedRate(() -> this.npcShoot(living, accuracy), 0L, this.getFireDelayMs(), TimeUnit.MILLISECONDS);
        } else {
            this.stopShooting();
        }
        if (sendUpdate) {
            PacketDistributor.PacketTarget target = living.level().m_5776_() ? PacketDistributor.SERVER.noArg() : PacketDistributor.TRACKING_ENTITY.with(living::entity);
            NetworkChannel.PLAY.getSimpleChannel().send(target, (Object)new NPCTriggerPressedMessage(living.entity().m_142049_(), triggerPressed));
        }
    }

    @Override
    public boolean isTriggerPressed() {
        return this.gunFuture != null && !this.gunFuture.isDone();
    }

    private void stopShooting() {
        this.shotCount.set(0);
        if (this.gunFuture != null) {
            this.gunFuture.cancel(false);
        }
    }

    @Override
    public void validatePendingHit(PlayerExtension<ServerPlayer> player, LivingExtension<?, ?> hitLiving, PendingHit pendingHit) {
        EntitySnapshot hitSnapshot;
        EntitySnapshot playerSnapshot;
        byte tickOffset = pendingHit.tickOffset();
        if (tickOffset > 3) {
            logger.warn("Bad living hit packet received, tick offset is too big!");
            return;
        }
        int latencyTicks = ((ServerPlayer)player.entity()).f_8943_ / 1000 * 20 + tickOffset;
        int tick = ((ServerPlayer)player.entity()).m_20194_().m_129921_();
        if (tick - latencyTicks > this.triggerPressedTicks && !this.isTriggerPressed()) {
            return;
        }
        try {
            playerSnapshot = player.getSnapshot(tick - latencyTicks).combineUntrustedSnapshot(pendingHit.playerSnapshot());
        }
        catch (IndexOutOfBoundsException e) {
            return;
        }
        try {
            hitSnapshot = hitLiving.getSnapshot(tick - latencyTicks).combineUntrustedSnapshot(pendingHit.hitSnapshot());
        }
        catch (IndexOutOfBoundsException e) {
            return;
        }
        if (hitLiving.entity().m_6084_()) {
            Random random = player.random();
            random.setSeed(pendingHit.randomSeed());
            AbstractGun.rayTrace(player.level(), playerSnapshot, hitSnapshot, this.getRange(), this.getAccuracy(playerSnapshot.velocity(), playerSnapshot.crouching()), pendingHit.shotCount(), random).ifPresent(hitPos -> this.hitEntity((LivingExtension<?, ?>)player, (Entity)hitLiving.entity(), (Vec3)hitPos, false));
        }
    }

    @Override
    public final float getAccuracy(LivingExtension<?, ?> living) {
        return this.getAccuracy(living.getVelocity(), living.isCrouching());
    }

    protected abstract float getAccuracy();

    private float getAccuracy(Vec3 velocity, boolean crouching) {
        float accuracy = this.getAccuracy() * this.getAttachmentMultiplier(Attachment.MultiplierType.ACCURACY);
        accuracy *= 1.0f - (float)velocity.m_82553_();
        if (crouching) {
            accuracy *= 1.1f;
        }
        return Math.min(1.0f, accuracy);
    }

    protected abstract double getRange();

    protected abstract long getFireDelayMs();

    private void shoot(LivingExtension<?, ?> living) {
        int maxShots;
        long time = Util.m_137550_();
        if (!this.isTriggerPressed() || time - this.lastTickMs >= 500L || !this.canShoot(living)) {
            this.stopShooting();
            return;
        }
        if (time - this.lastShotMs + 10L < this.getFireDelayMs()) {
            return;
        }
        this.lastShotMs = time;
        LogicalSide side = living.level().m_5776_() ? LogicalSide.CLIENT : LogicalSide.SERVER;
        BlockableEventLoop executor = (BlockableEventLoop)LogicalSidedProvider.WORKQUEUE.get(side);
        if (this.ammoProvider.getMagazine().map(Magazine::getSize).orElse(0) <= 0) {
            if (side.isServer() || side.isClient()) {
                executor.execute(() -> {
                    living.entity().m_5496_((SoundEvent)ModSoundEvents.DRY_FIRE.get(), 1.0f, 1.0f);
                    this.ammoProvider.reload(living);
                });
            }
            this.stopShooting();
            return;
        }
        int shotCount = this.shotCount.getAndIncrement();
        if (shotCount >= (maxShots = this.fireMode.getMaxShots().orElse(Integer.MAX_VALUE).intValue())) {
            this.stopShooting();
            return;
        }
        executor.execute(() -> this.processShot(living));
        if (side.isClient()) {
            ((AbstractGunClient)this.getClient()).handleShoot(living);
        }
        Thread.yield();
    }

    private void npcShoot(LivingExtension<?, ?> living, float accuracy) {
        int maxShots;
        long time = Util.m_137550_();
        if (!this.isTriggerPressed() || time - this.lastTickMs >= 500L || !this.canShoot(living)) {
            this.stopShooting();
            return;
        }
        if (time - this.lastShotMs + 10L < this.getFireDelayMs()) {
            return;
        }
        this.lastShotMs = time;
        LogicalSide side = living.level().m_5776_() ? LogicalSide.CLIENT : LogicalSide.SERVER;
        BlockableEventLoop executor = (BlockableEventLoop)LogicalSidedProvider.WORKQUEUE.get(side);
        if (this.ammoProvider.getMagazine().map(Magazine::getSize).orElse(0) <= 0) {
            if (side.isServer() || side.isClient()) {
                executor.execute(() -> {
                    living.entity().m_5496_((SoundEvent)ModSoundEvents.DRY_FIRE.get(), 1.0f, 1.0f);
                    this.ammoProvider.reload(living);
                });
            }
            this.stopShooting();
            return;
        }
        int shotCount = this.shotCount.getAndIncrement();
        if (shotCount >= (maxShots = this.fireMode.getMaxShots().orElse(Integer.MAX_VALUE).intValue())) {
            this.stopShooting();
            return;
        }
        executor.execute(() -> this.processNPCShot(living, accuracy));
        if (side.isClient()) {
            ((AbstractGunClient)this.getClient()).handleShoot(living);
        }
        Thread.yield();
    }

    protected boolean canShoot(LivingExtension<?, ?> living) {
        PlayerExtension player;
        return !living.getActionObserver().isPresent() && !living.entity().m_20142_() && !living.entity().m_5833_() && (!(living instanceof PlayerExtension) || !(player = (PlayerExtension)living).isHandcuffed());
    }

    protected abstract int getRoundsPerShot();

    protected void processShot(LivingExtension<?, ?> living) {
        int unbreakingLevel;
        Player player;
        Object obj;
        Object entity = living.entity();
        Level level = living.level();
        Random random = entity.m_21187_();
        MinecraftForge.EVENT_BUS.post((Event)new GunEvent.Shoot(this, this.itemStack, living));
        if (!(level.m_5776_() || (obj = living.entity()) instanceof Player && (player = (Player)obj).m_7500_() || DigDurabilityEnchantment.m_44655_((ItemStack)this.itemStack, (int)(unbreakingLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44986_, (ItemStack)this.itemStack)), (Random)level.m_5822_()))) {
            this.ammoProvider.getExpectedMagazine().decrementSize();
        }
        boolean hitEntity = false;
        HashSet<BlockState> blocksHit = new HashSet<BlockState>();
        block4: for (int i = 0; i < this.getRoundsPerShot(); ++i) {
            long randomSeed = level.m_46467_() + (long)i;
            random.setSeed(randomSeed);
            float partialTick = level.m_5776_() ? ((AbstractGunClient)this.getClient()).getPartialTick() : 1.0f;
            HitResult hitResult = RayTraceUtil.rayTrace(entity, this.getRange(), partialTick, 0.0f, 0.0f).orElse(null);
            if (hitResult == null) continue;
            switch (hitResult.m_6662_()) {
                case BLOCK: {
                    BlockHitResult blockHitResult = (BlockHitResult)hitResult;
                    BlockState blockState = level.m_8055_(blockHitResult.m_82425_());
                    this.hitBlock(living, blockHitResult, blockState, level.m_5776_() && (i == 0 || !blocksHit.contains(blockState)));
                    blocksHit.add(blockState);
                    continue block4;
                }
                case ENTITY: {
                    EntityHitResult entityHitResult = (EntityHitResult)hitResult;
                    if (!entityHitResult.m_82443_().m_6084_() || entityHitResult.m_82443_() instanceof LivingEntity && entity instanceof ServerPlayer) continue block4;
                    if (level.m_5776_()) {
                        ((AbstractGunClient)this.getClient()).handleHitEntityPre(living, entityHitResult.m_82443_(), entityHitResult.m_82450_(), randomSeed);
                    }
                    this.hitEntity(living, entityHitResult.m_82443_(), entityHitResult.m_82450_(), !hitEntity && level.m_5776_());
                    hitEntity = true;
                    continue block4;
                }
            }
        }
    }

    protected void processNPCShot(LivingExtension<?, ?> living, float accuracy) {
        int unbreakingLevel;
        Player player;
        Object obj;
        Object entity = living.entity();
        Level level = living.level();
        Random random = entity.m_21187_();
        MinecraftForge.EVENT_BUS.post((Event)new GunEvent.Shoot(this, this.itemStack, living));
        if (!(level.m_5776_() || (obj = living.entity()) instanceof Player && (player = (Player)obj).m_7500_() || DigDurabilityEnchantment.m_44655_((ItemStack)this.itemStack, (int)(unbreakingLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44986_, (ItemStack)this.itemStack)), (Random)level.m_5822_()))) {
            this.ammoProvider.getExpectedMagazine().decrementSize();
        }
        boolean hitEntity = false;
        HashSet<BlockState> blocksHit = new HashSet<BlockState>();
        block4: for (int i = 0; i < this.getRoundsPerShot(); ++i) {
            boolean shouldHit;
            boolean bl = shouldHit = random.nextFloat() <= accuracy;
            if (!shouldHit) continue;
            long randomSeed = level.m_46467_() + (long)i;
            random.setSeed(randomSeed);
            float partialTick = level.m_5776_() ? ((AbstractGunClient)this.getClient()).getPartialTick() : 1.0f;
            HitResult hitResult = RayTraceUtil.rayTrace(entity, this.getRange(), partialTick, 0.0f, 0.0f).orElse(null);
            if (hitResult == null) continue;
            switch (hitResult.m_6662_()) {
                case BLOCK: {
                    BlockHitResult blockHitResult = (BlockHitResult)hitResult;
                    BlockState blockState = level.m_8055_(blockHitResult.m_82425_());
                    this.hitBlock(living, blockHitResult, blockState, level.m_5776_() && (i == 0 || !blocksHit.contains(blockState)));
                    blocksHit.add(blockState);
                    continue block4;
                }
                case ENTITY: {
                    EntityHitResult entityHitResult = (EntityHitResult)hitResult;
                    if (!entityHitResult.m_82443_().m_6084_() || entityHitResult.m_82443_() instanceof LivingEntity && entity instanceof ServerPlayer) continue block4;
                    if (level.m_5776_()) {
                        ((AbstractGunClient)this.getClient()).handleHitEntityPre(living, entityHitResult.m_82443_(), entityHitResult.m_82450_(), randomSeed);
                    }
                    this.npcHitEntity(living, entityHitResult.m_82443_(), entityHitResult.m_82450_(), !hitEntity && level.m_5776_());
                    hitEntity = true;
                    continue block4;
                }
            }
        }
    }

    protected abstract float getDamage();

    private void hitEntity(LivingExtension<?, ?> living, Entity hitEntity, Vec3 hitPos, boolean playSound) {
        GunEvent.EntityHit event;
        float armorPenetration;
        Object entity = living.entity();
        float damage = this.getDamage();
        if (((Boolean)ServerConfig.instance.damageDropOffEnable.get()).booleanValue()) {
            float distance = hitEntity.m_20270_(living.entity());
            float minDamage = Math.min(damage, ((Double)ServerConfig.instance.damageDropOffMinimumDamage.get()).floatValue());
            damage = Math.max(minDamage, damage - (float)((Double)ServerConfig.instance.damageDropOffLoss.get() / 100.0 * this.getRange() * (double)distance));
        }
        if ((armorPenetration = Math.min((1.0f + (float)EnchantmentHelper.m_44843_((Enchantment)((Enchantment)ModEnchantments.ARMOR_PENETRATION.get()), (ItemStack)this.itemStack) / 255.0f) * this.ammoProvider.getExpectedMagazine().getArmorPenetration(), 1.0f)) > 0.0f && hitEntity instanceof LivingEntity) {
            LivingEntity livingEntityHit = (LivingEntity)hitEntity;
            float reducedDamage = damage - CombatRules.m_19272_((float)damage, (float)livingEntityHit.m_21230_(), (float)((float)livingEntityHit.m_21051_(Attributes.f_22285_).m_22135_()));
            damage += reducedDamage * armorPenetration;
        }
        boolean headshot = false;
        if (hitEntity instanceof LivingEntity) {
            LivingExtension<LivingEntity, ?> hitLiving = LivingExtension.getOrThrow((LivingEntity)hitEntity);
            double chinHeight = hitEntity.m_20186_() + (double)hitEntity.m_20192_() - (double)0.2f;
            boolean bl = headshot = (Boolean)ServerConfig.instance.headshotEnabled.get() != false && (hitEntity instanceof Player || hitEntity instanceof Zombie || hitEntity instanceof Skeleton || hitEntity instanceof Creeper || hitEntity instanceof EnderMan || hitEntity instanceof Witch || hitEntity instanceof Villager || hitEntity instanceof Vindicator || hitEntity instanceof WanderingTrader) && hitPos.f_82480_ >= chinHeight;
            if (headshot) {
                float headshotDamagePercent = 1.0f - hitLiving.getEquipmentInSlot(Equipment.Slot.HAT).filter(Hat.class::isInstance).map(Hat.class::cast).map(Hat::headshotReductionPercentage).orElse(Float.valueOf(0.0f)).floatValue();
                damage = (float)((double)damage * ((double)headshotDamagePercent * (Double)ServerConfig.instance.headshotBonusDamage.get()));
            }
        }
        if (MinecraftForge.EVENT_BUS.post((Event)(event = new GunEvent.EntityHit(this, this.itemStack, living, hitEntity, damage, hitPos, headshot)))) {
            return;
        }
        damage = event.damage();
        headshot = event.headshot();
        if (living.level().m_5776_()) {
            ((AbstractGunClient)this.getClient()).handleHitEntityPost(living, hitEntity, hitPos, playSound, headshot);
            return;
        }
        hitEntity.f_19802_ = 0;
        ModDamageSource.hurtWithoutKnockback(hitEntity, ModDamageSource.gun(entity, headshot), damage);
        AbstractGun.checkCreateExplosion(this.itemStack, entity, hitPos);
        if (EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44990_, (ItemStack)this.itemStack) > 0) {
            hitEntity.m_20254_(100);
        }
        MinecraftForge.EVENT_BUS.post((Event)new GunEvent.EntityDamaged(this, this.itemStack, living, hitEntity, damage, hitPos, headshot));
        if (hitEntity instanceof LivingEntity) {
            LivingEntity hitLivingEntity = (LivingEntity)hitEntity;
            if (entity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entity;
                NetworkChannel.PLAY.getSimpleChannel().send(PacketDistributor.PLAYER.with(() -> player), (Object)new HitMessage(hitPos, hitLivingEntity.m_21224_()));
            }
        }
    }

    private void npcHitEntity(LivingExtension<?, ?> living, Entity hitEntity, Vec3 hitPos, boolean playSound) {
        GunEvent.EntityHit event;
        boolean headshot;
        float armorPenetration;
        Object entity = living.entity();
        float damage = this.getDamage();
        if (((Boolean)ServerConfig.instance.damageDropOffEnable.get()).booleanValue()) {
            float distance = hitEntity.m_20270_(living.entity());
            float minDamage = Math.min(damage, ((Double)ServerConfig.instance.damageDropOffMinimumDamage.get()).floatValue());
            damage = Math.max(minDamage, damage - (float)((Double)ServerConfig.instance.damageDropOffLoss.get() / 100.0 * this.getRange() * (double)distance));
        }
        if ((armorPenetration = Math.min((1.0f + (float)EnchantmentHelper.m_44843_((Enchantment)((Enchantment)ModEnchantments.ARMOR_PENETRATION.get()), (ItemStack)this.itemStack) / 255.0f) * this.ammoProvider.getExpectedMagazine().getArmorPenetration(), 1.0f)) > 0.0f && hitEntity instanceof LivingEntity) {
            LivingEntity livingEntityHit = (LivingEntity)hitEntity;
            float reducedDamage = damage - CombatRules.m_19272_((float)damage, (float)livingEntityHit.m_21230_(), (float)((float)livingEntityHit.m_21051_(Attributes.f_22285_).m_22135_()));
            damage += reducedDamage * armorPenetration;
        }
        boolean bl = headshot = living.random().nextInt(100) < 10;
        if (hitEntity instanceof LivingEntity) {
            LivingExtension<LivingEntity, ?> hitLiving = LivingExtension.getOrThrow((LivingEntity)hitEntity);
            if (headshot) {
                float headshotDamagePercent = 1.0f - hitLiving.getEquipmentInSlot(Equipment.Slot.HAT).filter(Hat.class::isInstance).map(Hat.class::cast).map(Hat::headshotReductionPercentage).orElse(Float.valueOf(0.0f)).floatValue();
                damage *= (float)((double)headshotDamagePercent * (Double)ServerConfig.instance.headshotBonusDamage.get());
            }
        }
        if (MinecraftForge.EVENT_BUS.post((Event)(event = new GunEvent.EntityHit(this, this.itemStack, living, hitEntity, damage, hitPos, headshot)))) {
            return;
        }
        damage = event.damage();
        headshot = event.headshot();
        if (living.level().m_5776_()) {
            ((AbstractGunClient)this.getClient()).handleHitEntityPost(living, hitEntity, hitPos, playSound, headshot);
            return;
        }
        hitEntity.f_19802_ = 0;
        ModDamageSource.hurtWithoutKnockback(hitEntity, ModDamageSource.gun(entity, headshot), damage);
        AbstractGun.checkCreateExplosion(this.itemStack, entity, hitPos);
        if (EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44990_, (ItemStack)this.itemStack) > 0) {
            hitEntity.m_20254_(100);
        }
        MinecraftForge.EVENT_BUS.post((Event)new GunEvent.EntityDamaged(this, this.itemStack, living, hitEntity, damage, hitPos, headshot));
        if (hitEntity instanceof LivingEntity) {
            LivingEntity hitLivingEntity = (LivingEntity)hitEntity;
            if (entity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entity;
                NetworkChannel.PLAY.getSimpleChannel().send(PacketDistributor.PLAYER.with(() -> player), (Object)new HitMessage(hitPos, hitLivingEntity.m_21224_()));
            }
        }
    }

    private void hitBlock(LivingExtension<?, ?> living, BlockHitResult result, BlockState blockState, boolean playSound) {
        Object entity = living.entity();
        Block block = blockState.m_60734_();
        Level level = entity.m_183503_();
        BlockPos blockPos = result.m_82425_();
        GunEvent.BlockHit event = new GunEvent.BlockHit(this, this.itemStack, result, blockState, living, level);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return;
        }
        if (level.m_5776_()) {
            ((AbstractGunClient)this.getClient()).handleHitBlock(living, result, blockState, playSound);
            return;
        }
        if (block instanceof BellBlock) {
            Player player;
            BellBlock bell = (BellBlock)block;
            bell.m_49701_(level, blockState, result, entity instanceof Player ? (player = (Player)entity) : null, playSound);
        }
        if (block instanceof TntBlock) {
            TntBlock tnt = (TntBlock)block;
            tnt.onCaughtFire(blockState, level, blockPos, null, entity);
            level.m_7471_(blockPos, false);
        }
        AbstractGun.checkCreateExplosion(this.itemStack, entity, result.m_82450_());
        if (EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44990_, (ItemStack)this.itemStack) > 0) {
            if (CampfireBlock.m_51321_((BlockState)blockState)) {
                level.m_46597_(blockPos, (BlockState)blockState.m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(true)));
            } else {
                BlockPos directedPos = blockPos.m_142300_(result.m_82434_());
                if (BaseFireBlock.m_49255_((Level)level, (BlockPos)directedPos, (Direction)entity.m_6350_())) {
                    level.m_46597_(directedPos, BaseFireBlock.m_49245_((BlockGetter)level, (BlockPos)directedPos));
                }
            }
        }
    }

    @Override
    public Map<GunCraftSlotType, Attachment> getAttachments() {
        return this.attachments;
    }

    @Override
    public void setAttachments(Map<GunCraftSlotType, Attachment> attachments) {
        this.attachments = Map.copyOf(attachments);
    }

    @Override
    public ItemStack getPaintStack() {
        return this.dataManager.get(PAINT_STACK);
    }

    @Override
    public void setPaintStack(ItemStack paintStack) {
        this.dataManager.set(PAINT_STACK, paintStack);
        this.setSkin((Holder<Skin>)((Holder)paintStack.getCapability(Paint.CAPABILITY).map(Paint::getSkin).orElse(null)));
    }

    @Override
    public Skin getSkin() {
        return this.skin == null ? null : (Skin)this.skin.m_203334_();
    }

    @Override
    public void setSkin(Holder<Skin> skin) {
        this.skin = skin;
        this.skinDirty = true;
    }

    @Override
    public void toggleFireMode(LivingExtension<?, ?> living, boolean sendUpdate) {
        if (this.fireModeInfiniteIterator.hasNext()) {
            this.setFireMode(living, this.fireModeInfiniteIterator.next(), sendUpdate);
        }
    }

    @Override
    public void setFireMode(LivingExtension<?, ?> living, FireMode fireMode, boolean sendUpdate) {
        this.fireMode = fireMode;
        living.entity().m_5496_((SoundEvent)ModSoundEvents.TOGGLE_FIRE_MODE.get(), 1.0f, 1.0f);
        Object obj = living.entity();
        if (obj instanceof Player) {
            Player player = (Player)obj;
            player.m_5661_((Component)new TranslatableComponent("message.switch_fire_mode", new Object[]{new TranslatableComponent(this.fireMode.getTranslationKey())}), true);
        }
        if (sendUpdate) {
            PacketDistributor.PacketTarget target = living.level().m_5776_() ? PacketDistributor.SERVER.noArg() : PacketDistributor.TRACKING_ENTITY.with(living::entity);
            NetworkChannel.PLAY.getSimpleChannel().send(target, (Object)new SetFireModeMessage(living.entity().m_142049_(), this.fireMode));
        }
    }

    @Override
    public boolean isPerformingSecondaryAction() {
        return this.performingSecondaryAction;
    }

    protected boolean canPerformSecondaryAction(LivingExtension<?, ?> living) {
        PlayerExtension player;
        return !living.entity().m_20142_() && (!(living instanceof PlayerExtension) || !(player = (PlayerExtension)living).isHandcuffed());
    }

    @Override
    public void setPerformingSecondaryAction(LivingExtension<?, ?> living, boolean performingAction, boolean sendUpdate) {
        if (performingAction == this.performingSecondaryAction || performingAction && !this.canPerformSecondaryAction(living)) {
            return;
        }
        this.performingSecondaryAction = performingAction;
        if (living.level().m_5776_()) {
            ((AbstractGunClient)this.getClient()).handleToggleSecondaryAction(living);
        }
        if (sendUpdate) {
            PacketDistributor.PacketTarget target = living.level().m_5776_() ? PacketDistributor.SERVER.noArg() : PacketDistributor.TRACKING_ENTITY.with(living::entity);
            NetworkChannel.PLAY.getSimpleChannel().send(target, (Object)new SecondaryActionMessage(living.entity().m_142049_(), this.isPerformingSecondaryAction()));
        }
    }

    protected int getShotCount() {
        return this.shotCount.get();
    }

    @Override
    public FireMode getFireMode() {
        return this.fireMode;
    }

    @Override
    public AbstractGunClient<?> getClient() {
        return (AbstractGunClient)this.client.get();
    }

    @Override
    public AmmoProvider getAmmoProvider() {
        return this.ammoProvider;
    }

    @Override
    public void setAmmoProvider(AmmoProvider ammoProvider) {
        this.ammoProvider = ammoProvider;
        this.ammoProviderChanged = true;
    }

    @Override
    public ItemStack getItemStack() {
        return this.itemStack;
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        if (!this.initialized) {
            return tag;
        }
        tag.m_128359_("ammoProviderType", this.ammoProvider.getType().getRegistryName().toString());
        tag.m_128365_("ammoProvider", this.ammoProvider.serializeNBT());
        ListTag attachmentsTag = this.attachments.values().stream().map(ForgeRegistryEntry::getRegistryName).map(ResourceLocation::toString).map(StringTag::m_129297_).collect(ListTag::new, AbstractList::add, List::addAll);
        tag.m_128365_("attachments", (Tag)attachmentsTag);
        tag.m_128365_("paintStack", (Tag)this.getPaintStack().serializeNBT());
        if (this.skin != null) {
            tag.m_128365_("skin", (Tag)Skin.CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, this.skin).getOrThrow(false, arg_0 -> ((Logger)logger).error(arg_0)));
        }
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        if (tag.m_128425_("ammoProviderType", 8)) {
            this.setAmmoProvider(((AmmoProviderType)AmmoProviderTypes.registry.get().getValue(new ResourceLocation(tag.m_128461_("ammoProviderType")))).create());
            this.ammoProvider.deserializeNBT((Tag)tag.m_128469_("ammoProvider"));
            this.ammoProviderChanged = true;
        }
        this.setAttachments(tag.m_128437_("attachments", 8).stream().map(Tag::m_7916_).map(ResourceLocation::new).map(arg_0 -> Attachments.registry.get().getValue(arg_0)).collect(Collectors.toMap(Attachment::getInventorySlot, v -> v)));
        this.setPaintStack(ItemStack.m_41712_((CompoundTag)tag.m_128469_("paintStack")));
        this.skin = Skin.CODEC.parse((DynamicOps)NbtOps.f_128958_, (Object)tag.m_128423_("skin")).result().orElse(null);
    }

    @Override
    public void encode(FriendlyByteBuf out, boolean writeAll) {
        SynchedData.pack(writeAll ? this.dataManager.getAll() : this.dataManager.packDirty(), out);
        if (writeAll || this.attachmentsDirty) {
            out.m_130130_(this.attachments.size());
            this.attachments.values().forEach(arg_0 -> ((FriendlyByteBuf)out).writeRegistryId(arg_0));
        } else {
            out.m_130130_(-1);
        }
        this.attachmentsDirty = false;
        if (this.ammoProviderChanged || writeAll) {
            out.writeBoolean(true);
            out.writeRegistryId((IForgeRegistryEntry)this.ammoProvider.getType());
        } else {
            out.writeBoolean(false);
        }
        this.ammoProvider.encode(out, this.ammoProviderChanged || writeAll);
        this.ammoProviderChanged = false;
        if (this.skinDirty || writeAll) {
            this.skinDirty = false;
            out.writeBoolean(true);
            if (this.skin == null) {
                out.writeBoolean(true);
            } else {
                out.writeBoolean(false);
                out.m_130059_(Skin.CODEC, this.skin);
            }
        } else {
            out.writeBoolean(false);
        }
    }

    @Override
    public void decode(FriendlyByteBuf in) {
        this.dataManager.assignValues(SynchedData.unpack(in));
        int size = in.m_130242_();
        if (size > -1) {
            ImmutableMap.Builder builder = ImmutableMap.builderWithExpectedSize((int)size);
            for (int i = 0; i < size; ++i) {
                Attachment attachment = (Attachment)in.readRegistryIdSafe(Attachment.class);
                builder.put((Object)attachment.getInventorySlot(), (Object)attachment);
            }
            this.attachments = builder.build();
        }
        if (in.readBoolean()) {
            this.ammoProvider = ((AmmoProviderType)in.readRegistryIdSafe(AmmoProviderType.class)).create();
        }
        this.ammoProvider.decode(in);
        if (in.readBoolean()) {
            this.skin = in.readBoolean() ? null : (Holder)in.m_130057_(Skin.CODEC);
        }
    }

    @Override
    public boolean requiresSync() {
        return this.attachmentsDirty || this.dataManager.isDirty() || this.ammoProvider.requiresSync() || this.skinDirty;
    }

    private static void checkCreateExplosion(ItemStack magazineStack, Entity entity, Vec3 position) {
        float explosionSize = (float)EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44988_, (ItemStack)magazineStack) / (float)Enchantments.f_44988_.m_6586_();
        if (explosionSize > 0.0f) {
            entity.m_183503_().m_46511_(entity, position.m_7096_(), position.m_7098_(), position.m_7094_(), explosionSize, Explosion.BlockInteraction.NONE);
        }
    }

    public static Optional<Vec3> rayTrace(Level level, EntitySnapshot fromSnapshot, EntitySnapshot targetSnapshot, double distance, float accuracy, int shotCount, Random random) {
        if (!fromSnapshot.complete() || !targetSnapshot.complete()) {
            return Optional.empty();
        }
        Vec3 startPos = fromSnapshot.position().m_82520_(0.0, (double)fromSnapshot.eyeHeight(), 0.0);
        Vec3 look = RayTraceUtil.calculateViewVector(fromSnapshot.rotation().f_82470_, fromSnapshot.rotation().f_82471_);
        Optional<BlockHitResult> blockRayTraceResult = RayTraceUtil.rayTraceBlocks(startPos, distance, look, level);
        Vec3 scaledLook = look.m_82490_(distance);
        Vec3 endPos = blockRayTraceResult.map(HitResult::m_82450_).orElse(startPos.m_82549_(scaledLook));
        Optional potentialHit = targetSnapshot.boundingBox().m_82371_(startPos, endPos);
        if (targetSnapshot.boundingBox().m_82390_(startPos)) {
            return Optional.of(potentialHit.orElse(startPos));
        }
        return potentialHit;
    }
}

