/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.world.item;

import com.craftingdead.core.world.action.Action;
import com.craftingdead.core.world.action.item.ItemActionType;
import com.craftingdead.core.world.entity.extension.LivingExtension;
import com.craftingdead.core.world.entity.extension.PlayerExtension;
import java.util.function.Supplier;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class ActionItem
extends Item {
    private final Supplier<? extends ItemActionType<?>> itemActionType;

    public ActionItem(Supplier<? extends ItemActionType<?>> itemActionType, Item.Properties properties) {
        super(properties);
        this.itemActionType = itemActionType;
    }

    public ItemActionType<?> getActionType() {
        return this.itemActionType.get();
    }

    public InteractionResult m_6225_(UseOnContext context) {
        if (!context.m_43725_().m_5776_()) {
            PlayerExtension<Player> performer = PlayerExtension.getOrThrow(context.m_43723_());
            if (this.getActionType().createBlockAction(performer, context).map(action -> performer.performAction((Action)action, true)).orElse(false).booleanValue()) {
                return InteractionResult.CONSUME;
            }
        }
        return InteractionResult.PASS;
    }

    public InteractionResult m_6880_(ItemStack itemStack, Player player, LivingEntity targetEntity, InteractionHand hand) {
        if (!player.m_183503_().m_5776_()) {
            PlayerExtension<Player> performer = PlayerExtension.getOrThrow(player);
            LivingExtension<LivingEntity, ?> target = LivingExtension.getOrThrow(targetEntity);
            if (this.getActionType().createEntityAction(performer, target, hand).map(action -> performer.performAction((Action)action, true)).orElse(false).booleanValue()) {
                return InteractionResult.CONSUME;
            }
        }
        return InteractionResult.PASS;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        if (!player.m_183503_().m_5776_()) {
            PlayerExtension<Player> performer = PlayerExtension.getOrThrow(player);
            BlockHitResult hitResult = ActionItem.m_41435_((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.ANY);
            if (hitResult.m_6662_() == HitResult.Type.BLOCK && this.getActionType().createBlockAction(performer, new UseOnContext(player, hand, hitResult)).map(action -> performer.performAction((Action)action, true)).orElse(false).booleanValue()) {
                return InteractionResultHolder.m_19096_((Object)player.m_21120_(hand));
            }
            if (this.getActionType().createAction(performer, hand).map(action -> performer.performAction((Action)action, true)).orElse(false).booleanValue()) {
                return InteractionResultHolder.m_19096_((Object)player.m_21120_(hand));
            }
        }
        return InteractionResultHolder.m_19098_((Object)player.m_21120_(hand));
    }

    public int m_8105_(ItemStack itemStack) {
        return this.getActionType().getDurationTicks();
    }
}

