/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.world.action.reload;

import com.craftingdead.core.ServerConfig;
import com.craftingdead.core.event.CollectMagazineItemHandlers;
import com.craftingdead.core.world.action.ActionType;
import com.craftingdead.core.world.action.ActionTypes;
import com.craftingdead.core.world.action.reload.AbstractReloadAction;
import com.craftingdead.core.world.entity.extension.LivingExtension;
import com.craftingdead.core.world.item.equipment.Equipment;
import com.craftingdead.core.world.item.gun.ammoprovider.AmmoProvider;
import com.craftingdead.core.world.item.gun.ammoprovider.MagazineAmmoProvider;
import com.craftingdead.core.world.item.gun.magazine.Magazine;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class MagazineReloadAction
extends AbstractReloadAction {
    private final MagazineAmmoProvider ammoProvider;
    private ItemStack newMagazineStack;
    private MagazineLocation magazineLocation;

    public MagazineReloadAction(LivingExtension<?, ?> performer) {
        super(performer);
        AmmoProvider ammoProvider = this.gun.getAmmoProvider();
        if (!(ammoProvider instanceof MagazineAmmoProvider)) {
            throw new IllegalStateException("No MagazineAmmoProvider present");
        }
        this.ammoProvider = (MagazineAmmoProvider)ammoProvider;
    }

    @Override
    public ActionType<?> type() {
        return (ActionType)ActionTypes.MAGAZINE_RELOAD.get();
    }

    @Override
    public boolean start(boolean simulate) {
        Optional<MagazineLocation> result = this.findMagazine(this.performer());
        if (this.performer.entity().m_20142_() || result.isEmpty()) {
            return false;
        }
        if (!simulate) {
            this.magazineLocation = result.get();
            this.newMagazineStack = this.magazineLocation.itemHandler.extractItem(this.magazineLocation.slot, 1, false);
        }
        return super.start(simulate);
    }

    @Override
    protected void loadNewMagazineStack(boolean displayOnly) {
        this.ammoProvider.setMagazineStack(this.newMagazineStack);
        if (!(displayOnly || this.oldMagazineStack.m_41619_() || !(this.performer().entity() instanceof Player) || this.oldMagazineStack.getCapability(Magazine.CAPABILITY).map(Magazine::isEmpty).orElse(true).booleanValue() && ((Boolean)ServerConfig.instance.reloadDestroyMagWhenEmpty.get()).booleanValue())) {
            ((Player)this.performer().entity()).m_36356_(this.oldMagazineStack);
        }
    }

    @Override
    protected void revert() {
        this.ammoProvider.setMagazineStack(this.oldMagazineStack);
        ItemStack remainingStack = this.magazineLocation.itemHandler().insertItem(this.magazineLocation.slot(), this.newMagazineStack, false);
        this.performer().entity().m_19983_(remainingStack);
    }

    private List<IItemHandler> collectItemHandlers(LivingExtension<?, ?> living) {
        ImmutableList.Builder builder = ImmutableList.builder();
        CollectMagazineItemHandlers event = new CollectMagazineItemHandlers(living);
        MinecraftForge.EVENT_BUS.post((Event)event);
        builder.addAll(event.getItemHandlers());
        living.getItemInSlot(Equipment.Slot.VEST).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        living.getItemInSlot(Equipment.Slot.BACKPACK).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        living.entity().getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        Object obj = living.entity();
        if (obj instanceof Player) {
            Player player = (Player)obj;
            if (player.m_150110_().f_35937_) {
                ItemStack defaultMagazine = this.gun.getDefaultMagazineStack();
                builder.add((Object)new InvWrapper((Container)new SimpleContainer(new ItemStack[]{defaultMagazine})));
            }
        }
        return builder.build();
    }

    private Optional<MagazineLocation> findMagazine(LivingExtension<?, ?> living) {
        for (IItemHandler itemHandler : this.collectItemHandlers(living)) {
            for (int i = 0; i < itemHandler.getSlots(); ++i) {
                ItemStack itemStack = itemHandler.getStackInSlot(i);
                if (!this.gun.getAcceptedMagazines().contains(itemStack.m_41720_()) || itemStack.getCapability(Magazine.CAPABILITY).map(Magazine::isEmpty).orElse(true).booleanValue()) continue;
                return Optional.of(new MagazineLocation(itemHandler, i));
            }
        }
        return Optional.empty();
    }

    private record MagazineLocation(IItemHandler itemHandler, int slot) {
    }
}

