/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.server.updater;

import com.craftingdead.core.client.updater.JarManager;
import com.craftingdead.core.client.updater.RemoteVersionFetcher;
import com.craftingdead.core.client.updater.VersionComparator;
import com.craftingdead.core.server.updater.ServerRestartHandler;
import com.mojang.logging.LogUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import org.slf4j.Logger;

public class ServerUpdateEventHandler {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String BASE_URL = "https://dl.brad.ac/releases/";
    private static final List<String> MONITORED_MODS = Arrays.asList("crafting-dead-core", "crafting-dead-decoration", "crafting-dead-immerse", "crafting-dead-survival", "rocket-connector");
    private static boolean updateCheckCompleted = false;

    @SubscribeEvent
    public void onCommonSetup(FMLCommonSetupEvent event) {
        if (updateCheckCompleted) {
            return;
        }
        updateCheckCompleted = true;
        event.enqueueWork(() -> {
            LOGGER.info("====================================");
            LOGGER.info("=== Server Auto-Updater Starting ===");
            LOGGER.info("====================================");
            LOGGER.info("CDN: https://dl.brad.ac/releases/");
            LOGGER.info("Checking {} mods for updates...", (Object)MONITORED_MODS.size());
            Path modsDir = Paths.get("mods", new String[0]).toAbsolutePath();
            if (!Files.exists(modsDir, new LinkOption[0])) {
                LOGGER.warn("Mods directory does not exist: {}", (Object)modsDir);
                return;
            }
            int updatesApplied = this.checkAndApplyUpdates(modsDir);
            if (updatesApplied > 0) {
                LOGGER.info("=== Updates Applied: {} mod(s) updated ===", (Object)updatesApplied);
                this.writeRestartFlag(modsDir.getParent());
                if (ServerRestartHandler.canAutoRestart()) {
                    LOGGER.info("Auto-restart is available. Server will restart after initialization.");
                    ServerRestartHandler.triggerRestartDelayed(10);
                } else {
                    ServerRestartHandler.printManualRestartInstructions();
                }
            } else {
                LOGGER.info("====================================");
                LOGGER.info("All {} mods are up to date", (Object)MONITORED_MODS.size());
                LOGGER.info("Running latest versions from CDN");
                LOGGER.info("====================================");
            }
        });
    }

    private int checkAndApplyUpdates(Path modsDir) {
        int updatesApplied = 0;
        for (String modId : MONITORED_MODS) {
            try {
                if (!this.checkAndUpdateMod(modId, modsDir)) continue;
                ++updatesApplied;
            }
            catch (Exception e) {
                LOGGER.error("Failed to update mod: {}", (Object)modId, (Object)e);
            }
        }
        return updatesApplied;
    }

    private boolean checkAndUpdateMod(String modId, Path modsDir) throws IOException {
        LOGGER.info("Checking {}", (Object)modId);
        String localVersion = this.findLocalVersion(modId, modsDir);
        if (localVersion == null) {
            LOGGER.info("  \u2192 Not installed locally");
            return false;
        }
        LOGGER.info("  \u2192 Local version: {}", (Object)localVersion);
        String remoteVersion = RemoteVersionFetcher.getLatestVersion(modId);
        if (remoteVersion == null) {
            LOGGER.warn("Could not fetch remote version for: {}", (Object)modId);
            return false;
        }
        LOGGER.info("  \u2192 Remote version: {}", (Object)remoteVersion);
        int comparison = VersionComparator.compare(remoteVersion, localVersion);
        if (comparison > 0) {
            LOGGER.info("  \u2192 \u2713 Update available: {} -> {}", (Object)localVersion, (Object)remoteVersion);
            return this.downloadAndInstallUpdate(modId, remoteVersion, modsDir);
        }
        LOGGER.info("  \u2192 \u2713 Up to date");
        return false;
    }

    private String findLocalVersion(String modId, Path modsDir) {
        File[] files = modsDir.toFile().listFiles();
        if (files == null) {
            return null;
        }
        for (File file : files) {
            String name;
            String[] parts;
            if (!file.getName().startsWith(modId + "-") || !file.getName().endsWith(".jar") || (parts = (name = file.getName()).replace(".jar", "").split("-")).length < 3) continue;
            return parts[parts.length - 1];
        }
        return null;
    }

    private boolean downloadAndInstallUpdate(String modId, String version, Path modsDir) {
        try {
            String downloadUrl = RemoteVersionFetcher.getDownloadUrl(modId, version);
            if (downloadUrl == null) {
                LOGGER.error("Could not get download URL for: {}", (Object)modId);
                return false;
            }
            LOGGER.info("Downloading update: {}", (Object)downloadUrl);
            String filename = downloadUrl.substring(downloadUrl.lastIndexOf(47) + 1);
            Path tempFile = modsDir.resolve(filename + ".tmp");
            if (!this.downloadFile(downloadUrl, tempFile)) {
                LOGGER.error("Download failed for: {}", (Object)modId);
                return false;
            }
            int deleted = JarManager.deleteOldVersions(modId, modsDir);
            LOGGER.info("Deleted {} old version(s) of {}", (Object)deleted, (Object)modId);
            Path finalFile = modsDir.resolve(filename);
            Files.move(tempFile, finalFile, new CopyOption[0]);
            LOGGER.info("Installed update: {}", (Object)filename);
            return true;
        }
        catch (Exception e) {
            LOGGER.error("Failed to install update for: {}", (Object)modId, (Object)e);
            return false;
        }
    }

    private boolean downloadFile(String urlString, Path destination) {
        try {
            URL url = new URL(urlString);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setConnectTimeout(10000);
            connection.setReadTimeout(30000);
            connection.setRequestProperty("User-Agent", "CraftingDead-ServerUpdater/1.0");
            int responseCode = connection.getResponseCode();
            if (responseCode != 200) {
                LOGGER.error("HTTP error {}: {}", (Object)responseCode, (Object)urlString);
                return false;
            }
            try (BufferedInputStream in = new BufferedInputStream(connection.getInputStream());
                 BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(destination.toFile()));){
                int bytesRead;
                byte[] buffer = new byte[8192];
                while ((bytesRead = in.read(buffer)) != -1) {
                    out.write(buffer, 0, bytesRead);
                }
            }
            return true;
        }
        catch (IOException e) {
            LOGGER.error("Download failed: {}", (Object)urlString, (Object)e);
            return false;
        }
    }

    private void writeRestartFlag(Path serverDir) {
        try {
            Path flagFile = serverDir.resolve("restart_required.flag");
            Files.write(flagFile, "Server restart required after mod updates".getBytes(), new OpenOption[0]);
            LOGGER.info("Restart flag written: {}", (Object)flagFile);
        }
        catch (IOException e) {
            LOGGER.error("Failed to write restart flag", (Throwable)e);
        }
    }
}

