/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.world.item;

import com.craftingdead.core.ServerConfig;
import com.craftingdead.core.capability.CapabilityUtil;
import com.craftingdead.core.world.action.Action;
import com.craftingdead.core.world.action.item.ItemActionType;
import com.craftingdead.core.world.entity.extension.LivingExtension;
import com.craftingdead.core.world.entity.extension.PlayerExtension;
import com.craftingdead.core.world.item.EquipmentItem;
import com.craftingdead.core.world.item.equipment.ClothingProtection;
import com.craftingdead.core.world.item.equipment.Equipment;
import com.craftingdead.core.world.item.equipment.SimpleClothing;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClothingItem
extends EquipmentItem {
    public static final UUID ARMOR_MODIFIER_ID = UUID.fromString("4117e432-16f5-4eea-a4fe-127b54d39af1");
    private final Multimap<Attribute, AttributeModifier> attributeModifiers;
    private final boolean fireImmunity;
    private final boolean enhancesSwimming;
    private final Supplier<? extends ItemActionType<?>> itemActionType;
    private final ClothingType clothingType;

    public ClothingItem(Properties properties, Supplier<? extends ItemActionType<?>> itemActionType, ClothingType clothingType) {
        super(properties);
        this.attributeModifiers = properties.attributeModifiers.build();
        this.fireImmunity = properties.fireImmunity;
        this.enhancesSwimming = properties.enhancesSwimming;
        this.itemActionType = itemActionType;
        this.clothingType = clothingType;
    }

    public ItemActionType<?> getActionType() {
        return this.itemActionType.get();
    }

    public ClothingType getClothingType() {
        return this.clothingType;
    }

    @Override
    public void m_7373_(ItemStack stack, Level world, List<Component> lines, TooltipFlag tooltipFlag) {
        float bulletProtection;
        float bleedReductionPct;
        super.m_7373_(stack, world, lines, tooltipFlag);
        switch (this.clothingType) {
            case CASUAL: {
                lines.add((Component)new TranslatableComponent("clothing.protection.level").m_130940_(ChatFormatting.GRAY).m_130946_(" ").m_7220_((Component)new TranslatableComponent("clothing.casual").m_130940_(ChatFormatting.WHITE)));
                break;
            }
            case UTILITY: {
                lines.add((Component)new TranslatableComponent("clothing.protection.level").m_130940_(ChatFormatting.GRAY).m_130946_(" ").m_7220_((Component)new TranslatableComponent("clothing.utility").m_130940_(ChatFormatting.GREEN)));
                break;
            }
            case MILITARY: {
                lines.add((Component)new TranslatableComponent("clothing.protection.level").m_130940_(ChatFormatting.GRAY).m_130946_(" ").m_7220_((Component)new TranslatableComponent("clothing.military").m_130940_(ChatFormatting.AQUA)));
                break;
            }
            case HEAVY: {
                lines.add((Component)new TranslatableComponent("clothing.protection.level").m_130940_(ChatFormatting.GRAY).m_130946_(" ").m_7220_((Component)new TranslatableComponent("clothing.heavy").m_130940_(ChatFormatting.GOLD)));
            }
        }
        if (this.fireImmunity) {
            lines.add((Component)new TextComponent("\u203b ").m_130940_(ChatFormatting.GOLD).m_7220_((Component)new TranslatableComponent("clothing.immune_to_fire").m_130940_(ChatFormatting.GOLD)));
        }
        lines.add(TextComponent.f_131282_);
        lines.add((Component)new TranslatableComponent("clothing.protection.stats").m_130944_(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.BOLD}));
        float biteProtection = ClothingProtection.getBiteProtection(stack);
        float stabResistance = ClothingProtection.getStabResistance(stack);
        float bluntResistance = ClothingProtection.getBluntResistance(stack);
        float weightModifier = ClothingProtection.getWeightModifier(stack);
        float damageReductionPct = switch (this.clothingType) {
            default -> throw new IncompatibleClassChangeError();
            case ClothingType.CASUAL -> ((Double)ServerConfig.instance.casualClothingDamageReduction.get()).floatValue() * 100.0f;
            case ClothingType.UTILITY -> ((Double)ServerConfig.instance.utilityClothingDamageReduction.get()).floatValue() * 100.0f;
            case ClothingType.MILITARY -> ((Double)ServerConfig.instance.militaryClothingDamageReduction.get()).floatValue() * 100.0f;
            case ClothingType.HEAVY -> ((Double)ServerConfig.instance.militaryClothingDamageReduction.get()).floatValue() * 100.0f;
        };
        switch (this.clothingType) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case CASUAL: {
                float f = ((Double)ServerConfig.instance.casualClothingBleedAndInfectionReduction.get()).floatValue() * 100.0f;
                break;
            }
            case UTILITY: {
                float f = ((Double)ServerConfig.instance.utilityClothingBleedAndInfectionReduction.get()).floatValue() * 100.0f;
                break;
            }
            case MILITARY: {
                float f = ((Double)ServerConfig.instance.militaryClothingBleedAndInfectionReduction.get()).floatValue() * 100.0f;
                break;
            }
            case HEAVY: {
                float f = bleedReductionPct = ((Double)ServerConfig.instance.militaryClothingBleedAndInfectionReduction.get()).floatValue() * 100.0f;
            }
        }
        if (!ClothingProtection.hasProtectionAttributes(stack)) {
            biteProtection = switch (this.clothingType) {
                default -> throw new IncompatibleClassChangeError();
                case ClothingType.CASUAL -> ((Double)ServerConfig.instance.casualClothingBiteProtection.get()).floatValue();
                case ClothingType.UTILITY -> ((Double)ServerConfig.instance.utilityClothingBiteProtection.get()).floatValue();
                case ClothingType.MILITARY -> ((Double)ServerConfig.instance.militaryClothingBiteProtection.get()).floatValue();
                case ClothingType.HEAVY -> ((Double)ServerConfig.instance.heavyClothingBiteProtection.get()).floatValue();
            };
            stabResistance = switch (this.clothingType) {
                default -> throw new IncompatibleClassChangeError();
                case ClothingType.CASUAL -> ((Double)ServerConfig.instance.casualClothingStabResistance.get()).floatValue();
                case ClothingType.UTILITY -> ((Double)ServerConfig.instance.utilityClothingStabResistance.get()).floatValue();
                case ClothingType.MILITARY -> ((Double)ServerConfig.instance.militaryClothingStabResistance.get()).floatValue();
                case ClothingType.HEAVY -> ((Double)ServerConfig.instance.heavyClothingStabResistance.get()).floatValue();
            };
            bluntResistance = switch (this.clothingType) {
                default -> throw new IncompatibleClassChangeError();
                case ClothingType.CASUAL -> ((Double)ServerConfig.instance.casualClothingBluntResistance.get()).floatValue();
                case ClothingType.UTILITY -> ((Double)ServerConfig.instance.utilityClothingBluntResistance.get()).floatValue();
                case ClothingType.MILITARY -> ((Double)ServerConfig.instance.militaryClothingBluntResistance.get()).floatValue();
                case ClothingType.HEAVY -> ((Double)ServerConfig.instance.heavyClothingBluntResistance.get()).floatValue();
            };
            switch (this.clothingType) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case CASUAL: {
                    float f = ((Double)ServerConfig.instance.casualClothingWeightModifier.get()).floatValue();
                    break;
                }
                case UTILITY: {
                    float f = ((Double)ServerConfig.instance.utilityClothingWeightModifier.get()).floatValue();
                    break;
                }
                case MILITARY: {
                    float f = ((Double)ServerConfig.instance.militaryClothingWeightModifier.get()).floatValue();
                    break;
                }
                case HEAVY: {
                    float f = weightModifier = ((Double)ServerConfig.instance.heavyClothingWeightModifier.get()).floatValue();
                }
            }
        }
        if (damageReductionPct > 0.0f) {
            MutableComponent damageText = new TextComponent(String.format(Locale.ROOT, "%.0f%%", Float.valueOf(damageReductionPct))).m_130940_(ChatFormatting.GREEN);
            lines.add((Component)new TextComponent("\u25a0 ").m_130940_(ChatFormatting.DARK_GRAY).m_7220_((Component)new TranslatableComponent("clothing.protection.general_damage").m_130940_(ChatFormatting.GRAY)).m_130946_(": ").m_7220_((Component)damageText));
        }
        if (biteProtection > 0.0f) {
            MutableComponent biteText = new TextComponent(String.format(Locale.ROOT, "%.0f%%", Float.valueOf(biteProtection * 100.0f))).m_130940_(ChatFormatting.GREEN);
            lines.add((Component)new TextComponent("\u2620 ").m_130940_(ChatFormatting.DARK_GRAY).m_7220_((Component)new TranslatableComponent("clothing.protection.bite").m_130940_(ChatFormatting.GRAY)).m_130946_(": ").m_7220_((Component)biteText));
        }
        if (stabResistance > 0.0f) {
            MutableComponent stabText = new TextComponent(String.format(Locale.ROOT, "%.0f%%", Float.valueOf(stabResistance * 100.0f))).m_130940_(ChatFormatting.GREEN);
            lines.add((Component)new TextComponent("\u2020 ").m_130940_(ChatFormatting.DARK_GRAY).m_7220_((Component)new TranslatableComponent("clothing.protection.stab").m_130940_(ChatFormatting.GRAY)).m_130946_(": ").m_7220_((Component)stabText));
        }
        if (bluntResistance > 0.0f) {
            MutableComponent bluntText = new TextComponent(String.format(Locale.ROOT, "%.0f%%", Float.valueOf(bluntResistance * 100.0f))).m_130940_(ChatFormatting.GREEN);
            lines.add((Component)new TextComponent("\u25c6 ").m_130940_(ChatFormatting.DARK_GRAY).m_7220_((Component)new TranslatableComponent("clothing.protection.blunt").m_130940_(ChatFormatting.GRAY)).m_130946_(": ").m_7220_((Component)bluntText));
        }
        if ((bulletProtection = Math.max(biteProtection, stabResistance) * 0.1f) > 0.001f) {
            MutableComponent bulletText = new TextComponent(String.format(Locale.ROOT, "%.0f%%", Float.valueOf(bulletProtection * 100.0f))).m_130940_(ChatFormatting.DARK_GREEN);
            lines.add((Component)new TextComponent("\u2716 ").m_130940_(ChatFormatting.DARK_GRAY).m_7220_((Component)new TranslatableComponent("clothing.protection.bullet").m_130940_(ChatFormatting.GRAY)).m_130946_(": ").m_7220_((Component)bulletText));
        }
        if (bleedReductionPct > 0.0f) {
            MutableComponent infectionText = new TextComponent(String.format(Locale.ROOT, "%.0f%%", Float.valueOf(bleedReductionPct))).m_130940_(ChatFormatting.GREEN);
            lines.add((Component)new TextComponent("\u2726 ").m_130940_(ChatFormatting.DARK_GRAY).m_7220_((Component)new TranslatableComponent("clothing.protection.infection").m_130940_(ChatFormatting.GRAY)).m_130946_(": ").m_7220_((Component)infectionText));
        }
        if (Math.abs(weightModifier) > 0.001f) {
            ChatFormatting weightColor = weightModifier < 0.0f ? ChatFormatting.RED : ChatFormatting.GREEN;
            MutableComponent weightText = new TextComponent(String.format(Locale.ROOT, "%+.0f%%", Float.valueOf(weightModifier * 100.0f))).m_130940_(weightColor);
            lines.add((Component)new TextComponent("\u00bb ").m_130940_(ChatFormatting.DARK_GRAY).m_7220_((Component)new TranslatableComponent("clothing.protection.weight").m_130940_(ChatFormatting.GRAY)).m_130946_(": ").m_7220_((Component)weightText));
        }
    }

    public ICapabilityProvider initCapabilities(ItemStack itemStack, @Nullable CompoundTag nbt) {
        return CapabilityUtil.provider(() -> new SimpleClothing(this.attributeModifiers, this.fireImmunity, this.enhancesSwimming, new ResourceLocation(Objects.requireNonNull(this.getRegistryName()).m_135827_(), "textures/clothing/" + this.getRegistryName().m_135815_() + "_default.png")), Equipment.CAPABILITY);
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext context) {
        if (!context.m_43725_().m_5776_()) {
            PlayerExtension<Player> performer = PlayerExtension.getOrThrow(context.m_43723_());
            if (this.getActionType().createBlockAction(performer, context).map(action -> performer.performAction((Action)action, true)).orElse(false).booleanValue()) {
                return InteractionResult.CONSUME;
            }
        }
        return InteractionResult.PASS;
    }

    @NotNull
    public InteractionResult m_6880_(@NotNull ItemStack itemStack, Player player, @NotNull LivingEntity targetEntity, @NotNull InteractionHand hand) {
        if (!player.m_183503_().m_5776_()) {
            PlayerExtension<Player> performer = PlayerExtension.getOrThrow(player);
            LivingExtension<LivingEntity, ?> target = LivingExtension.getOrThrow(targetEntity);
            if (this.getActionType().createEntityAction(performer, target, hand).map(action -> performer.performAction((Action)action, true)).orElse(false).booleanValue()) {
                return InteractionResult.CONSUME;
            }
        }
        return InteractionResult.PASS;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level level, Player player, @NotNull InteractionHand hand) {
        if (!player.m_183503_().m_5776_()) {
            PlayerExtension<Player> performer = PlayerExtension.getOrThrow(player);
            BlockHitResult hitResult = ClothingItem.m_41435_((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.ANY);
            if (hitResult.m_6662_() == HitResult.Type.BLOCK && this.getActionType().createBlockAction(performer, new UseOnContext(player, hand, hitResult)).map(action -> performer.performAction((Action)action, true)).orElse(false).booleanValue()) {
                return InteractionResultHolder.m_19096_((Object)player.m_21120_(hand));
            }
            if (this.getActionType().createAction(performer, hand).map(action -> performer.performAction((Action)action, true)).orElse(false).booleanValue()) {
                return InteractionResultHolder.m_19096_((Object)player.m_21120_(hand));
            }
        }
        return InteractionResultHolder.m_19098_((Object)player.m_21120_(hand));
    }

    public int m_8105_(@NotNull ItemStack itemStack) {
        return this.getActionType().getDurationTicks();
    }

    public static ClothingItem getClothingItem(Player player) {
        PlayerExtension<Player> playerExtension = PlayerExtension.getOrThrow(player);
        if (!playerExtension.getItemInSlot(Equipment.Slot.CLOTHING).m_41619_()) {
            return (ClothingItem)playerExtension.getItemInSlot(Equipment.Slot.CLOTHING).m_41720_();
        }
        return null;
    }

    public float calculateDamage(float damage) {
        float reductionFactor = switch (this.clothingType) {
            default -> throw new IncompatibleClassChangeError();
            case ClothingType.CASUAL -> 1.0f - ((Double)ServerConfig.instance.casualClothingDamageReduction.get()).floatValue();
            case ClothingType.UTILITY -> 1.0f - ((Double)ServerConfig.instance.utilityClothingDamageReduction.get()).floatValue();
            case ClothingType.MILITARY -> 1.0f - ((Double)ServerConfig.instance.militaryClothingDamageReduction.get()).floatValue();
            case ClothingType.HEAVY -> 1.0f - ((Double)ServerConfig.instance.militaryClothingDamageReduction.get()).floatValue();
        };
        return damage * reductionFactor;
    }

    public float calculateBleedAndInfectionChance(float baseChance) {
        float reductionFactor = switch (this.clothingType) {
            default -> throw new IncompatibleClassChangeError();
            case ClothingType.CASUAL -> 1.0f - ((Double)ServerConfig.instance.casualClothingBleedAndInfectionReduction.get()).floatValue();
            case ClothingType.UTILITY -> 1.0f - ((Double)ServerConfig.instance.utilityClothingBleedAndInfectionReduction.get()).floatValue();
            case ClothingType.MILITARY -> 1.0f - ((Double)ServerConfig.instance.militaryClothingBleedAndInfectionReduction.get()).floatValue();
            case ClothingType.HEAVY -> 1.0f - ((Double)ServerConfig.instance.militaryClothingBleedAndInfectionReduction.get()).floatValue();
        };
        return baseChance * reductionFactor;
    }

    public static class Properties
    extends Item.Properties {
        private final ImmutableMultimap.Builder<Attribute, AttributeModifier> attributeModifiers = ImmutableMultimap.builder();
        private boolean fireImmunity;
        private boolean enhancesSwimming;

        public Properties attributeModifier(Attribute attribute, AttributeModifier modifier) {
            this.attributeModifiers.put((Object)attribute, (Object)modifier);
            return this;
        }

        public Properties fireImmunity() {
            this.fireImmunity = true;
            return this;
        }

        public Properties enhancesSwimming() {
            this.enhancesSwimming = true;
            return this;
        }
    }

    public static enum ClothingType {
        CASUAL,
        UTILITY,
        MILITARY,
        HEAVY;

    }
}

