/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.world.action.item;

import com.craftingdead.core.world.action.Action;
import com.craftingdead.core.world.action.ActionType;
import com.craftingdead.core.world.action.item.ItemAction;
import com.craftingdead.core.world.entity.extension.LivingExtension;
import com.google.common.base.Predicates;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraftforge.registries.ForgeRegistryEntry;
import org.jetbrains.annotations.Nullable;

public abstract class ItemActionType<T extends ItemAction>
extends ForgeRegistryEntry<ActionType<?>>
implements ActionType<T> {
    private final boolean triggeredByClient;
    private final boolean freezeMovement;
    private final int durationTicks;
    private final Predicate<ItemStack> heldItemPredicate;
    private final boolean consumeItem;
    @Nullable
    private final Supplier<? extends Item> resultItem;
    @Nullable
    private final Supplier<SoundEvent> finishSound;
    private final boolean consumeItemInCreative;
    private final boolean useResultItemInCreative;

    protected ItemActionType(Builder<?> builder) {
        this.triggeredByClient = builder.triggeredByClient;
        this.freezeMovement = builder.freezeMovement;
        this.durationTicks = builder.durationTicks;
        this.heldItemPredicate = builder.heldItemPredicate;
        this.consumeItem = builder.consumeItem;
        this.resultItem = builder.resultItem;
        this.finishSound = builder.finishSound;
        this.consumeItemInCreative = builder.consumeItemInCreative;
        this.useResultItemInCreative = builder.useResultItemInCreative;
    }

    public boolean isFreezeMovement() {
        return this.freezeMovement;
    }

    public int getDurationTicks() {
        return this.durationTicks;
    }

    public Predicate<ItemStack> getHeldItemPredicate() {
        return this.heldItemPredicate;
    }

    public boolean shouldConsumeItem() {
        return this.consumeItem;
    }

    public Optional<Item> getResultItem() {
        return Optional.ofNullable(this.resultItem).map(Supplier::get);
    }

    public Optional<SoundEvent> getFinishSound() {
        return Optional.ofNullable(this.finishSound).map(Supplier::get);
    }

    public boolean shouldConsumeItemInCreative() {
        return this.consumeItemInCreative;
    }

    public boolean useResultItemInCreative() {
        return this.useResultItemInCreative;
    }

    @Override
    public boolean isTriggeredByClient() {
        return this.triggeredByClient;
    }

    public Optional<Action> createBlockAction(LivingExtension<?, ?> performer, UseOnContext context) {
        return Optional.empty();
    }

    public Optional<Action> createEntityAction(LivingExtension<?, ?> performer, LivingExtension<?, ?> target, InteractionHand hand) {
        return Optional.empty();
    }

    public Optional<Action> createAction(LivingExtension<?, ?> performer, InteractionHand hand) {
        return Optional.empty();
    }

    public static abstract class Builder<SELF extends Builder<SELF>> {
        private boolean triggeredByClient;
        private boolean freezeMovement;
        private int durationTicks = 32;
        private Predicate<ItemStack> heldItemPredicate = Predicates.alwaysTrue();
        private boolean consumeItem = true;
        @Nullable
        private Supplier<? extends Item> resultItem;
        @Nullable
        private Supplier<SoundEvent> finishSound;
        private boolean consumeItemInCreative;
        private boolean useResultItemInCreative = true;

        public SELF setTriggeredByClient(boolean triggeredByClient) {
            this.triggeredByClient = triggeredByClient;
            return this.self();
        }

        public SELF setFreezeMovement(boolean freezeMovement) {
            this.freezeMovement = freezeMovement;
            return this.self();
        }

        public SELF duration(int durationTicks) {
            this.durationTicks = durationTicks;
            return this.self();
        }

        public SELF durationSeconds(float durationSeconds) {
            return this.duration(Mth.m_14143_((float)(20.0f * durationSeconds)));
        }

        public SELF forItem(Supplier<? extends Item> item) {
            return this.forItem((ItemStack itemStack) -> itemStack.m_150930_((Item)item.get()));
        }

        public SELF forItem(Predicate<ItemStack> heldItemPredicate) {
            this.heldItemPredicate = heldItemPredicate;
            return this.self();
        }

        public SELF consumeItem(boolean consumeItem) {
            this.consumeItem = consumeItem;
            return this.self();
        }

        public SELF resultItem(Supplier<? extends Item> resultItem) {
            this.resultItem = resultItem;
            return this.self();
        }

        public SELF finishSound(SoundEvent finishSound) {
            return this.finishSound(() -> finishSound);
        }

        public SELF finishSound(Supplier<SoundEvent> finishSound) {
            this.finishSound = finishSound;
            return this.self();
        }

        public SELF consumeItemInCreative(boolean consumeItemInCreative) {
            this.consumeItemInCreative = consumeItemInCreative;
            return this.self();
        }

        public SELF useResultItemInCreative(boolean useResultItemInCreative) {
            this.useResultItemInCreative = useResultItemInCreative;
            return this.self();
        }

        public abstract ItemActionType<?> build();

        protected SELF self() {
            return (SELF)this;
        }
    }
}

