/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.particle;

import com.craftingdead.core.particle.ModParticleTypes;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;

public record FlashParticleOptions(float red, float green, float blue, float scale) implements ParticleOptions
{
    public static final Codec<FlashParticleOptions> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("red").forGetter(FlashParticleOptions::red), (App)Codec.FLOAT.fieldOf("green").forGetter(FlashParticleOptions::green), (App)Codec.FLOAT.fieldOf("blue").forGetter(FlashParticleOptions::blue), (App)Codec.FLOAT.fieldOf("scale").forGetter(FlashParticleOptions::scale)).apply((Applicative)instance, FlashParticleOptions::new));
    public static final ParticleOptions.Deserializer<FlashParticleOptions> DESERIALIZER = new ParticleOptions.Deserializer<FlashParticleOptions>(){

        public FlashParticleOptions fromCommand(ParticleType<FlashParticleOptions> particleType, StringReader stringReader) throws CommandSyntaxException {
            stringReader.expect(' ');
            float red = stringReader.readFloat();
            stringReader.expect(' ');
            float green = stringReader.readFloat();
            stringReader.expect(' ');
            float blue = stringReader.readFloat();
            stringReader.expect(' ');
            float scale = stringReader.readFloat();
            return new FlashParticleOptions(red, green, blue, scale);
        }

        public FlashParticleOptions fromNetwork(ParticleType<FlashParticleOptions> particleType, FriendlyByteBuf packetBuffer) {
            return new FlashParticleOptions(packetBuffer.readFloat(), packetBuffer.readFloat(), packetBuffer.readFloat(), packetBuffer.readFloat());
        }
    };

    public void m_7711_(FriendlyByteBuf packetBuffer) {
        packetBuffer.writeFloat(this.red);
        packetBuffer.writeFloat(this.green);
        packetBuffer.writeFloat(this.blue);
        packetBuffer.writeFloat(this.scale);
    }

    public String m_5942_() {
        return String.format(Locale.ROOT, "%s %.2f %.2f %.2f %.2f", this.m_6012_().getRegistryName(), Float.valueOf(this.red), Float.valueOf(this.green), Float.valueOf(this.blue), Float.valueOf(this.scale));
    }

    public ParticleType<FlashParticleOptions> m_6012_() {
        return (ParticleType)ModParticleTypes.RGB_FLASH.get();
    }
}

