/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.data.guns;

import com.craftingdead.core.world.item.gun.GunConfiguration;
import com.craftingdead.core.world.item.gun.GunConfigurations;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Objects;
import net.minecraft.core.RegistryAccess;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import org.slf4j.Logger;

public class GunDataProvider
implements DataProvider {
    private static final Logger logger = LogUtils.getLogger();
    private final RegistryOps<JsonElement> ops = RegistryOps.m_206821_((DynamicOps)JsonOps.INSTANCE, (RegistryAccess)((RegistryAccess)RegistryAccess.f_123049_.get()));
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private final DataGenerator dataGenerator;

    public GunDataProvider(DataGenerator dataGenerator) {
        this.dataGenerator = dataGenerator;
    }

    public void m_6865_(HashCache cache) throws IOException {
        for (GunConfiguration gunType : GunConfigurations.registry.get()) {
            this.encodeGun(gunType, GunConfigurations.REGISTRY_KEY.m_135782_(), cache);
        }
    }

    private void encodeGun(GunConfiguration gun, ResourceLocation registryLocation, HashCache cache) {
        Path outputFolder = this.dataGenerator.m_123916_();
        ResourceLocation gunId = Objects.requireNonNull(gun.getRegistryName());
        String pathString = String.join((CharSequence)"/", PackType.SERVER_DATA.m_10305_(), gunId.m_135827_(), gunId.m_135827_(), registryLocation.m_135815_(), gunId.m_135815_() + ".json");
        Path path = outputFolder.resolve(pathString);
        GunConfiguration.DIRECT_CODEC.encodeStart(this.ops, (Object)gun).resultOrPartial(msg -> logger.error("Failed to encode {}: {}", (Object)path, msg)).ifPresent(json -> {
            try {
                DataProvider.m_123920_((Gson)this.gson, (HashCache)cache, (JsonElement)json, (Path)path);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public String m_6055_() {
        return "Crafting Dead Guns";
    }
}

