/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.client.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;

public final class MinecraftUtil {
    private static final Supplier<Minecraft> minecraftSupplier = MinecraftUtil.locateMinecraftSupplier();

    private MinecraftUtil() {
    }

    public static Minecraft getInstance() {
        return minecraftSupplier.get();
    }

    private static Supplier<Minecraft> locateMinecraftSupplier() {
        try {
            Method method = Minecraft.class.getMethod("getInstance", new Class[0]);
            return () -> MinecraftUtil.invokeFactory(method);
        }
        catch (NoSuchMethodException fallback) {
            try {
                Method method = Minecraft.class.getDeclaredMethod("m_91087_", new Class[0]);
                method.setAccessible(true);
                return () -> MinecraftUtil.invokeFactory(method);
            }
            catch (NoSuchMethodException missing) {
                throw new IllegalStateException("Unable to locate Minecraft singleton accessor", missing);
            }
        }
    }

    private static Minecraft invokeFactory(Method method) {
        try {
            return (Minecraft)method.invoke(null, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new IllegalStateException("Failed to acquire Minecraft instance", e);
        }
    }
}

