/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.client.updater;

import com.craftingdead.core.client.updater.ModAutoUpdater;
import com.craftingdead.core.client.updater.UpdateNotificationScreen;
import com.mojang.logging.LogUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraftforge.client.event.ScreenOpenEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.slf4j.Logger;

public class ClientUpdateEventHandler {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static boolean updateCheckStarted = false;
    private static boolean notificationShown = false;
    private static boolean mainMenuDetected = false;

    public ClientUpdateEventHandler() {
        LOGGER.info("[Auto-Updater] Client update handler initialized and registered");
    }

    @SubscribeEvent
    public void onScreenOpen(ScreenOpenEvent event) {
        if (updateCheckStarted) {
            return;
        }
        Screen screen = event.getScreen();
        if (screen == null) {
            return;
        }
        String className = screen.getClass().getSimpleName().toLowerCase();
        if (className.contains("main") || className.contains("title") || screen instanceof TitleScreen) {
            LOGGER.info("Main menu detected: {}", (Object)screen.getClass().getSimpleName());
            mainMenuDetected = true;
        }
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (!mainMenuDetected || updateCheckStarted) {
            return;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        Screen currentScreen = minecraft.f_91080_;
        if (currentScreen == null) {
            return;
        }
        String className = currentScreen.getClass().getSimpleName().toLowerCase();
        if (className.contains("main") || className.contains("title") || currentScreen instanceof TitleScreen) {
            LOGGER.info("[Auto-Updater] ====================================");
            LOGGER.info("[Auto-Updater] Starting client update check...");
            LOGGER.info("[Auto-Updater] CDN: https://dl.brad.ac/releases/");
            LOGGER.info("[Auto-Updater] ====================================");
            updateCheckStarted = true;
            ModAutoUpdater.checkForUpdates();
            this.scheduleNotificationCheck();
        }
    }

    private void scheduleNotificationCheck() {
        new Thread(() -> {
            try {
                for (int attempts = 0; attempts < 60; ++attempts) {
                    Thread.sleep(1000L);
                    if (!ModAutoUpdater.hasUpdates() || notificationShown) continue;
                    Minecraft.m_91087_().execute(() -> this.showNotification());
                    break;
                }
            }
            catch (InterruptedException e) {
                LOGGER.error("Update notification check interrupted", (Throwable)e);
                Thread.currentThread().interrupt();
            }
        }, "ClientUpdateNotifier").start();
    }

    private void showNotification() {
        if (notificationShown) {
            return;
        }
        notificationShown = true;
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91080_ != null) {
            UpdateNotificationScreen screen = new UpdateNotificationScreen(minecraft.f_91080_, ModAutoUpdater.getUpdatedMods());
            minecraft.m_91152_((Screen)screen);
            LOGGER.info("Update notification displayed to player.");
        }
    }
}

