/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.world.item.equipment;

import com.craftingdead.core.world.item.ClothingItem;
import com.craftingdead.core.world.item.equipment.ClothingProtection;
import com.craftingdead.core.world.item.equipment.ClothingProtectionPresets;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class ClothingProtectionInitializer {
    @SubscribeEvent
    public static void onItemEntitySpawn(EntityJoinWorldEvent event) {
        if (event.getWorld().m_5776_()) {
            return;
        }
        Entity entity = event.getEntity();
        if (entity instanceof ItemEntity) {
            ItemEntity itemEntity = (ItemEntity)entity;
            ItemStack itemStack = itemEntity.m_32055_();
            ClothingProtectionInitializer.initializeClothingProtection(itemStack);
        }
    }

    @SubscribeEvent
    public static void onItemCrafted(PlayerEvent.ItemCraftedEvent event) {
        ItemStack itemStack = event.getCrafting();
        ClothingProtectionInitializer.initializeClothingProtection(itemStack);
    }

    @SubscribeEvent
    public static void onItemPickup(EntityItemPickupEvent event) {
        ItemStack itemStack = event.getItem().m_32055_();
        ClothingProtectionInitializer.initializeClothingProtection(itemStack);
    }

    private static void initializeClothingProtection(ItemStack itemStack) {
        Item item;
        if (itemStack.m_41619_() || !((item = itemStack.m_41720_()) instanceof ClothingItem)) {
            return;
        }
        ClothingItem clothingItem = (ClothingItem)item;
        if (ClothingProtection.hasProtectionAttributes(itemStack)) {
            return;
        }
        ClothingItem.ClothingType type = clothingItem.getClothingType();
        ClothingProtectionPresets.applyByType(itemStack, type);
    }
}

