/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.world.entity.extension;

import com.craftingdead.core.network.Synched;
import com.craftingdead.core.world.entity.extension.Visibility;
import java.util.Collection;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.common.util.INBTSerializable;

public interface LivingHandler
extends INBTSerializable<CompoundTag>,
Synched {
    default public void tick() {
    }

    default public float handleDamaged(DamageSource source, float amount) {
        return amount;
    }

    default public boolean handleHurt(DamageSource source, float amount) {
        return false;
    }

    default public boolean handleKill(Entity target) {
        return false;
    }

    default public boolean handleDeath(DamageSource cause) {
        return false;
    }

    default public boolean handleDeathLoot(DamageSource cause, Collection<ItemEntity> loot, int lootingLevel) {
        return false;
    }

    default public void handleStartTracking(ServerPlayer playerEntity) {
    }

    default public boolean isMovementBlocked() {
        return false;
    }

    default public boolean handleBlockPlace(BlockSnapshot replacedBlock, BlockState placedBlock, BlockState placedAgainst) {
        return false;
    }

    default public boolean handleMultiBlockPlace(List<BlockSnapshot> replacedBlocks, BlockState placedBlock, BlockState placedAgainst) {
        return false;
    }

    default public Visibility getVisibility() {
        return Visibility.VISIBLE;
    }

    default public CompoundTag serializeNBT() {
        return new CompoundTag();
    }

    default public void deserializeNBT(CompoundTag tag) {
    }
}

