/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.trauma;

import com.craftingdead.core.trauma.ProtectionConfig;
import com.craftingdead.core.trauma.TraumaSeverity;
import com.craftingdead.core.world.entity.extension.LivingExtension;
import com.craftingdead.core.world.item.ClothingItem;
import com.craftingdead.core.world.item.equipment.Equipment;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public final class ProtectionLookup {
    public static final ProtectionLookup INSTANCE = new ProtectionLookup();
    private static final ResourceLocation JUGGERNAUT_CLOTHING_ID = new ResourceLocation("craftingdead", "juggernaut_clothing");

    private ProtectionLookup() {
    }

    public HeadshotResult resolveHeadshot(LivingExtension<?, ?> target, float incomingEnergy) {
        ItemStack vestStack;
        ProtectionConfig.ProtectionProfile vestProfile;
        ResourceLocation helmetId;
        ProtectionConfig config = ProtectionConfig.get();
        ProtectionConfig.HeadTraumaSettings settings = config.headTrauma();
        if (!settings.enabled() || incomingEnergy <= 0.0f) {
            return HeadshotResult.noEffect();
        }
        Object entity = target.entity();
        float energy = Math.max(0.0f, incomingEnergy);
        float helmetAbsorbed = 0.0f;
        float vestAbsorbed = 0.0f;
        int helmetDurabilityLoss = 0;
        int vestDurabilityLoss = 0;
        boolean helmetEquipped = false;
        boolean forcedSevere = false;
        ItemStack helmetStack = target.getItemInSlot(Equipment.Slot.HAT);
        ProtectionConfig.ProtectionProfile helmetProfile = this.resolveProfile(helmetStack, config.helmetProfile(helmetId = ProtectionLookup.idForItem(helmetStack.m_41720_())), helmetId != null && config.isHelmetCosmetic(helmetId));
        if (!helmetProfile.isEmpty()) {
            helmetEquipped = true;
            helmetAbsorbed = Math.min(energy * helmetProfile.absorption(), helmetProfile.stoppingPower());
            energy = Math.max(0.0f, energy - helmetAbsorbed);
            if (helmetProfile.stunThreshold() > 0.0f && incomingEnergy > helmetProfile.stunThreshold()) {
                forcedSevere = true;
            }
            if (!((LivingEntity)entity).f_19853_.m_5776_()) {
                helmetDurabilityLoss = this.applyDurabilityLoss(helmetStack, helmetProfile, helmetAbsorbed, (LivingEntity)entity, EquipmentSlot.HEAD);
            }
        } else {
            energy *= settings.noHelmetMultiplier();
        }
        if (!(vestProfile = this.resolveProfile(vestStack = target.getItemInSlot(Equipment.Slot.VEST), config.vestProfile(ProtectionLookup.idForItem(vestStack.m_41720_())), config.isVestCosmetic(ProtectionLookup.idForItem(vestStack.m_41720_())))).isEmpty() && energy > 0.0f) {
            float share = Math.min(energy * 0.15f, vestProfile.stoppingPower() * 0.5f);
            vestAbsorbed = Math.min(energy, share);
            energy = Math.max(0.0f, energy - vestAbsorbed);
            if (!((LivingEntity)entity).f_19853_.m_5776_()) {
                vestDurabilityLoss = this.applyDurabilityLoss(vestStack, vestProfile, vestAbsorbed, (LivingEntity)entity, EquipmentSlot.CHEST);
            }
        }
        float energyBeforeClothing = energy;
        energy = this.applyClothingMitigation(target, energy);
        float clothingMitigated = energyBeforeClothing - energy;
        TraumaSeverity severity = config.determineSeverity(energy, forcedSevere);
        ProtectionConfig.TraumaEffect effect = config.effectForSeverity(severity);
        return new HeadshotResult(severity, effect, energy, helmetAbsorbed, vestAbsorbed, helmetEquipped, Math.max(0.0f, clothingMitigated), helmetDurabilityLoss, vestDurabilityLoss);
    }

    private ProtectionConfig.ProtectionProfile resolveProfile(ItemStack stack, ProtectionConfig.ProtectionProfile profile, boolean cosmetic) {
        if (stack.m_41619_() || cosmetic) {
            return ProtectionConfig.ProtectionProfile.EMPTY;
        }
        return profile;
    }

    private int applyDurabilityLoss(ItemStack stack, ProtectionConfig.ProtectionProfile profile, float absorbedEnergy, LivingEntity entity, EquipmentSlot equipmentSlot) {
        ServerPlayer serverPlayer;
        int finalLoss;
        if (stack.m_41619_() || !stack.m_41763_() || absorbedEnergy <= 0.0f) {
            return 0;
        }
        int durabilityLoss = Mth.m_14143_((float)(absorbedEnergy * profile.durabilityPerEnergy()));
        if (durabilityLoss <= 0) {
            durabilityLoss = 1;
        }
        if (stack.m_41629_(finalLoss = durabilityLoss, Objects.requireNonNull(entity.m_21187_()), entity instanceof ServerPlayer ? (serverPlayer = (ServerPlayer)entity) : null)) {
            entity.m_21166_(Objects.requireNonNull(equipmentSlot));
        }
        return finalLoss;
    }

    private float applyClothingMitigation(LivingExtension<?, ?> target, float energy) {
        ItemStack clothingStack = target.getItemInSlot(Equipment.Slot.CLOTHING);
        if (clothingStack.m_41619_()) {
            return energy;
        }
        Item item = clothingStack.m_41720_();
        if (item instanceof ClothingItem) {
            ClothingItem clothingItem = (ClothingItem)item;
            energy = Math.max(0.0f, clothingItem.calculateDamage(energy));
            if (this.isJuggernautClothing(clothingStack)) {
                energy *= 0.85f;
            }
        }
        return energy;
    }

    private boolean isJuggernautClothing(ItemStack stack) {
        ResourceLocation id = ProtectionLookup.idForItem(stack.m_41720_());
        return JUGGERNAUT_CLOTHING_ID.equals((Object)id);
    }

    private static ResourceLocation idForItem(Item item) {
        return ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)item);
    }

    public record HeadshotResult(TraumaSeverity severity, ProtectionConfig.TraumaEffect effect, float remainingEnergy, float helmetAbsorbed, float vestAbsorbed, boolean helmetEquipped, float clothingMitigated, int helmetDurabilityLoss, int vestDurabilityLoss) {
        public static HeadshotResult noEffect() {
            return new HeadshotResult(TraumaSeverity.NONE, ProtectionConfig.TraumaEffect.EMPTY, 0.0f, 0.0f, 0.0f, false, 0.0f, 0, 0);
        }
    }
}

