/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.world.item;

import com.craftingdead.core.trauma.ProtectionConfig;
import com.craftingdead.core.world.item.EquipmentItem;
import com.craftingdead.core.world.item.equipment.Equipment;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuConstructor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.jetbrains.annotations.Nullable;

public class StorageItem
extends EquipmentItem {
    public static final int MAX_ROWS_TO_SHOW = 6;
    public static final UUID ARMOR_MODIFIER_ID = UUID.fromString("5900b64d-0e0b-4872-804b-0522bb87c33f");
    private final Multimap<Attribute, AttributeModifier> attributeModifiers;
    private final Equipment.Slot slot;
    private final int itemRows;
    private final ItemHandlerMenuConstructor menuConstructor;

    public StorageItem(Properties properties) {
        super(properties);
        this.attributeModifiers = properties.attributeModifiers.build();
        this.slot = properties.slot;
        this.itemRows = properties.itemRows;
        this.menuConstructor = properties.menuConstructor;
    }

    public ICapabilityProvider initCapabilities(ItemStack itemStack, @Nullable CompoundTag nbt) {
        return new ICapabilitySerializable<CompoundTag>(){
            private final LazyOptional<Storage> storage = LazyOptional.of(() -> new Storage());

            public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
                if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
                    return this.storage.lazyMap(Storage::itemHandler).cast();
                }
                if (cap == Equipment.CAPABILITY) {
                    return this.storage.cast();
                }
                return LazyOptional.empty();
            }

            public CompoundTag serializeNBT() {
                return (CompoundTag)this.storage.lazyMap(Storage::itemHandler).lazyMap(ItemStackHandler::serializeNBT).orElseGet(CompoundTag::new);
            }

            public void deserializeNBT(CompoundTag tag) {
                this.storage.lazyMap(Storage::itemHandler).ifPresent(itemHandler -> itemHandler.deserializeNBT(tag));
            }
        };
    }

    @Override
    public void m_7373_(ItemStack itemStack, Level world, List<Component> lines, TooltipFlag tooltipFlag) {
        ProtectionConfig.ProtectionProfile profile;
        ResourceLocation itemId;
        super.m_7373_(itemStack, world, lines, tooltipFlag);
        if (this.slot == Equipment.Slot.VEST && (itemId = ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)itemStack.m_41720_())) != null && !(profile = ProtectionConfig.get().vestProfile(itemId)).isEmpty()) {
            lines.add(TextComponent.f_131282_);
            lines.add((Component)new TranslatableComponent("equipment.ballistic_stats").m_130944_(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.BOLD}));
            MutableComponent absorptionText = new TextComponent(Objects.requireNonNull(String.format(Locale.ROOT, "%.0f%%", Float.valueOf(profile.absorption() * 100.0f)))).m_130940_(ChatFormatting.RED);
            lines.add((Component)new TextComponent("\u25a3 ").m_130940_(ChatFormatting.BLUE).m_7220_((Component)new TranslatableComponent("equipment.absorption").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Objects.requireNonNull(absorptionText))));
            MutableComponent stoppingPowerText = new TextComponent(Objects.requireNonNull(String.format(Locale.ROOT, "%.0f", Float.valueOf(profile.stoppingPower())))).m_130940_(ChatFormatting.RED);
            lines.add((Component)new TextComponent("\u2699 ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)new TranslatableComponent("equipment.stopping_power").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Objects.requireNonNull(stoppingPowerText))));
            if (profile.stunThreshold() > 0.0f) {
                MutableComponent stunThresholdText = new TextComponent(Objects.requireNonNull(String.format(Locale.ROOT, "%.0f", Float.valueOf(profile.stunThreshold())))).m_130940_(ChatFormatting.RED);
                lines.add((Component)new TextComponent("\u2716 ").m_130940_(ChatFormatting.YELLOW).m_7220_((Component)new TranslatableComponent("equipment.stun_threshold").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Objects.requireNonNull(stunThresholdText))));
            }
            MutableComponent durabilityText = new TextComponent(Objects.requireNonNull(String.format(Locale.ROOT, "%.2f", Float.valueOf(profile.durabilityPerEnergy())))).m_130940_(ChatFormatting.RED);
            lines.add((Component)new TextComponent("\u25ca ").m_130940_(ChatFormatting.DARK_GRAY).m_7220_((Component)new TranslatableComponent("equipment.durability_per_energy").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Objects.requireNonNull(durabilityText))));
        }
        itemStack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(itemHandler -> {
            int itemsBeyondLimit = 0;
            int itemsDisplayed = 0;
            for (int i = 0; i < itemHandler.getSlots(); ++i) {
                ItemStack stack = itemHandler.getStackInSlot(i);
                if (stack.m_41619_()) continue;
                if (itemsDisplayed++ >= 6) {
                    ++itemsBeyondLimit;
                    continue;
                }
                MutableComponent amountText = new TextComponent(stack.m_41613_() + "x ").m_130940_(ChatFormatting.DARK_GRAY);
                MutableComponent itemText = stack.m_41786_().m_6879_().m_130940_(ChatFormatting.GRAY);
                if (itemsDisplayed == 1) {
                    lines.add((Component)new TextComponent(" "));
                    lines.add((Component)new TranslatableComponent("storage_item.contents").m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD}));
                }
                lines.add((Component)amountText.m_7220_((Component)itemText));
            }
            if (itemsBeyondLimit > 0) {
                lines.add((Component)new TextComponent(". . . + " + itemsBeyondLimit).m_130940_(ChatFormatting.RED));
            }
        });
    }

    public CompoundTag getShareTag(ItemStack stack) {
        CompoundTag shareTag = stack.m_41783_() == null ? new CompoundTag() : stack.m_41783_();
        stack.getCapability(Equipment.CAPABILITY).cast().lazyMap(Storage::itemHandler).map(ItemStackHandler::serializeNBT).filter(tag -> !tag.m_128456_()).ifPresent(tag -> shareTag.m_128365_("storage", (Tag)tag));
        return shareTag;
    }

    public void readShareTag(ItemStack stack, @Nullable CompoundTag tag) {
        if (tag != null && tag.m_128425_("storage", 10)) {
            stack.getCapability(Equipment.CAPABILITY).cast().ifPresent(storage -> storage.itemHandler().deserializeNBT(tag.m_128469_("storage")));
        }
        super.readShareTag(stack, tag);
    }

    public static class Properties
    extends Item.Properties {
        private ImmutableMultimap.Builder<Attribute, AttributeModifier> attributeModifiers = ImmutableMultimap.builder();
        private Equipment.Slot slot;
        private int itemRows;
        private ItemHandlerMenuConstructor menuConstructor;

        public Properties attributeModifier(Attribute attribute, AttributeModifier modifier) {
            this.attributeModifiers.put((Object)Objects.requireNonNull(attribute), (Object)Objects.requireNonNull(modifier));
            return this;
        }

        public Properties slot(Equipment.Slot slot) {
            this.slot = slot;
            return this;
        }

        public Properties itemRows(int itemRows) {
            this.itemRows = itemRows;
            return this;
        }

        public Properties menuConstructor(ItemHandlerMenuConstructor menuConstructor) {
            this.menuConstructor = menuConstructor;
            return this;
        }
    }

    @FunctionalInterface
    public static interface ItemHandlerMenuConstructor {
        @Nullable
        public AbstractContainerMenu createMenu(int var1, Inventory var2, IItemHandler var3);
    }

    private class Storage
    implements Equipment,
    MenuConstructor {
        private final ItemStackHandler itemHandler;

        public Storage() {
            final int size = StorageItem.this.itemRows * 9;
            this.itemHandler = new ItemStackHandler(size){

                protected void onLoad() {
                    if (this.getSlots() != size) {
                        this.setSize(size);
                    }
                }
            };
        }

        private ItemStackHandler itemHandler() {
            return this.itemHandler;
        }

        public AbstractContainerMenu m_7208_(int windowId, Inventory inventory, Player player) {
            return StorageItem.this.menuConstructor.createMenu(windowId, inventory, (IItemHandler)this.itemHandler);
        }

        @Override
        public Multimap<Attribute, AttributeModifier> attributeModifiers() {
            return StorageItem.this.attributeModifiers;
        }

        @Override
        public boolean isValidForSlot(Equipment.Slot slot) {
            return slot == StorageItem.this.slot;
        }
    }
}

