/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.world.item;

import com.craftingdead.core.world.item.ToolItem;
import com.craftingdead.core.world.item.combatslot.CombatSlot;
import com.craftingdead.core.world.item.combatslot.CombatSlotProvider;
import com.craftingdead.core.world.item.equipment.Equipment;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MeleeWeaponItem
extends ToolItem {
    private final int attackDamage;
    private final Multimap<Attribute, AttributeModifier> attributeModifiers;

    public MeleeWeaponItem(int attackDamage, double attackSpeed, Item.Properties properties) {
        super(properties);
        this.attackDamage = attackDamage;
        this.attributeModifiers = ImmutableMultimap.of((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", (double)this.attackDamage, AttributeModifier.Operation.ADDITION), (Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", attackSpeed, AttributeModifier.Operation.ADDITION));
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot equipmentSlot, ItemStack itemStack) {
        return equipmentSlot == EquipmentSlot.MAINHAND ? this.attributeModifiers : super.getAttributeModifiers(equipmentSlot, itemStack);
    }

    public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, @NotNull TooltipFlag flag) {
        super.m_7373_(stack, world, tooltip, flag);
        double attackSpeed = 4.0;
        for (AttributeModifier modifier : this.attributeModifiers.get((Object)Attributes.f_22283_)) {
            attackSpeed += modifier.m_22218_();
        }
        tooltip.add((Component)new TranslatableComponent("melee.stats").m_130944_(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.BOLD}));
        tooltip.add((Component)new TranslatableComponent("\u2716 ").m_130940_(ChatFormatting.DARK_GRAY).m_7220_((Component)new TranslatableComponent("melee.damage").m_130940_(ChatFormatting.GRAY)).m_130946_(": ").m_7220_((Component)new TranslatableComponent(String.valueOf(this.attackDamage)).m_130940_(ChatFormatting.RED)));
        String attacksPerSecond = String.format("%.1f", attackSpeed);
        tooltip.add((Component)new TranslatableComponent("\u00bb ").m_130940_(ChatFormatting.DARK_GRAY).m_7220_((Component)new TranslatableComponent("melee.attack_speed").m_130940_(ChatFormatting.GRAY)).m_130946_(": ").m_7220_((Component)new TranslatableComponent(attacksPerSecond).m_130940_(ChatFormatting.AQUA)));
        int durability = stack.m_41776_() - stack.m_41773_();
        int maxDurability = stack.m_41776_();
        ChatFormatting durabilityColor = (double)durability > (double)maxDurability * 0.5 ? ChatFormatting.GREEN : ((double)durability > (double)maxDurability * 0.25 ? ChatFormatting.YELLOW : ChatFormatting.RED);
        tooltip.add((Component)new TranslatableComponent("\u25c6 ").m_130940_(ChatFormatting.DARK_GRAY).m_7220_((Component)new TranslatableComponent("melee.durability").m_130940_(ChatFormatting.GRAY)).m_130946_(": ").m_7220_((Component)new TranslatableComponent(durability + "/" + maxDurability).m_130940_(durabilityColor)));
    }

    public ICapabilityProvider initCapabilities(ItemStack itemStack, @Nullable CompoundTag nbt) {
        final LazyOptional combatSlotProvider = LazyOptional.of(() -> CombatSlot.MELEE);
        final LazyOptional equipment = LazyOptional.of(() -> Equipment.forSlot(Equipment.Slot.MELEE));
        return new ICapabilityProvider(){

            @NotNull
            public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, Direction side) {
                if (cap == CombatSlotProvider.CAPABILITY) {
                    return combatSlotProvider.cast();
                }
                if (cap == Equipment.CAPABILITY) {
                    return equipment.cast();
                }
                return LazyOptional.empty();
            }
        };
    }
}

