/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.world.item;

import com.craftingdead.core.capability.CapabilityUtil;
import com.craftingdead.core.trauma.ProtectionConfig;
import com.craftingdead.core.world.item.EquipmentItem;
import com.craftingdead.core.world.item.equipment.Equipment;
import com.craftingdead.core.world.item.equipment.SimpleHat;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class HatItem
extends EquipmentItem {
    public static final UUID ARMOR_MODIFIER_ID = UUID.fromString("88251241-3150-423f-95be-b3daaabd48bb");
    private final Multimap<Attribute, AttributeModifier> attributeModifiers;
    private final float headshotReductionPercentage;
    private final boolean immuneToFlashes;
    private final boolean immuneToGas;
    private final boolean nightVision;
    private final boolean waterBreathing;

    public HatItem(Properties properties) {
        super(properties);
        this.attributeModifiers = properties.attributeModifiers.build();
        this.headshotReductionPercentage = properties.headshotReductionPercentage;
        this.immuneToFlashes = properties.immuneToFlashes;
        this.immuneToGas = properties.immuneToGas;
        this.nightVision = properties.nightVision;
        this.waterBreathing = properties.waterBreathing;
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> lines, TooltipFlag tooltipFlag) {
        ProtectionConfig.ProtectionProfile profile;
        ResourceLocation itemId;
        super.m_7373_(stack, world, lines, tooltipFlag);
        if (this.headshotReductionPercentage > 0.0f) {
            MutableComponent percentageText = new TextComponent(Objects.requireNonNull(String.format(Locale.ROOT, "%.0f%%", Float.valueOf(this.headshotReductionPercentage * 100.0f)))).m_130940_(ChatFormatting.RED);
            lines.add((Component)new TextComponent("\u25c8 ").m_130940_(ChatFormatting.GOLD).m_7220_((Component)new TranslatableComponent("hat.headshot_reduction").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Objects.requireNonNull(percentageText))));
        }
        if (this.immuneToFlashes) {
            lines.add((Component)new TextComponent("\u2726 ").m_130940_(ChatFormatting.YELLOW).m_7220_((Component)new TranslatableComponent("hat.immune_to_flashes").m_130940_(ChatFormatting.GRAY)));
        }
        if (this.immuneToGas) {
            lines.add((Component)new TextComponent("\u2601 ").m_130940_(ChatFormatting.GREEN).m_7220_((Component)new TranslatableComponent("hat.immune_to_gas").m_130940_(ChatFormatting.GRAY)));
        }
        if (this.nightVision) {
            lines.add((Component)new TextComponent("\u2605 ").m_130940_(ChatFormatting.AQUA).m_7220_((Component)new TranslatableComponent("hat.has_night_vision").m_130940_(ChatFormatting.GRAY)));
        }
        if ((itemId = ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)stack.m_41720_())) != null && !(profile = ProtectionConfig.get().helmetProfile(itemId)).isEmpty()) {
            lines.add(TextComponent.f_131282_);
            lines.add((Component)new TranslatableComponent("equipment.ballistic_stats").m_130944_(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.BOLD}));
            MutableComponent absorptionText = new TextComponent(Objects.requireNonNull(String.format(Locale.ROOT, "%.0f%%", Float.valueOf(profile.absorption() * 100.0f)))).m_130940_(ChatFormatting.RED);
            lines.add((Component)new TextComponent("\u25a3 ").m_130940_(ChatFormatting.BLUE).m_7220_((Component)new TranslatableComponent("equipment.absorption").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Objects.requireNonNull(absorptionText))));
            MutableComponent stoppingPowerText = new TextComponent(Objects.requireNonNull(String.format(Locale.ROOT, "%.0f", Float.valueOf(profile.stoppingPower())))).m_130940_(ChatFormatting.RED);
            lines.add((Component)new TextComponent("\u2699 ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)new TranslatableComponent("equipment.stopping_power").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Objects.requireNonNull(stoppingPowerText))));
            if (profile.stunThreshold() > 0.0f) {
                MutableComponent stunThresholdText = new TextComponent(Objects.requireNonNull(String.format(Locale.ROOT, "%.0f", Float.valueOf(profile.stunThreshold())))).m_130940_(ChatFormatting.RED);
                lines.add((Component)new TextComponent("\u2716 ").m_130940_(ChatFormatting.YELLOW).m_7220_((Component)new TranslatableComponent("equipment.stun_threshold").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Objects.requireNonNull(stunThresholdText))));
            }
            MutableComponent durabilityText = new TextComponent(Objects.requireNonNull(String.format(Locale.ROOT, "%.2f", Float.valueOf(profile.durabilityPerEnergy())))).m_130940_(ChatFormatting.RED);
            lines.add((Component)new TextComponent("\u25ca ").m_130940_(ChatFormatting.DARK_GRAY).m_7220_((Component)new TranslatableComponent("equipment.durability_per_energy").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Objects.requireNonNull(durabilityText))));
        }
    }

    public ICapabilityProvider initCapabilities(ItemStack itemStack, @Nullable CompoundTag nbt) {
        return CapabilityUtil.provider(() -> new SimpleHat(this.attributeModifiers, this.waterBreathing, this.nightVision, this.headshotReductionPercentage, this.immuneToFlashes), Equipment.CAPABILITY);
    }

    public static class Properties
    extends Item.Properties {
        private final ImmutableMultimap.Builder<Attribute, AttributeModifier> attributeModifiers = ImmutableMultimap.builder();
        private float headshotReductionPercentage;
        private boolean immuneToFlashes;
        private boolean immuneToGas;
        private boolean nightVision;
        private boolean waterBreathing;

        public Properties attributeModifier(Attribute attribute, AttributeModifier modifier) {
            this.attributeModifiers.put((Object)Objects.requireNonNull(attribute), (Object)Objects.requireNonNull(modifier));
            return this;
        }

        public Properties setHeadshotReductionPercentage(float headshotReductionPercentage) {
            this.headshotReductionPercentage = headshotReductionPercentage;
            return this;
        }

        public Properties waterBreathing(boolean waterBreathing) {
            this.waterBreathing = waterBreathing;
            return this;
        }

        public Properties setNightVision(boolean nightVision) {
            this.nightVision = nightVision;
            return this;
        }

        public Properties setImmuneToFlashes(boolean immuneToFlashes) {
            this.immuneToFlashes = immuneToFlashes;
            return this;
        }

        public Properties setImmuneToGas(boolean immuneToGas) {
            this.immuneToGas = immuneToGas;
            return this;
        }
    }
}

