/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.world.entity.grenade;

import com.craftingdead.core.CraftingDead;
import com.craftingdead.core.ServerConfig;
import com.craftingdead.core.particle.FlashParticleOptions;
import com.craftingdead.core.world.effect.ModMobEffects;
import com.craftingdead.core.world.entity.EntityUtil;
import com.craftingdead.core.world.entity.ModEntityTypes;
import com.craftingdead.core.world.entity.extension.LivingExtension;
import com.craftingdead.core.world.entity.grenade.Grenade;
import com.craftingdead.core.world.item.GrenadeItem;
import com.craftingdead.core.world.item.ModItems;
import com.craftingdead.core.world.item.equipment.Equipment;
import com.craftingdead.core.world.item.equipment.Hat;
import java.util.OptionalInt;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class FlashGrenadeEntity
extends Grenade {
    public static final int EFFECT_MAX_DURATION = 110;

    public FlashGrenadeEntity(EntityType<? extends Grenade> entityIn, Level worldIn) {
        super(entityIn, worldIn);
    }

    public FlashGrenadeEntity(Level worldIn) {
        super((EntityType<? extends Grenade>)((EntityType)ModEntityTypes.FLASH_GRENADE.get()), worldIn);
    }

    public FlashGrenadeEntity(LivingEntity thrower, Level worldIn) {
        super((EntityType<? extends Grenade>)((EntityType)ModEntityTypes.FLASH_GRENADE.get()), thrower, worldIn);
    }

    @Override
    public void activatedChanged(boolean activated) {
        if (activated) {
            this.flash();
        } else if (!this.f_19853_.m_5776_()) {
            this.m_6074_();
        }
    }

    @Override
    public OptionalInt getMinimumTicksUntilAutoActivation() {
        return OptionalInt.of((Integer)ServerConfig.instance.explosivesFlashGrenadeTicksBeforeActivation.get());
    }

    @Override
    public OptionalInt getMinimumTicksUntilAutoDeactivation() {
        return OptionalInt.of((Integer)ServerConfig.instance.explosivesFlashGrenadeTicksBeforeDeactivation.get());
    }

    @Override
    public void onGrenadeTick() {
    }

    @Override
    public void onMotionStop(int stopsCount) {
    }

    private void flash() {
        if (this.f_19853_.m_5776_()) {
            this.f_19853_.m_7106_((ParticleOptions)new FlashParticleOptions(1.0f, 1.0f, 1.0f, 2.0f), this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
            CraftingDead.getInstance().getClientDist().checkApplyFlashEffects(this);
        } else {
            this.m_5496_(SoundEvents.f_11913_, 3.0f, 1.2f);
            Double flashRange = (Double)ServerConfig.instance.explosivesFlashRadius.get();
            this.f_19853_.m_6249_((Entity)this, this.m_142469_().m_82400_(flashRange.doubleValue()), entity -> entity instanceof LivingEntity && !(entity instanceof Player)).stream().map(entity -> (LivingEntity)entity).forEach(livingEntity -> {
                boolean wasFlashApplied;
                int duration = this.calculateDuration((LivingEntity)livingEntity, EntityUtil.canSee(livingEntity, this, 90.0f));
                if (duration > 0 && (wasFlashApplied = ModMobEffects.applyOrOverrideIfLonger(livingEntity, new MobEffectInstance((MobEffect)ModMobEffects.FLASH_BLINDNESS.get(), duration))) && livingEntity instanceof Mob) {
                    Mob mobEntity = (Mob)livingEntity;
                    mobEntity.m_6710_(null);
                }
            });
        }
    }

    public int calculateDuration(LivingEntity viewerEntity, boolean visible) {
        if (!viewerEntity.m_142582_((Entity)this)) {
            return 0;
        }
        Boolean immuneToFlashes = viewerEntity.getCapability(LivingExtension.CAPABILITY).resolve().flatMap(living -> living.getEquipmentInSlot(Equipment.Slot.HAT, Hat.class)).map(Hat::immuneToFlashes).orElse(false);
        Double flashRange = (Double)ServerConfig.instance.explosivesFlashRadius.get();
        if (visible && !immuneToFlashes.booleanValue()) {
            double distanceProportion = Mth.m_14008_((double)((double)this.m_20270_((Entity)viewerEntity) / flashRange), (double)0.0, (double)1.0);
            int calculatedDuration = (int)Mth.m_14139_((double)(1.0 - distanceProportion), (double)0.0, (double)110.0);
            if (!(viewerEntity instanceof Player)) {
                calculatedDuration *= 4;
            }
            return calculatedDuration;
        }
        return viewerEntity instanceof Player ? 5 : 0;
    }

    @Override
    public GrenadeItem asItem() {
        return (GrenadeItem)((Object)ModItems.FLASH_GRENADE.get());
    }
}

