/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.client.updater;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VersionComparator {
    private static final Pattern VERSION_PATTERN = Pattern.compile("(\\d+)\\.(\\d+)\\.(\\d+)\\.(\\d+)");

    public static int compare(String version1, String version2) {
        int[] parts1 = VersionComparator.parseVersion(version1);
        int[] parts2 = VersionComparator.parseVersion(version2);
        if (parts1 == null || parts2 == null) {
            return version1.compareTo(version2);
        }
        for (int i = 0; i < Math.min(parts1.length, parts2.length); ++i) {
            if (parts1[i] == parts2[i]) continue;
            return Integer.compare(parts1[i], parts2[i]);
        }
        return Integer.compare(parts1.length, parts2.length);
    }

    public static boolean isNewer(String version1, String version2) {
        return VersionComparator.compare(version1, version2) > 0;
    }

    private static int[] parseVersion(String version) {
        Matcher matcher = VERSION_PATTERN.matcher(version);
        if (matcher.find()) {
            int[] parts = new int[matcher.groupCount()];
            for (int i = 0; i < parts.length; ++i) {
                try {
                    parts[i] = Integer.parseInt(matcher.group(i + 1));
                    continue;
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
            return parts;
        }
        String[] strParts = version.split("\\.");
        int[] parts = new int[strParts.length];
        try {
            for (int i = 0; i < strParts.length; ++i) {
                parts[i] = Integer.parseInt(strParts[i]);
            }
            return parts;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }
}

