/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.client;

import com.craftingdead.core.ModDist;
import com.craftingdead.core.ServerConfig;
import com.craftingdead.core.client.ClientConfig;
import com.craftingdead.core.client.crosshair.CrosshairManager;
import com.craftingdead.core.client.gui.HitMarker;
import com.craftingdead.core.client.gui.IngameGui;
import com.craftingdead.core.client.gui.screen.inventory.CraftingScreen;
import com.craftingdead.core.client.gui.screen.inventory.EquipmentScreen;
import com.craftingdead.core.client.gui.screen.inventory.GenericContainerScreen;
import com.craftingdead.core.client.model.C4ExplosiveModel;
import com.craftingdead.core.client.model.CylinderGrenadeModel;
import com.craftingdead.core.client.model.FragGrenadeModel;
import com.craftingdead.core.client.model.SlimGrenadeModel;
import com.craftingdead.core.client.model.geom.ModModelLayers;
import com.craftingdead.core.client.particle.FlashParticle;
import com.craftingdead.core.client.particle.GrenadeSmokeParticle;
import com.craftingdead.core.client.renderer.CameraManager;
import com.craftingdead.core.client.renderer.entity.grenade.C4ExplosiveRenderer;
import com.craftingdead.core.client.renderer.entity.grenade.GrenadeRenderer;
import com.craftingdead.core.client.renderer.entity.layers.ClothingLayer;
import com.craftingdead.core.client.renderer.entity.layers.EquipmentLayer;
import com.craftingdead.core.client.renderer.entity.layers.HandcuffsLayer;
import com.craftingdead.core.client.renderer.entity.layers.ParachuteLayer;
import com.craftingdead.core.client.renderer.item.CustomItemRenderer;
import com.craftingdead.core.client.renderer.item.GunRenderer;
import com.craftingdead.core.client.renderer.item.ItemRenderDispatcher;
import com.craftingdead.core.client.sounds.EffectsManager;
import com.craftingdead.core.client.tutorial.ModTutorialStepInstance;
import com.craftingdead.core.client.tutorial.ModTutorialSteps;
import com.craftingdead.core.client.updater.UpdaterEventHandler;
import com.craftingdead.core.client.util.RenderUtil;
import com.craftingdead.core.event.RenderArmClothingEvent;
import com.craftingdead.core.network.NetworkChannel;
import com.craftingdead.core.network.message.play.DamageHandcuffsMessage;
import com.craftingdead.core.network.message.play.OpenEquipmentMenuMessage;
import com.craftingdead.core.network.message.play.TraumaPacket;
import com.craftingdead.core.particle.ModParticleTypes;
import com.craftingdead.core.trauma.TraumaSeverity;
import com.craftingdead.core.util.MutableVector2f;
import com.craftingdead.core.world.action.RemoveMagazineAction;
import com.craftingdead.core.world.action.reload.AbstractReloadAction;
import com.craftingdead.core.world.effect.ModMobEffects;
import com.craftingdead.core.world.entity.ModEntityTypes;
import com.craftingdead.core.world.entity.extension.LivingExtension;
import com.craftingdead.core.world.entity.extension.PlayerExtension;
import com.craftingdead.core.world.entity.grenade.FlashGrenadeEntity;
import com.craftingdead.core.world.inventory.ModMenuTypes;
import com.craftingdead.core.world.item.ArbitraryTooltips;
import com.craftingdead.core.world.item.GunItem;
import com.craftingdead.core.world.item.MeleeWeaponItem;
import com.craftingdead.core.world.item.ModAxeItem;
import com.craftingdead.core.world.item.ModPickaxeItem;
import com.craftingdead.core.world.item.ModShovelItem;
import com.craftingdead.core.world.item.RegisterGunColor;
import com.craftingdead.core.world.item.equipment.Clothing;
import com.craftingdead.core.world.item.equipment.Equipment;
import com.craftingdead.core.world.item.gun.Gun;
import com.craftingdead.core.world.item.gun.skin.Paint;
import com.craftingdead.core.world.item.gun.skin.Skins;
import com.craftingdead.core.world.item.scope.Scope;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import net.minecraft.Util;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.PostChain;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.tutorial.Tutorial;
import net.minecraft.client.tutorial.TutorialSteps;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.ClientRegistry;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.FOVModifierEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.ParticleFactoryRegisterEvent;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.client.event.ScreenOpenEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.event.sound.SoundLoadEvent;
import net.minecraftforge.client.gui.ForgeIngameGui;
import net.minecraftforge.client.gui.IIngameOverlay;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.util.thread.EffectiveSide;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class ClientDist
implements ModDist {
    private static final Set<String> gunPoseBlacklist = Set.of("de.maxhenkel.corpse.entities.DummyPlayer", "de.maxhenkel.corpse.entities.DummySkeleton");
    public static final KeyMapping RELOAD = new KeyMapping("key.reload", 82, "key.categories.craftingdead");
    public static final KeyMapping REMOVE_MAGAZINE = new KeyMapping("key.remove_magazine", 74, "key.categories.craftingdead");
    public static final KeyMapping TOGGLE_FIRE_MODE = new KeyMapping("key.toggle_fire_mode", 86, "key.categories.craftingdead");
    public static final KeyMapping OPEN_EQUIPMENT_MENU = new KeyMapping("key.equipment_menu", 90, "key.categories.craftingdead");
    public static final ClientConfig clientConfig;
    public static final ForgeConfigSpec clientConfigSpec;
    private static final ResourceLocation ADRENALINE_SHADER;
    private static final Vector3f mutableCameraRotations;
    private static final MutableVector2f FOV;
    private static final int DOUBLE_CLICK_DURATION = 500;
    private final Minecraft minecraft;
    private final CrosshairManager crosshairManager;
    private final IngameGui ingameGui;
    private final ItemRenderDispatcher itemRenderDispatcher;
    private final CameraManager cameraManager;
    private EffectsManager effectsManager;
    private TutorialSteps lastTutorialStep;
    private long adrenalineShaderStartTime = 0L;
    private boolean wasAdrenalineActive;
    private boolean wasSneaking;
    private long lastSneakPressTime;
    private float lastPitch;
    private float lastYaw;
    private float lastRoll;
    private int traumaAimTicks;
    private float traumaAimStrength;
    private TraumaSeverity lastTraumaSeverity = TraumaSeverity.NONE;

    public ClientDist() {
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        modBus.addListener(this::handleClientSetup);
        modBus.addListener(this::handleParticleFactoryRegisterEvent);
        modBus.addListener(this::handleItemColor);
        modBus.addListener(this::handleTextureStitch);
        modBus.addListener(this::handleSoundLoad);
        modBus.addListener(this::handleConfigReloading);
        modBus.addListener(this::handleEntityRenderers);
        modBus.addListener(this::handleEntityRenderersAddLayers);
        modBus.addListener(this::handleEntityRenderersLayerDefinitions);
        modBus.addListener(this::handleRegisterClientReloadListeners);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new UpdaterEventHandler());
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)clientConfigSpec);
        this.minecraft = Minecraft.m_91087_();
        this.crosshairManager = new CrosshairManager();
        this.itemRenderDispatcher = new ItemRenderDispatcher();
        this.ingameGui = new IngameGui(this.minecraft, this, new ResourceLocation((String)ClientDist.clientConfig.crosshair.get()));
        this.cameraManager = new CameraManager();
    }

    @Override
    public RegistryAccess registryAccess() {
        Minecraft minecraft = Minecraft.m_91087_();
        if (EffectiveSide.get().isServer() && minecraft.m_91092_() != null) {
            return minecraft.m_91092_().m_206579_();
        }
        if (EffectiveSide.get().isClient() && minecraft.f_91074_ != null) {
            return minecraft.f_91074_.f_108617_.m_105152_();
        }
        return ModDist.super.registryAccess();
    }

    public void setTutorialStep(ModTutorialSteps step) {
        ClientDist.clientConfig.tutorialStep.set((Object)step);
        Tutorial tutorial = this.minecraft.m_91301_();
        tutorial.m_120588_(TutorialSteps.NONE);
        tutorial.f_120560_ = step.create(this);
    }

    public CrosshairManager getCrosshairManager() {
        return this.crosshairManager;
    }

    public IngameGui getIngameGui() {
        return this.ingameGui;
    }

    public CameraManager getCameraManager() {
        return this.cameraManager;
    }

    public ItemRenderDispatcher getItemRendererManager() {
        return this.itemRenderDispatcher;
    }

    public Minecraft getMinecraft() {
        return this.minecraft;
    }

    public Optional<PlayerExtension<LocalPlayer>> getPlayerExtension() {
        return this.minecraft.f_91074_ == null ? Optional.empty() : Optional.ofNullable(PlayerExtension.get(this.minecraft.f_91074_));
    }

    public boolean isRightMouseDown() {
        return this.minecraft.f_91066_.f_92095_.m_90857_();
    }

    public boolean isLocalPlayer(Entity entity) {
        return entity == this.minecraft.f_91074_;
    }

    public void handleHit(Vec3 hitPos, boolean dead) {
        SoundEvent soundEvent;
        ((HitMarker.Mode)((Object)ServerConfig.instance.hitMarkerMode.get())).createHitMarker(hitPos, dead).ifPresent(this.ingameGui::setHitMarker);
        if (dead && ((Boolean)ServerConfig.instance.killSoundEnabled.get()).booleanValue() && (soundEvent = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation((String)ClientDist.clientConfig.killSound.get()))) != null) {
            this.minecraft.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)soundEvent, (float)5.0f, (float)0.3f));
        }
    }

    public void handleTrauma(TraumaPacket packet) {
        this.lastTraumaSeverity = packet.severity();
        this.traumaAimTicks = Math.max(this.traumaAimTicks, packet.aimSwayTicks());
        this.traumaAimStrength = Math.max(this.traumaAimStrength, packet.aimSwayStrength());
        if (this.minecraft.f_91065_ != null && packet.severity() != TraumaSeverity.NONE) {
            String translationKey = "message.craftingdead.trauma." + packet.severity().name().toLowerCase(Locale.ROOT);
            this.minecraft.f_91065_.m_93063_((Component)new TranslatableComponent(translationKey), false);
        }
    }

    @Nullable
    public PlayerExtension<AbstractClientPlayer> getCameraPlayer() {
        PlayerExtension<AbstractClientPlayer> playerExtension;
        Entity entity = this.minecraft.m_91288_();
        if (entity instanceof AbstractClientPlayer) {
            AbstractClientPlayer player = (AbstractClientPlayer)entity;
            playerExtension = PlayerExtension.get(player);
        } else {
            playerExtension = null;
        }
        return playerExtension;
    }

    private void handleRegisterClientReloadListeners(RegisterClientReloadListenersEvent event) {
        event.registerReloadListener((PreparableReloadListener)this.crosshairManager);
        event.registerReloadListener((PreparableReloadListener)this.itemRenderDispatcher);
    }

    @SubscribeEvent
    public void handleSoundLoad(SoundLoadEvent event) {
        this.effectsManager = new EffectsManager(event.getEngine());
    }

    private void handleConfigReloading(ModConfigEvent.Reloading event) {
        if (event.getConfig().getSpec() == clientConfigSpec) {
            this.ingameGui.setCrosshairLocation(new ResourceLocation((String)ClientDist.clientConfig.crosshair.get()));
        }
    }

    private void handleClientSetup(FMLClientSetupEvent event) {
        MenuScreens.m_96206_((MenuType)((MenuType)ModMenuTypes.EQUIPMENT.get()), EquipmentScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)ModMenuTypes.CRAFTING.get()), CraftingScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)ModMenuTypes.VEST.get()), GenericContainerScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)ModMenuTypes.SMALL_BACKPACK.get()), GenericContainerScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)ModMenuTypes.MEDIUM_BACKPACK.get()), GenericContainerScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)ModMenuTypes.LARGE_BACKPACK.get()), GenericContainerScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)ModMenuTypes.GUN_BAG.get()), GenericContainerScreen::new);
        ClientRegistry.registerKeyBinding((KeyMapping)TOGGLE_FIRE_MODE);
        ClientRegistry.registerKeyBinding((KeyMapping)RELOAD);
        ClientRegistry.registerKeyBinding((KeyMapping)REMOVE_MAGAZINE);
        ClientRegistry.registerKeyBinding((KeyMapping)OPEN_EQUIPMENT_MENU);
        ArbitraryTooltips.registerAll();
    }

    private void handleEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)ModEntityTypes.C4_EXPLOSIVE.get(), C4ExplosiveRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntityTypes.FIRE_GRENADE.get(), GrenadeRenderer.cylinder());
        event.registerEntityRenderer((EntityType)ModEntityTypes.FRAG_GRENADE.get(), GrenadeRenderer.frag());
        event.registerEntityRenderer((EntityType)ModEntityTypes.DECOY_GRENADE.get(), GrenadeRenderer.slim());
        event.registerEntityRenderer((EntityType)ModEntityTypes.SMOKE_GRENADE.get(), GrenadeRenderer.cylinder());
        event.registerEntityRenderer((EntityType)ModEntityTypes.FLASH_GRENADE.get(), GrenadeRenderer.slim());
    }

    private void handleEntityRenderersAddLayers(EntityRenderersEvent.AddLayers event) {
        for (String skin : event.getSkins()) {
            PlayerRenderer renderer = (PlayerRenderer)event.getSkin(skin);
            renderer.m_115326_(new ParachuteLayer(renderer, event.getEntityModels()));
            renderer.m_115326_(new HandcuffsLayer(renderer, event.getEntityModels()));
            renderer.m_115326_(new ClothingLayer(renderer));
            renderer.m_115326_(EquipmentLayer.builder(renderer).slot(Equipment.Slot.MELEE).useCrouchOrientation(true).build());
            renderer.m_115326_(EquipmentLayer.builder(renderer).slot(Equipment.Slot.VEST).useCrouchOrientation(true).build());
            renderer.m_115326_(EquipmentLayer.builder(renderer).slot(Equipment.Slot.HAT).useHeadOrientation(true).transformation(poseStack -> poseStack.m_85841_(-1.0f, -1.0f, 1.0f)).build());
            renderer.m_115326_(EquipmentLayer.builder(renderer).slot(Equipment.Slot.GUN).useCrouchOrientation(true).build());
            renderer.m_115326_(EquipmentLayer.builder(renderer).slot(Equipment.Slot.BACKPACK).useCrouchOrientation(true).build());
        }
    }

    private void handleEntityRenderersLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(ModModelLayers.MUZZLE_FLASH, GunRenderer::createMuzzleFlashBodyLayer);
        event.registerLayerDefinition(ModModelLayers.PARACHUTE, ParachuteLayer::createParachuteBodyLayer);
        event.registerLayerDefinition(ModModelLayers.HANDCUFFS, HandcuffsLayer::createHandcuffsBodyLayer);
        event.registerLayerDefinition(ModModelLayers.C4_EXPLOSIVE, C4ExplosiveModel::createBodyLayer);
        event.registerLayerDefinition(ModModelLayers.CYLINDER_GRENADE, CylinderGrenadeModel::createBodyLayer);
        event.registerLayerDefinition(ModModelLayers.FRAG_GRENADE, FragGrenadeModel::createBodyLayer);
        event.registerLayerDefinition(ModModelLayers.SLIM_GRENADE, SlimGrenadeModel::createBodyLayer);
    }

    private void handleParticleFactoryRegisterEvent(ParticleFactoryRegisterEvent event) {
        ParticleEngine particleEngine = this.minecraft.f_91061_;
        particleEngine.m_107378_((ParticleType)ModParticleTypes.GRENADE_SMOKE.get(), GrenadeSmokeParticle.Factory::new);
        particleEngine.m_107378_((ParticleType)ModParticleTypes.RGB_FLASH.get(), FlashParticle.Factory::new);
    }

    private void handleItemColor(ColorHandlerEvent.Item event) {
        ItemColor gunColour = (itemStack, tintIndex) -> itemStack.getCapability(Gun.CAPABILITY).resolve().flatMap(gun -> gun.getPaintStack().getCapability(Paint.CAPABILITY).resolve()).stream().flatMapToInt(paint -> paint.getColor().stream()).findAny().orElse(-1);
        ForgeRegistries.ITEMS.getValues().stream().filter(item -> item.getClass().isAnnotationPresent(RegisterGunColor.class)).forEach(item -> event.getItemColors().m_92689_(gunColour, new ItemLike[]{item}));
    }

    private void handleTextureStitch(TextureStitchEvent.Pre event) {
        this.itemRenderDispatcher.getTextures(event.getAtlas().m_118330_()).forEach(arg_0 -> ((TextureStitchEvent.Pre)event).addSprite(arg_0));
        if (event.getAtlas().m_118330_().equals((Object)InventoryMenu.f_39692_)) {
            Skins.REGISTRY.m_123024_().flatMap(skin -> skin.getAcceptedGuns().stream().map(skin::getTextureLocation)).forEach(arg_0 -> ((TextureStitchEvent.Pre)event).addSprite(arg_0));
        }
    }

    @SubscribeEvent
    public void handleTooltipEvent(ItemTooltipEvent event) {
        Item item = event.getItemStack().m_41720_();
        Collection<ArbitraryTooltips.TooltipFunction> functions = ArbitraryTooltips.getFunctions(event.getItemStack().m_41720_());
        int lineIndex = 1;
        if (item instanceof MeleeWeaponItem || item instanceof ModAxeItem || item instanceof ModPickaxeItem || item instanceof ModShovelItem) {
            this.cleanUpToolTip(event.getToolTip());
        }
        for (ArbitraryTooltips.TooltipFunction function : functions) {
            Level level;
            Level level2 = level = event.getEntity() != null ? event.getEntity().m_183503_() : null;
            Component tooltip = function.createTooltip(event.getItemStack(), level, event.getFlags());
            if (tooltip == null) continue;
            event.getToolTip().add(lineIndex++, tooltip);
        }
    }

    @SubscribeEvent
    public void handleClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        PlayerExtension player = this.getPlayerExtension().orElse(null);
        if (player != null) {
            if (this.traumaAimTicks > 0) {
                --this.traumaAimTicks;
                float severityMultiplier = 1.0f + (float)this.lastTraumaSeverity.ordinal() * 0.25f;
                this.cameraManager.randomRecoil(this.traumaAimStrength * severityMultiplier, false);
            } else if (this.lastTraumaSeverity != TraumaSeverity.NONE) {
                this.lastTraumaSeverity = TraumaSeverity.NONE;
                this.traumaAimStrength = 0.0f;
            }
            Gun gun = (Gun)player.mainHandGun().orElse(null);
            boolean levelFocused = !this.minecraft.m_91104_() && this.minecraft.m_91265_() == null && this.minecraft.f_91080_ == null;
            this.cameraManager.tick();
            if (!levelFocused || ((LocalPlayer)player.entity()).m_5833_()) {
                if (gun != null) {
                    if (gun.isTriggerPressed()) {
                        gun.setTriggerPressed(player, false, true);
                    }
                    if (gun.isPerformingSecondaryAction()) {
                        gun.setPerformingSecondaryAction(player, false, true);
                    }
                }
                return;
            }
            if (gun != null) {
                while (TOGGLE_FIRE_MODE.m_90859_()) {
                    gun.toggleFireMode(player, true);
                }
                while (RELOAD.m_90859_()) {
                    gun.getAmmoProvider().reload(player);
                }
                while (REMOVE_MAGAZINE.m_90859_()) {
                    gun.getAmmoProvider().unload(player);
                }
            }
            if (this.minecraft.f_91074_.m_6144_() != this.wasSneaking) {
                if (this.minecraft.f_91074_.m_6144_()) {
                    long currentTime = Util.m_137550_();
                    if (currentTime - this.lastSneakPressTime <= 500L) {
                        player.setCrouching(true, true);
                    }
                    this.lastSneakPressTime = Util.m_137550_();
                } else {
                    player.setCrouching(false, true);
                }
                this.wasSneaking = this.minecraft.f_91074_.m_6144_();
            }
            while (OPEN_EQUIPMENT_MENU.m_90859_()) {
                if (player.isHandcuffed()) continue;
                NetworkChannel.PLAY.getSimpleChannel().sendToServer((Object)new OpenEquipmentMenuMessage());
                if (!(this.minecraft.m_91301_().f_120560_ instanceof ModTutorialStepInstance)) continue;
                ((ModTutorialStepInstance)this.minecraft.m_91301_().f_120560_).openEquipmentMenu();
            }
            TutorialSteps currentTutorialStep = this.minecraft.f_91066_.f_92030_;
            if (this.lastTutorialStep != currentTutorialStep) {
                if (currentTutorialStep == TutorialSteps.NONE) {
                    this.setTutorialStep((ModTutorialSteps)((Object)ClientDist.clientConfig.tutorialStep.get()));
                }
                this.lastTutorialStep = currentTutorialStep;
            }
            if (this.minecraft.f_91074_.m_21023_((MobEffect)ModMobEffects.ADRENALINE.get())) {
                this.wasAdrenalineActive = true;
                this.effectsManager.setHighpassLevels(1.0f, 0.015f);
                this.effectsManager.setDirectHighpassForAll();
            } else if (this.wasAdrenalineActive) {
                this.wasAdrenalineActive = false;
                this.effectsManager.removeFilterForAll();
            }
        }
    }

    @SubscribeEvent
    public void handleRawMouse(InputEvent.RawMouseEvent event) {
        PlayerExtension player = this.getPlayerExtension().orElse(null);
        if (player == null || this.minecraft.m_91265_() != null || this.minecraft.f_91080_ != null || ((LocalPlayer)player.entity()).m_5833_()) {
            return;
        }
        Gun gun = (Gun)player.mainHandGun().orElse(null);
        boolean isReloadingOrUnloading = player.getAction().filter(action -> action instanceof AbstractReloadAction || action instanceof RemoveMagazineAction).isPresent();
        if (this.minecraft.f_91066_.f_92096_.m_90830_(event.getButton())) {
            boolean triggerPressed;
            boolean bl = triggerPressed = event.getAction() == 1;
            if (gun != null) {
                if (triggerPressed) {
                    event.setCanceled(true);
                }
                gun.setTriggerPressed(player, triggerPressed, true);
            }
        } else if (this.minecraft.f_91066_.f_92095_.m_90830_(event.getButton()) && gun != null) {
            switch (gun.getSecondaryActionTrigger()) {
                case HOLD: {
                    gun.setPerformingSecondaryAction(player, event.getAction() == 1, true);
                    break;
                }
                case TOGGLE: {
                    if (event.getAction() != 1 || isReloadingOrUnloading) break;
                    gun.setPerformingSecondaryAction(player, !gun.isPerformingSecondaryAction(), true);
                }
            }
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void handleRenderLiving(RenderLivingEvent.Pre<?, ?> event) {
        ItemStack heldStack = event.getEntity().m_21205_();
        EntityModel entityModel = event.getRenderer().m_7200_();
        if (entityModel instanceof HumanoidModel) {
            HumanoidModel model = (HumanoidModel)entityModel;
            if (heldStack.m_41720_() instanceof GunItem && !gunPoseBlacklist.contains(event.getEntity().getClass().getName())) {
                switch (event.getEntity().m_5737_()) {
                    case LEFT: {
                        model.f_102815_ = HumanoidModel.ArmPose.BOW_AND_ARROW;
                        break;
                    }
                    case RIGHT: {
                        model.f_102816_ = HumanoidModel.ArmPose.BOW_AND_ARROW;
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void handleRenderGameOverlayPreLayer(RenderGameOverlayEvent.PreLayer event) {
        PlayerExtension<AbstractClientPlayer> player = this.getCameraPlayer();
        if (player == null) {
            return;
        }
        IIngameOverlay overlay = event.getOverlay();
        if (overlay == ForgeIngameGui.PLAYER_HEALTH_ELEMENT || overlay == ForgeIngameGui.HOTBAR_ELEMENT || overlay == ForgeIngameGui.EXPERIENCE_BAR_ELEMENT || overlay == ForgeIngameGui.MOUNT_HEALTH_ELEMENT || overlay == ForgeIngameGui.FOOD_LEVEL_ELEMENT || overlay == ForgeIngameGui.AIR_LEVEL_ELEMENT || overlay == ForgeIngameGui.ARMOR_LEVEL_ELEMENT) {
            event.setCanceled(player.isCombatModeEnabled());
        } else if (overlay == ForgeIngameGui.CROSSHAIR_ELEMENT) {
            Boolean aiming = player.mainHandItem().getCapability(Scope.CAPABILITY).map(scope -> scope.isScoping(player)).orElse(false);
            if (player.getActionObserver().map(observer -> observer.getProgressBar().isPresent()).orElse(false).booleanValue() || aiming.booleanValue() || player.isHandcuffed()) {
                event.setCanceled(true);
                return;
            }
            player.mainHandGun().ifPresent(gun -> {
                event.setCanceled(true);
                if (gun.getClient().isCrosshairEnabled()) {
                    this.ingameGui.renderCrosshairs(event.getMatrixStack(), gun.getAccuracy(player), event.getPartialTicks(), event.getWindow().m_85445_(), event.getWindow().m_85446_());
                }
            });
        }
    }

    @SubscribeEvent
    public void handleRenderGameOverlayPre(RenderGameOverlayEvent.Pre event) {
        PlayerExtension<AbstractClientPlayer> player = this.getCameraPlayer();
        if (player == null) {
            return;
        }
        ItemStack heldStack = player.mainHandItem();
        Gun gun = (Gun)heldStack.getCapability(Gun.CAPABILITY).orElse(null);
        switch (event.getType()) {
            case ALL: {
                this.ingameGui.renderOverlay(player, heldStack, gun, event.getMatrixStack(), event.getWindow().m_85445_(), event.getWindow().m_85446_(), event.getPartialTicks());
                break;
            }
        }
    }

    @SubscribeEvent
    public void handleCameraSetup(EntityViewRenderEvent.CameraSetup event) {
        LivingEntity livingEntity;
        ItemStack itemStack;
        CustomItemRenderer itemRenderer;
        this.cameraManager.getCameraRotations((float)event.getPartialTicks(), mutableCameraRotations);
        Entity entity = this.minecraft.f_91075_;
        if (entity instanceof LivingEntity && (itemRenderer = this.itemRenderDispatcher.getItemRenderer((itemStack = (livingEntity = (LivingEntity)entity).m_21205_()).m_41720_())) != null) {
            itemRenderer.rotateCamera(itemStack, livingEntity, (float)event.getPartialTicks(), mutableCameraRotations);
        }
        this.lastPitch = Mth.m_14179_((float)0.1f, (float)this.lastPitch, (float)mutableCameraRotations.m_122239_());
        this.lastYaw = Mth.m_14179_((float)0.1f, (float)this.lastYaw, (float)mutableCameraRotations.m_122260_());
        this.lastRoll = Mth.m_14179_((float)0.1f, (float)this.lastRoll, (float)mutableCameraRotations.m_122269_());
        mutableCameraRotations.m_122245_(0.0f, 0.0f, 0.0f);
        event.setPitch(event.getPitch() + this.lastPitch);
        event.setYaw(event.getYaw() + this.lastYaw);
        event.setRoll(event.getRoll() + this.lastRoll);
    }

    @SubscribeEvent
    public void handeFOVModifier(FOVModifierEvent event) {
        Scope scope;
        PlayerExtension<AbstractClientPlayer> player = this.getCameraPlayer();
        if (player != null && (scope = (Scope)((AbstractClientPlayer)player.entity()).m_21205_().getCapability(Scope.CAPABILITY).orElse(null)) != null && scope.isScoping(player)) {
            event.setNewfov(1.0f / scope.getZoomMultiplier(player));
        }
        event.setNewfov(event.getNewfov() + this.cameraManager.getFov(this.minecraft.m_91296_()));
    }

    @SubscribeEvent
    public void handleRenderTick(TickEvent.RenderTickEvent event) {
        switch (event.phase) {
            case START: {
                if (this.minecraft.f_91074_ == null) break;
                this.cameraManager.getLookRotationDelta(FOV);
                this.minecraft.f_91074_.m_19884_((double)FOV.getY(), (double)FOV.getX());
                break;
            }
            case END: {
                if (this.minecraft.f_91074_ == null) break;
                this.updateAdrenalineShader(event.renderTickTime);
                if (this.minecraft.f_91080_ != null) break;
                this.ingameGui.renderFlashBangOverlay((Player)this.minecraft.f_91074_, new PoseStack(), this.minecraft.m_91268_().m_85445_(), this.minecraft.m_91268_().m_85446_(), event.renderTickTime);
            }
        }
    }

    @SubscribeEvent
    public void handleRenderScreen(ScreenEvent.DrawScreenEvent.Pre event) {
        if (this.minecraft.f_91074_ != null) {
            this.ingameGui.renderFlashBangOverlay((Player)this.minecraft.f_91074_, new PoseStack(), this.minecraft.m_91268_().m_85445_(), this.minecraft.m_91268_().m_85446_(), event.getPartialTicks());
        }
    }

    private void updateAdrenalineShader(float partialTicks) {
        boolean shaderLoaded;
        GameRenderer gameRenderer = this.minecraft.f_91063_;
        boolean bl = shaderLoaded = gameRenderer.m_109149_() != null && gameRenderer.m_109149_().m_110022_().equals(ADRENALINE_SHADER.toString());
        if (this.minecraft.f_91074_.m_21023_((MobEffect)ModMobEffects.ADRENALINE.get())) {
            long currentTime = Util.m_137550_();
            if (this.adrenalineShaderStartTime == 0L) {
                this.adrenalineShaderStartTime = currentTime;
            }
            float progress = Mth.m_14036_((float)(((float)(currentTime - this.adrenalineShaderStartTime) - partialTicks) / 5000.0f), (float)0.0f, (float)1.0f);
            if (!shaderLoaded) {
                if (gameRenderer.m_109149_() != null) {
                    gameRenderer.m_109086_();
                }
                gameRenderer.m_109128_(ADRENALINE_SHADER);
            }
            PostChain shaderGroup = gameRenderer.m_109149_();
            RenderUtil.updateUniform("Saturation", progress * 0.25f, shaderGroup);
        } else if (shaderLoaded) {
            this.adrenalineShaderStartTime = 0L;
            gameRenderer.m_109086_();
        }
    }

    @SubscribeEvent
    public void handleScreenOpen(ScreenOpenEvent event) {
        if (this.minecraft == null || this.minecraft.f_91074_ == null) {
            return;
        }
        LocalPlayer player = this.minecraft.f_91074_;
        PlayerExtension<LocalPlayer> playerExtension = PlayerExtension.get(player);
        Screen screen = this.minecraft.f_91080_;
        if (screen instanceof EquipmentScreen) {
            EquipmentScreen screen2 = (EquipmentScreen)screen;
            if (event.getScreen() == null && screen2.isTransitioning()) {
                event.setCanceled(true);
            }
        }
        if (playerExtension != null && playerExtension.isHandcuffed() && event.getScreen() instanceof InventoryScreen && this.isSurvivalMode()) {
            event.setCanceled(true);
            return;
        }
    }

    @SubscribeEvent
    public void handleRenderHand(RenderHandEvent event) {
        LocalPlayer player = this.minecraft.f_91074_;
        PlayerExtension<AbstractClientPlayer> cameraPlayer = this.getCameraPlayer();
        if (cameraPlayer != null) {
            event.setCanceled(cameraPlayer.isHandcuffed());
        }
        if (player != null && player.m_21023_((MobEffect)ModMobEffects.PARACHUTE.get())) {
            this.renderParachute(event.getPoseStack(), event.getMultiBufferSource(), event.getPackedLight());
        }
    }

    @SubscribeEvent
    public void handleClickInput(InputEvent.ClickInputEvent event) {
        PlayerExtension<AbstractClientPlayer> player = this.getCameraPlayer();
        if (player != null && player.isHandcuffed()) {
            event.setSwingHand(false);
        }
    }

    @SubscribeEvent
    public void onMouseInput(InputEvent.MouseInputEvent event) {
        if (this.minecraft.f_91066_.f_92095_.m_90830_(event.getButton()) && event.getAction() == 1 && this.minecraft.f_91074_ != null && this.minecraft.f_91080_ == null) {
            NetworkChannel.PLAY.getSimpleChannel().sendToServer((Object)new DamageHandcuffsMessage());
        }
    }

    @SubscribeEvent
    public void onKeyInput(InputEvent.KeyInputEvent event) {
        if (this.minecraft.f_91066_.f_92095_.m_90832_(event.getKey(), event.getScanCode()) && event.getAction() == 1 && this.minecraft.f_91074_ != null && this.minecraft.f_91080_ == null) {
            NetworkChannel.PLAY.getSimpleChannel().sendToServer((Object)new DamageHandcuffsMessage());
        }
    }

    public void checkApplyFlashEffects(FlashGrenadeEntity flashGrenadeEntity) {
        int duration = flashGrenadeEntity.calculateDuration((LivingEntity)this.minecraft.f_91074_, RenderUtil.isInsideFrustum(flashGrenadeEntity, false));
        if (duration > 0) {
            MobEffectInstance flashEffect = new MobEffectInstance((MobEffect)ModMobEffects.FLASH_BLINDNESS.get(), duration);
            ModMobEffects.applyOrOverrideIfLonger((LivingEntity)this.minecraft.f_91074_, flashEffect);
        }
    }

    public static void renderArmWithClothing(PlayerRenderer renderer, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, AbstractClientPlayer playerEntity, ModelPart arm, ModelPart sleeve) {
        ResourceLocation clothingTexture = playerEntity.getCapability(LivingExtension.CAPABILITY).resolve().flatMap(living -> living.getEquipmentInSlot(Equipment.Slot.CLOTHING, Clothing.class)).map(clothing -> clothing.getTexture(playerEntity.m_108564_())).orElse(null);
        RenderArmClothingEvent event = new RenderArmClothingEvent(playerEntity, clothingTexture);
        MinecraftForge.EVENT_BUS.post((Event)event);
        clothingTexture = event.getClothingTexture();
        if (clothingTexture != null) {
            PlayerModel model = (PlayerModel)renderer.m_7200_();
            model.f_102608_ = 0.0f;
            model.f_102817_ = false;
            model.f_102818_ = 0.0f;
            model.m_6973_((LivingEntity)playerEntity, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
            arm.f_104207_ = true;
            sleeve.f_104207_ = true;
            arm.f_104203_ = 0.0f;
            arm.m_104301_(poseStack, bufferSource.m_6299_(RenderType.m_110473_((ResourceLocation)clothingTexture)), packedLight, OverlayTexture.f_118083_);
            sleeve.f_104203_ = 0.0f;
            sleeve.m_104301_(poseStack, bufferSource.m_6299_(RenderType.m_110473_((ResourceLocation)clothingTexture)), packedLight, OverlayTexture.f_118083_);
        }
    }

    private void renderParachute(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, -1.08, -1.0);
        poseStack.m_85845_(Vector3f.f_122223_.m_122240_(180.0f));
        VertexConsumer vertexConsumer = ItemRenderer.m_115184_((MultiBufferSource)bufferSource, (RenderType)RenderType.m_110431_((ResourceLocation)new ResourceLocation("craftingdead", "textures/entity/parachute.png")), (boolean)false, (boolean)false);
        EntityModelSet entityModelSet = Minecraft.m_91087_().m_167973_();
        ModelPart parachuteModel = entityModelSet.m_171103_(ModModelLayers.PARACHUTE);
        parachuteModel.m_104301_(poseStack, vertexConsumer, packedLight, OverlayTexture.f_118083_);
        poseStack.m_85849_();
    }

    private boolean isSurvivalMode() {
        return this.minecraft.f_91074_ != null && !this.minecraft.f_91074_.m_150110_().f_35937_ && !this.minecraft.f_91074_.m_5833_();
    }

    private void cleanUpToolTip(List<Component> toolTip) {
        toolTip.removeIf(component -> {
            String text = component.getString();
            return text.contains("When in Main Hand:") || text.contains("Attack Damage") || text.contains("Attack Knockback") || text.contains("Attack Speed") || text.isBlank();
        });
    }

    static {
        Pair clientConfigPair = new ForgeConfigSpec.Builder().configure(ClientConfig::new);
        clientConfigSpec = (ForgeConfigSpec)clientConfigPair.getRight();
        clientConfig = (ClientConfig)clientConfigPair.getLeft();
        ADRENALINE_SHADER = new ResourceLocation("craftingdead", "shaders/post/adrenaline.json");
        mutableCameraRotations = new Vector3f();
        FOV = new MutableVector2f();
    }
}

