/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.world.item.gun.aimable;

import com.craftingdead.core.ServerConfig;
import com.craftingdead.core.world.entity.extension.LivingExtension;
import com.craftingdead.core.world.item.GunItem;
import com.craftingdead.core.world.item.gun.AbstractGunClient;
import com.craftingdead.core.world.item.gun.AimAttributes;
import com.craftingdead.core.world.item.gun.TypedGun;
import com.craftingdead.core.world.item.gun.aimable.AimableGunClient;
import com.craftingdead.core.world.item.gun.attachment.Attachment;
import com.craftingdead.core.world.item.scope.Scope;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class AimableGun
extends TypedGun
implements Scope {
    private boolean waitingForBoltAction;

    public AimableGun(ItemStack itemStack, GunItem item) {
        super(itemStack, item);
    }

    @Override
    protected AbstractGunClient<?> createClient() {
        return new AimableGunClient<AimableGun>(this);
    }

    @Override
    public void reset(LivingExtension<?, ?> living) {
        super.reset(living);
        this.waitingForBoltAction = false;
    }

    @Override
    public void tick(LivingExtension<?, ?> living) {
        long timeDelta = Util.m_137550_() - this.lastShotMs;
        if (timeDelta >= this.getFireDelayMs() && this.waitingForBoltAction) {
            this.waitingForBoltAction = false;
            if (!this.isPerformingSecondaryAction()) {
                this.setPerformingSecondaryAction(living, true, false);
            }
        }
        super.tick(living);
    }

    @Override
    protected void processShot(LivingExtension<?, ?> living) {
        super.processShot(living);
        Optional<AimAttributes> aimAttributes = this.getConfiguration().getAimSettings();
        if (this.isPerformingSecondaryAction() && aimAttributes.map(AimAttributes::boltAction).orElse(false).booleanValue()) {
            this.setPerformingSecondaryAction(living, false, false);
            this.waitingForBoltAction = true;
        }
    }

    @Override
    public boolean isScoping(LivingExtension<?, ?> living) {
        return this.isPerformingSecondaryAction();
    }

    @Override
    public float getZoomMultiplier(LivingExtension<?, ?> living) {
        return this.hasIronSight() ? 2.0f : this.getAttachmentMultiplier(Attachment.MultiplierType.ZOOM) + ((Double)ServerConfig.instance.scopeZoomMultiplier.get()).floatValue();
    }

    @Override
    public Optional<ResourceLocation> getOverlayTexture(LivingExtension<?, ?> living) {
        for (Attachment attachment : this.getAttachments().values()) {
            if (!attachment.isScope()) continue;
            return Optional.of(new ResourceLocation(attachment.getRegistryName().m_135827_(), "textures/scope/" + attachment.getRegistryName().m_135815_() + ".png"));
        }
        return Optional.empty();
    }

    @Override
    public void setPerformingSecondaryAction(LivingExtension<?, ?> living, boolean performingRightMouseAction, boolean sendUpdate) {
        if (!this.waitingForBoltAction) {
            super.setPerformingSecondaryAction(living, performingRightMouseAction, sendUpdate);
        }
    }

    @Override
    public int getOverlayTextureWidth() {
        return 2048;
    }

    @Override
    public int getOverlayTextureHeight() {
        return 512;
    }
}

