/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.world.item.gun;

import com.craftingdead.core.ServerConfig;
import com.mojang.serialization.Codec;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.IntSupplier;
import java.util.stream.Collectors;
import net.minecraft.util.StringRepresentable;
import net.minecraftforge.common.ForgeConfigSpec;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum FireMode implements StringRepresentable
{
    AUTO("auto"),
    BURST("burst", () -> ((ForgeConfigSpec.IntValue)ServerConfig.instance.burstfireShotsPerBurst).get()),
    SEMI("semi", () -> 1);

    public static final Codec<FireMode> CODEC;
    private static final Map<String, FireMode> BY_NAME;
    private final String name;
    @Nullable
    private final IntSupplier maxShots;

    private FireMode(String name) {
        this(name, null);
    }

    private FireMode(String name, IntSupplier maxShots) {
        this.name = name;
        this.maxShots = maxShots;
    }

    public String getTranslationKey() {
        return "fire_mode." + this.name;
    }

    public Optional<Integer> getMaxShots() {
        return this.maxShots == null ? Optional.empty() : Optional.of(this.maxShots.getAsInt());
    }

    @NotNull
    public String m_7912_() {
        return this.name;
    }

    public static FireMode byName(String name) {
        return BY_NAME.get(name);
    }

    static {
        CODEC = StringRepresentable.m_14350_(FireMode::values, FireMode::byName);
        BY_NAME = Arrays.stream(FireMode.values()).collect(Collectors.toMap(FireMode::m_7912_, Function.identity()));
    }
}

