/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.trauma;

import com.craftingdead.core.event.GunEvent;
import com.craftingdead.core.network.NetworkChannel;
import com.craftingdead.core.network.message.play.TraumaPacket;
import com.craftingdead.core.trauma.ProtectionConfig;
import com.craftingdead.core.trauma.ProtectionLookup;
import com.craftingdead.core.trauma.TraumaSeverity;
import com.craftingdead.core.world.entity.extension.LivingExtension;
import com.craftingdead.core.world.item.equipment.Equipment;
import com.mojang.logging.LogUtils;
import java.util.Locale;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.slf4j.Logger;

public final class TraumaHandler {
    public static final TraumaHandler INSTANCE = new TraumaHandler();
    private static final Logger LOGGER = LogUtils.getLogger();

    private TraumaHandler() {
    }

    @SubscribeEvent
    public void handleGunEntityDamaged(GunEvent.EntityDamaged event) {
        Entity entity;
        if (!event.headshot() || !((entity = event.target()) instanceof LivingEntity)) {
            return;
        }
        LivingEntity living = (LivingEntity)entity;
        if (living.m_183503_().m_5776_()) {
            return;
        }
        LivingExtension<LivingEntity, ?> target = LivingExtension.get(living);
        if (target == null) {
            return;
        }
        ProtectionConfig config = ProtectionConfig.get();
        ProtectionConfig.HeadTraumaSettings settings = config.headTrauma();
        if (!settings.enabled()) {
            return;
        }
        float incomingEnergy = Math.max(0.0f, event.damage() * settings.damageToEnergyScale());
        ProtectionLookup.HeadshotResult result = ProtectionLookup.INSTANCE.resolveHeadshot(target, incomingEnergy);
        if (LOGGER.isDebugEnabled()) {
            this.logHeadshotDebug(event, living, target, incomingEnergy, result);
        }
        ProtectionConfig.TraumaEffect effect = result.effect();
        if (result.severity() == TraumaSeverity.NONE || effect.isEmpty()) {
            return;
        }
        this.applyMobEffects(living, effect);
        if (living instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)living;
            NetworkChannel.PLAY.getSimpleChannel().send(PacketDistributor.PLAYER.with(() -> player), (Object)new TraumaPacket(result.severity(), effect.aimSwayTicks(), effect.aimSwayStrength()));
        }
    }

    private void applyMobEffects(LivingEntity living, ProtectionConfig.TraumaEffect effect) {
        if (effect.blindnessTicks() > 0) {
            living.m_7292_(new MobEffectInstance(MobEffects.f_19610_, effect.blindnessTicks()));
        }
        if (effect.nauseaTicks() > 0) {
            living.m_7292_(new MobEffectInstance(MobEffects.f_19604_, effect.nauseaTicks()));
        }
        if (effect.slownessTicks() > 0) {
            living.m_7292_(new MobEffectInstance(MobEffects.f_19597_, effect.slownessTicks(), Math.max(0, effect.slownessAmplifier())));
        }
    }

    private void logHeadshotDebug(GunEvent.EntityDamaged event, LivingEntity living, LivingExtension<?, ?> target, float incomingEnergy, ProtectionLookup.HeadshotResult result) {
        ItemStack helmetStack = target.getItemInSlot(Equipment.Slot.HAT);
        ItemStack vestStack = target.getItemInSlot(Equipment.Slot.VEST);
        ItemStack clothingStack = target.getItemInSlot(Equipment.Slot.CLOTHING);
        LOGGER.debug("Headshot trauma debug: target={}, weapon={}, rawDamage={}, incomingEnergy={}, severity={}, helmet={} absorbed={} durabilityLoss={}, vest={} absorbed={} durabilityLoss={}, clothing={} mitigated={}, remainingEnergy={}, helmetEquipped={}", new Object[]{living.m_7755_().getString(), TraumaHandler.describeItem(event.getItemStack()), TraumaHandler.formatFloat(event.damage()), TraumaHandler.formatFloat(incomingEnergy), result.severity(), TraumaHandler.describeItem(helmetStack), TraumaHandler.formatFloat(result.helmetAbsorbed()), result.helmetDurabilityLoss(), TraumaHandler.describeItem(vestStack), TraumaHandler.formatFloat(result.vestAbsorbed()), result.vestDurabilityLoss(), TraumaHandler.describeItem(clothingStack), TraumaHandler.formatFloat(result.clothingMitigated()), TraumaHandler.formatFloat(result.remainingEnergy()), result.helmetEquipped()});
    }

    private static String describeItem(ItemStack stack) {
        if (stack.m_41619_()) {
            return "empty";
        }
        ResourceLocation itemId = ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)stack.m_41720_());
        String idText = itemId != null ? itemId.toString() : "unknown";
        return stack.m_41613_() == 1 ? String.format(Locale.ROOT, "%s(dmg=%d)", idText, stack.m_41773_()) : String.format(Locale.ROOT, "%s x%d (dmg=%d)", idText, stack.m_41613_(), stack.m_41773_());
    }

    private static String formatFloat(float value) {
        return String.format(Locale.ROOT, "%.2f", Float.valueOf(value));
    }
}

