/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.network;

import java.util.Optional;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.common.util.LogicalSidedProvider;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class NetworkUtil {
    public static Entity getEntityOrSender(NetworkEvent.Context context, int entityId) {
        return NetworkUtil.getEntityOrSender(context, entityId, Entity.class);
    }

    public static <T extends Entity> T getEntityOrSender(NetworkEvent.Context context, int entityId, Class<T> clazz) {
        return switch (context.getDirection().getReceptionSide()) {
            case LogicalSide.CLIENT -> NetworkUtil.getEntity(context, entityId, clazz);
            case LogicalSide.SERVER -> {
                if (clazz.isInstance(context.getSender())) {
                    yield (Entity)clazz.cast(context.getSender());
                }
                throw new IllegalStateException("Sender is not instance of: " + clazz.getName());
            }
            default -> throw new IllegalStateException("Invalid side");
        };
    }

    public static Entity getEntity(NetworkEvent.Context context, int entityId) {
        return NetworkUtil.getEntity(context, entityId, Entity.class);
    }

    public static <T extends Entity> T getEntity(NetworkEvent.Context context, int entityId, Class<T> clazz) {
        return (T)((Optional)LogicalSidedProvider.CLIENTWORLD.get(context.getDirection().getReceptionSide())).map(level -> level.m_6815_(entityId)).filter(clazz::isInstance).map(clazz::cast).orElseThrow(() -> new IllegalStateException(String.format("Entity with ID %s of type %s is absent from client level", entityId, clazz.getName())));
    }
}

