/*
 * Decompiled with CFR 0.152.
 */
package com.craftingdead.core.client.gui.screen.inventory;

import com.craftingdead.core.client.ClientDist;
import com.craftingdead.core.client.gui.widget.button.CompositeButton;
import com.craftingdead.core.network.NetworkChannel;
import com.craftingdead.core.network.message.play.OpenCraftingMenuMessage;
import com.craftingdead.core.network.message.play.OpenStorageMessage;
import com.craftingdead.core.world.inventory.EquipmentMenu;
import com.craftingdead.core.world.item.ModItems;
import com.craftingdead.core.world.item.equipment.Equipment;
import com.craftingdead.core.world.item.gun.Gun;
import com.craftingdead.core.world.item.gun.skin.Paint;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.EffectRenderingInventoryScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuConstructor;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class EquipmentScreen
extends EffectRenderingInventoryScreen<EquipmentMenu> {
    private static final ResourceLocation BACKGROUND = new ResourceLocation("craftingdead", "textures/gui/container/equipment.png");
    private int oldMouseX;
    private int oldMouseY;
    private Button backpackButton;
    private Button vestButton;
    private boolean transitioning = false;

    public EquipmentScreen(EquipmentMenu menu, Inventory inventory, Component title) {
        super((AbstractContainerMenu)menu, inventory, title);
    }

    public void m_7856_() {
        super.m_7856_();
        this.vestButton = CompositeButton.button(this.f_97735_ + 95, this.f_97736_ + 44, 12, 16, BACKGROUND).setAtlasPos(196, 224).setHoverAtlasPos(196, 240).setInactiveAtlasPos(183, 240).setAction(button -> {
            NetworkChannel.PLAY.getSimpleChannel().sendToServer((Object)new OpenStorageMessage(Equipment.Slot.VEST));
            this.transitioning = true;
        }).build();
        this.m_142416_((GuiEventListener)this.vestButton);
        this.backpackButton = CompositeButton.button(this.f_97735_ + 95, this.f_97736_ + 62, 12, 16, BACKGROUND).setAtlasPos(196, 224).setHoverAtlasPos(196, 240).setInactiveAtlasPos(183, 240).setAction(button -> {
            NetworkChannel.PLAY.getSimpleChannel().sendToServer((Object)new OpenStorageMessage(Equipment.Slot.BACKPACK));
            this.transitioning = true;
        }).build();
        this.m_142416_((GuiEventListener)this.backpackButton);
        this.refreshButtonStatus();
    }

    public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        super.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        this.m_7025_(matrixStack, mouseX, mouseY);
        this.oldMouseX = mouseX;
        this.oldMouseY = mouseY;
    }

    protected void m_181908_() {
        super.m_181908_();
        this.refreshButtonStatus();
    }

    private void refreshButtonStatus() {
        this.backpackButton.f_93623_ = ((EquipmentMenu)this.f_97732_).getPlayer().getEquipmentInSlot(Equipment.Slot.BACKPACK).map(MenuConstructor.class::isInstance).orElse(false);
        this.vestButton.f_93623_ = ((EquipmentMenu)this.f_97732_).getPlayer().getEquipmentInSlot(Equipment.Slot.VEST).map(MenuConstructor.class::isInstance).orElse(false);
    }

    public boolean isTransitioning() {
        return this.transitioning;
    }

    protected void m_7027_(PoseStack matrixStack, int x, int y) {
    }

    protected void m_7286_(PoseStack poseStack, float partialTicks, int mouseX, int mouseY) {
        this.m_7333_(poseStack);
        RenderSystem.m_157456_((int)0, (ResourceLocation)BACKGROUND);
        this.m_93228_(poseStack, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
        for (int i = 35; i < ((EquipmentMenu)this.f_97732_).f_38839_.size(); ++i) {
            Slot slot = (Slot)((EquipmentMenu)this.f_97732_).f_38839_.get(i);
            if (!slot.m_6657_()) continue;
            this.m_93228_(poseStack, slot.f_40220_ + this.f_97735_, slot.f_40221_ + this.f_97736_, 8, 141, 16, 16);
        }
        ItemStack gunStack = ((EquipmentMenu)this.f_97732_).getGunStack();
        gunStack.getCapability(Gun.CAPABILITY).ifPresent(gun -> {
            boolean carriedItemAccepted;
            int gunSlotX = this.f_97735_ + 135;
            int gunSlotY = this.f_97736_ + 26;
            boolean bl = carriedItemAccepted = gun.isAcceptedAttachment(((EquipmentMenu)this.f_97732_).m_142621_()) || Paint.isValid(((EquipmentMenu)this.f_97732_).getGunStack(), ((EquipmentMenu)this.f_97732_).m_142621_());
            if (!((EquipmentMenu)this.f_97732_).isCraftingInventoryEmpty() && ((EquipmentMenu)this.f_97732_).isCraftable() || !((EquipmentMenu)this.f_97732_).m_142621_().m_41619_() && carriedItemAccepted) {
                this.m_93228_(poseStack, gunSlotX, gunSlotY, 165, 238, 16, 16);
            } else if (!((EquipmentMenu)this.f_97732_).m_142621_().m_41619_() && !carriedItemAccepted) {
                this.m_93228_(poseStack, gunSlotX, gunSlotY, 147, 238, 16, 16);
            }
        });
        this.m_93228_(poseStack, this.f_97735_, this.f_97736_ - 28, 183, 0, 28, 35);
        this.m_93228_(poseStack, this.f_97735_ + 30, this.f_97736_ - 28, 211, 0, 29, 28);
        this.renderFakeItems();
        this.renderInteractiveTooltips(poseStack, mouseX, mouseY);
        this.renderPlayerEntity();
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.isMouseOver(this.f_97735_ + 30, this.f_97736_ - 28, 29, 28, mouseX, mouseY)) {
            if (this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
                this.f_96541_.f_91074_.m_5496_(SoundEvents.f_12490_, 0.2f, 1.0f);
            }
            NetworkChannel.PLAY.getSimpleChannel().sendToServer((Object)new OpenCraftingMenuMessage());
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (ClientDist.OPEN_EQUIPMENT_MENU.m_90832_(keyCode, scanCode)) {
            this.m_7379_();
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    private void renderFakeItems() {
        this.f_96542_.m_115218_(new ItemStack((ItemLike)ModItems.MEDIUM_BLUE_BACKPACK.get()), this.f_97735_ + 6, this.f_97736_ - 20);
        this.f_96542_.m_115218_(new ItemStack((ItemLike)ModItems.PICKAXE.get()), this.f_97735_ + 36, this.f_97736_ - 22);
    }

    private void renderInteractiveTooltips(PoseStack poseStack, int mouseX, int mouseY) {
        if (this.isMouseOver(this.f_97735_, this.f_97736_ - 28, 29, 28, mouseX, mouseY)) {
            this.m_96602_(poseStack, (Component)new TranslatableComponent("inventory_inventory.information"), mouseX, mouseY);
        }
        if (this.isMouseOver(this.f_97735_ + 30, this.f_97736_ - 28, 29, 28, mouseX, mouseY)) {
            this.m_96602_(poseStack, (Component)new TranslatableComponent("inventory_crafting.information"), mouseX, mouseY);
        }
    }

    private void renderPlayerEntity() {
        if (this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
            InventoryScreen.m_98850_((int)(this.f_97735_ + 51), (int)(this.f_97736_ + 72), (int)30, (float)(this.f_97735_ + 51 - this.oldMouseX), (float)(this.f_97736_ + 75 - 50 - this.oldMouseY), (LivingEntity)this.f_96541_.f_91074_);
        }
    }

    private boolean isMouseOver(int x, int y, int width, int height, double mouseX, double mouseY) {
        return mouseX >= (double)x && mouseX <= (double)(x + width) && mouseY >= (double)y && mouseY <= (double)(y + height);
    }
}

